/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal.jmx;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.MessageListenerRegistry;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.messaging.internal.jmx.DestinationStatisticsManager;
import com.liferay.portal.messaging.internal.jmx.MessageBusManagerMBean;
import java.util.Dictionary;
import java.util.List;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component(property={"jmx.objectname=com.liferay.portal.messaging:classification=message_bus,name=MessageBusManager", "jmx.objectname.cache.key=MessageBusManager"}, service={DynamicMBean.class})
public class MessageBusManager
extends StandardMBean
implements MessageBusManagerMBean {
    private static final Log _log = LogFactoryUtil.getLog(MessageBusManager.class);
    @Reference
    private MessageListenerRegistry _messageListenerRegistry;
    private ServiceTracker<Destination, ServiceRegistration<DynamicMBean>> _serviceTracker;

    public MessageBusManager() throws NotCompliantMBeanException {
        super(MessageBusManagerMBean.class);
    }

    @Override
    public int getDestinationCount() {
        return this._serviceTracker.size();
    }

    @Override
    public int getMessageListenerCount(String destinationName) {
        List messageListeners = this._messageListenerRegistry.getMessageListeners(destinationName);
        return messageListeners.size();
    }

    @Activate
    protected void activate(final BundleContext bundleContext) throws InvalidSyntaxException {
        this._serviceTracker = new ServiceTracker(bundleContext, bundleContext.createFilter(StringBundler.concat((String[])new String[]{"(&(objectClass=", Destination.class.getName(), ")(destination.name=*))"})), (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Destination, ServiceRegistration<DynamicMBean>>(){

            public ServiceRegistration<DynamicMBean> addingService(ServiceReference<Destination> serviceReference) {
                ServiceRegistration serviceRegistration;
                block2: {
                    serviceRegistration = null;
                    Destination destination = (Destination)bundleContext.getService(serviceReference);
                    try {
                        DestinationStatisticsManager destinationStatisticsManager = new DestinationStatisticsManager(destination);
                        HashMapDictionary mBeanProperties = HashMapDictionaryBuilder.put((Object)"jmx.objectname", (Object)destinationStatisticsManager.getObjectName()).put((Object)"jmx.objectname.cache.key", (Object)destinationStatisticsManager.getObjectNameCacheKey()).build();
                        serviceRegistration = bundleContext.registerService(DynamicMBean.class, (Object)destinationStatisticsManager, (Dictionary)mBeanProperties);
                    }
                    catch (NotCompliantMBeanException notCompliantMBeanException) {
                        if (!_log.isInfoEnabled()) break block2;
                        _log.info((Object)"Unable to register destination mbean", (Throwable)notCompliantMBeanException);
                    }
                }
                return serviceRegistration;
            }

            public void modifiedService(ServiceReference<Destination> serviceReference, ServiceRegistration<DynamicMBean> serviceRegistration) {
            }

            public void removedService(ServiceReference<Destination> serviceReference, ServiceRegistration<DynamicMBean> serviceRegistration) {
                bundleContext.ungetService(serviceReference);
                serviceRegistration.unregister();
            }
        });
        this._serviceTracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTracker.close();
    }
}

