/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal;

import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.concurrent.NoticeableThreadPoolExecutor;
import com.liferay.petra.concurrent.ThreadPoolHandler;
import com.liferay.petra.concurrent.ThreadPoolHandlerAdapter;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseDestination;
import com.liferay.portal.kernel.messaging.DestinationStatistics;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.messaging.MessageRunnable;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.NamedThreadFactory;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public abstract class BaseAsyncDestination
extends BaseDestination {
    protected PermissionCheckerFactory permissionCheckerFactory;
    protected UserLocalService userLocalService;
    private static final int _WORKERS_CORE_SIZE = 2;
    private static final int _WORKERS_MAX_SIZE = 5;
    private static final Log _log = LogFactoryUtil.getLog(BaseAsyncDestination.class);
    private int _maximumQueueSize = Integer.MAX_VALUE;
    private NoticeableThreadPoolExecutor _noticeableThreadPoolExecutor;
    private PortalExecutorManager _portalExecutorManager;
    private RejectedExecutionHandler _rejectedExecutionHandler;
    private int _workersCoreSize = 2;
    private int _workersMaxSize = 5;

    public void close(boolean force) {
        if (this._noticeableThreadPoolExecutor == null || this._noticeableThreadPoolExecutor.isShutdown()) {
            return;
        }
        if (force) {
            this._noticeableThreadPoolExecutor.shutdownNow();
        } else {
            this._noticeableThreadPoolExecutor.shutdown();
        }
    }

    public DestinationStatistics getDestinationStatistics() {
        DestinationStatistics destinationStatistics = new DestinationStatistics();
        destinationStatistics.setActiveThreadCount(this._noticeableThreadPoolExecutor.getActiveCount());
        destinationStatistics.setCurrentThreadCount(this._noticeableThreadPoolExecutor.getPoolSize());
        destinationStatistics.setLargestThreadCount(this._noticeableThreadPoolExecutor.getLargestPoolSize());
        destinationStatistics.setMaxThreadPoolSize(this._noticeableThreadPoolExecutor.getMaximumPoolSize());
        destinationStatistics.setMinThreadPoolSize(this._noticeableThreadPoolExecutor.getCorePoolSize());
        destinationStatistics.setPendingMessageCount((long)this._noticeableThreadPoolExecutor.getPendingTaskCount());
        destinationStatistics.setSentMessageCount(this._noticeableThreadPoolExecutor.getCompletedTaskCount());
        return destinationStatistics;
    }

    public int getMaximumQueueSize() {
        return this._maximumQueueSize;
    }

    public int getWorkersCoreSize() {
        return this._workersCoreSize;
    }

    public int getWorkersMaxSize() {
        return this._workersMaxSize;
    }

    public void open() {
        if (this._noticeableThreadPoolExecutor != null && !this._noticeableThreadPoolExecutor.isShutdown()) {
            return;
        }
        if (this._rejectedExecutionHandler == null) {
            this._rejectedExecutionHandler = this._createRejectionExecutionHandler();
        }
        NoticeableThreadPoolExecutor noticeableThreadPoolExecutor = new NoticeableThreadPoolExecutor(this._workersCoreSize, this._workersMaxSize, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue(this._maximumQueueSize), (ThreadFactory)new NamedThreadFactory(this.getName(), 5, PortalClassLoaderUtil.getClassLoader()), this._rejectedExecutionHandler, (ThreadPoolHandler)new ThreadPoolHandlerAdapter());
        NoticeableExecutorService oldNoticeableExecutorService = this._portalExecutorManager.registerPortalExecutor(this.getName(), (NoticeableExecutorService)noticeableThreadPoolExecutor);
        if (oldNoticeableExecutorService != null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Abort creating a new thread pool for destination " + this.getName() + " and reuse previous one"));
            }
            noticeableThreadPoolExecutor.shutdownNow();
            noticeableThreadPoolExecutor = (NoticeableThreadPoolExecutor)oldNoticeableExecutorService;
        }
        this._noticeableThreadPoolExecutor = noticeableThreadPoolExecutor;
    }

    public void send(Message message) {
        if (this.messageListeners.isEmpty()) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("No message listeners for destination " + this.getName()));
            }
            return;
        }
        NoticeableThreadPoolExecutor noticeableThreadPoolExecutor = this._noticeableThreadPoolExecutor;
        if (noticeableThreadPoolExecutor.isShutdown()) {
            throw new IllegalStateException(StringBundler.concat((String[])new String[]{"Destination ", this.getName(), " is shutdown and cannot ", "receive more messages"}));
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Sending message ", message, " from destination ", this.getName(), " to message listeners ", this.messageListeners}));
        }
        this.dispatch(this.messageListeners, message);
    }

    public void setMaximumQueueSize(int maximumQueueSize) {
        this._maximumQueueSize = maximumQueueSize;
    }

    public void setPermissionCheckerFactory(PermissionCheckerFactory permissionCheckerFactory) {
        this.permissionCheckerFactory = permissionCheckerFactory;
    }

    public void setPortalExecutorManager(PortalExecutorManager portalExecutorManager) {
        this._portalExecutorManager = portalExecutorManager;
    }

    public void setRejectedExecutionHandler(RejectedExecutionHandler rejectedExecutionHandler) {
        this._rejectedExecutionHandler = rejectedExecutionHandler;
    }

    public void setUserLocalService(UserLocalService userLocalService) {
        this.userLocalService = userLocalService;
    }

    @Deprecated
    public void setWorkersCoreSize(int workersCoreSize) {
        this._workersCoreSize = workersCoreSize;
        if (this._noticeableThreadPoolExecutor != null) {
            this._noticeableThreadPoolExecutor.setCorePoolSize(workersCoreSize);
        }
    }

    @Deprecated
    public void setWorkersMaxSize(int workersMaxSize) {
        this._workersMaxSize = workersMaxSize;
        if (this._noticeableThreadPoolExecutor != null) {
            this._noticeableThreadPoolExecutor.setMaximumPoolSize(workersMaxSize);
        }
    }

    public void setWorkersSize(int workersCoreSize, int workersMaxSize) {
        if (workersCoreSize < 1) {
            throw new IllegalArgumentException("To ensure FIFO, core pool size must be 1 or greater");
        }
        if (workersMaxSize <= 0 || workersMaxSize < workersCoreSize) {
            throw new IllegalArgumentException("Maximum pool size must be greater than 0 and core pool size");
        }
        this._workersCoreSize = workersCoreSize;
        this._workersMaxSize = workersMaxSize;
        if (this._noticeableThreadPoolExecutor != null) {
            this._noticeableThreadPoolExecutor.setCorePoolSize(workersCoreSize);
            this._noticeableThreadPoolExecutor.setMaximumPoolSize(workersMaxSize);
        }
    }

    protected abstract void dispatch(Set<MessageListener> var1, Message var2);

    protected void execute(Runnable runnable) {
        this._noticeableThreadPoolExecutor.execute(runnable);
    }

    private RejectedExecutionHandler _createRejectionExecutionHandler() {
        return new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (!_log.isWarnEnabled()) {
                    return;
                }
                MessageRunnable messageRunnable = (MessageRunnable)runnable;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Discarding message ", messageRunnable.getMessage(), " because it exceeds the maximum queue size of ", BaseAsyncDestination.this._maximumQueueSize}));
            }
        };
    }
}

