/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.messaging.internal.sender;

import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.messaging.MessageBusException;
import com.liferay.portal.kernel.messaging.MessageListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SynchronousMessageListener
implements MessageListener {
    private final CountDownLatch _countDownLatch = new CountDownLatch(1);
    private final EntityCache _entityCache;
    private final FinderCache _finderCache;
    private final Message _message;
    private final MessageBus _messageBus;
    private final String _responseId;
    private Object _results;
    private final long _timeout;

    public SynchronousMessageListener(MessageBus messageBus, Message message, long timeout, EntityCache entityCache, FinderCache finderCache) {
        this._messageBus = messageBus;
        this._message = message;
        this._timeout = timeout;
        this._entityCache = entityCache;
        this._finderCache = finderCache;
        this._responseId = this._message.getResponseId();
    }

    public Object getResults() {
        return this._results;
    }

    public void receive(Message message) {
        String responseId = message.getResponseId();
        if (!responseId.equals(this._responseId)) {
            return;
        }
        this._results = message.getPayload();
        this._countDownLatch.countDown();
    }

    public Object send() throws MessageBusException {
        String destinationName = this._message.getDestinationName();
        String responseDestinationName = this._message.getResponseDestinationName();
        this._messageBus.registerMessageListener(responseDestinationName, (MessageListener)this);
        try {
            this._messageBus.sendMessage(destinationName, this._message);
            this._countDownLatch.await(this._timeout, TimeUnit.MILLISECONDS);
            if (this._results == null) {
                throw new MessageBusException("No reply received for message: " + this._message);
            }
            Object object = this._results;
            return object;
        }
        catch (InterruptedException interruptedException) {
            throw new MessageBusException("Message sending interrupted for: " + this._message, (Throwable)interruptedException);
        }
        finally {
            this._messageBus.unregisterMessageListener(responseDestinationName, (MessageListener)this);
            this._entityCache.clearLocalCache();
            this._finderCache.clearLocalCache();
            ThreadLocalCacheManager.destroy();
        }
    }
}

