/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.mobile.device.recognition.internal.rule.group;

import com.liferay.mobile.device.rules.action.ActionHandler;
import com.liferay.mobile.device.rules.action.ActionHandlerManager;
import com.liferay.mobile.device.rules.model.MDRAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={ActionHandlerManager.class})
public class DefaultActionHandlerManagerImpl
implements ActionHandlerManager {
    private static final Log _log = LogFactoryUtil.getLog(DefaultActionHandlerManagerImpl.class);
    private final Map<String, ActionHandler> _deviceActionHandlers = new HashMap<String, ActionHandler>();

    public void applyActions(List<MDRAction> mdrActions, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        for (MDRAction mdrAction : mdrActions) {
            this.applyAction(mdrAction, httpServletRequest, httpServletResponse);
        }
    }

    public ActionHandler getActionHandler(String actionType) {
        return this._deviceActionHandlers.get(actionType);
    }

    public Collection<ActionHandler> getActionHandlers() {
        return Collections.unmodifiableCollection(this._deviceActionHandlers.values());
    }

    public Collection<String> getActionHandlerTypes() {
        return this._deviceActionHandlers.keySet();
    }

    public void registerActionHandler(ActionHandler actionHandler) {
        this.addActionHandler(actionHandler);
    }

    public ActionHandler unregisterActionHandler(String actionType) {
        return this._deviceActionHandlers.remove(actionType);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addActionHandler(ActionHandler actionHandler) {
        ActionHandler oldActionHandler = this._deviceActionHandlers.put(actionHandler.getType(), actionHandler);
        if (oldActionHandler != null && _log.isWarnEnabled()) {
            _log.warn((Object)("Replacing existing action handler type " + actionHandler.getType()));
        }
    }

    protected void applyAction(MDRAction mdrAction, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        ActionHandler actionHandler = this._deviceActionHandlers.get(mdrAction.getType());
        if (actionHandler != null) {
            actionHandler.applyAction(mdrAction, httpServletRequest, httpServletResponse);
        } else if (_log.isWarnEnabled()) {
            _log.warn((Object)("No action handler registered for type " + mdrAction.getType()));
        }
    }

    protected void removeActionHandler(ActionHandler actionHandler) {
        this._deviceActionHandlers.remove(actionHandler.getType());
    }
}

