/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.messaging;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.monitoring.DataSample;
import com.liferay.portal.kernel.monitoring.DataSampleProcessor;
import com.liferay.portal.kernel.monitoring.Level;
import com.liferay.portal.kernel.monitoring.MonitoringControl;
import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(enabled=false, immediate=true, property={"destination.name=liferay/monitoring"}, service={MessageListener.class, MonitoringControl.class})
public class MonitoringMessageListener
extends BaseMessageListener
implements MonitoringControl {
    private static final Log _log = LogFactoryUtil.getLog(MonitoringMessageListener.class);
    private final Map<String, List<DataSampleProcessor<DataSample>>> _dataSampleProcessors = new ConcurrentHashMap<String, List<DataSampleProcessor<DataSample>>>();
    private final Map<String, Level> _levels = new ConcurrentHashMap<String, Level>();

    public Level getLevel(String namespace) {
        Level level = this._levels.get(namespace);
        if (level == null) {
            return Level.OFF;
        }
        return level;
    }

    public Set<String> getNamespaces() {
        return this._levels.keySet();
    }

    public void processDataSample(DataSample dataSample) throws MonitoringException {
        String namespace = dataSample.getNamespace();
        Level level = this._levels.get(namespace);
        if (level != null && level.equals((Object)Level.OFF)) {
            return;
        }
        List<DataSampleProcessor<DataSample>> dataSampleProcessors = this._dataSampleProcessors.get(namespace);
        if (ListUtil.isEmpty(dataSampleProcessors)) {
            return;
        }
        for (DataSampleProcessor<DataSample> dataSampleProcessor : dataSampleProcessors) {
            dataSampleProcessor.processDataSample(dataSample);
        }
    }

    public void setLevel(String namespace, Level level) {
        this._levels.put(namespace, level);
    }

    public void setLevels(Map<String, String> levels) {
        for (Map.Entry<String, String> entry : levels.entrySet()) {
            String namespace = entry.getKey();
            String levelName = entry.getValue();
            Level level = Level.valueOf((String)levelName);
            this._levels.put(namespace, level);
        }
    }

    protected void doReceive(Message message) throws Exception {
        List dataSamples = (List)message.getPayload();
        if (ListUtil.isNotEmpty((List)dataSamples)) {
            for (DataSample dataSample : dataSamples) {
                this.processDataSample(dataSample);
            }
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected synchronized void registerDataSampleProcessor(DataSampleProcessor<DataSample> dataSampleProcessor, Map<String, Object> properties) {
        String namespace = (String)properties.get("namespace");
        if (Validator.isNull((String)namespace)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No namespace defined for service " + dataSampleProcessor.getClass()));
            }
            return;
        }
        List<DataSampleProcessor<DataSample>> dataSampleProcessors = this._dataSampleProcessors.get(namespace);
        if (dataSampleProcessors == null) {
            dataSampleProcessors = new ArrayList<DataSampleProcessor<DataSample>>();
            this._dataSampleProcessors.put(namespace, dataSampleProcessors);
        }
        dataSampleProcessors.add(dataSampleProcessor);
    }

    @Reference(target="(destination.name=liferay/monitoring)", unbind="-")
    protected void setDestination(Destination destination) {
    }

    protected synchronized void unregisterDataSampleProcessor(DataSampleProcessor<DataSample> dataSampleProcessor, Map<String, Object> properties) {
        String namespace = (String)properties.get("namespace");
        if (Validator.isNull((String)namespace)) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("No namespace defined for service " + dataSampleProcessor.getClass()));
            }
            return;
        }
        List<DataSampleProcessor<DataSample>> dataSampleProcessors = this._dataSampleProcessors.get(namespace);
        if (dataSampleProcessors != null) {
            dataSampleProcessors.remove(dataSampleProcessor);
        }
    }
}

