/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.statistics.portal;

import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.monitoring.DataSampleProcessor;
import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.monitoring.internal.statistics.portal.CompanyStatistics;
import com.liferay.portal.monitoring.internal.statistics.portal.PortalRequestDataSample;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"namespace=com.liferay.monitoring.Portal"}, service={DataSampleProcessor.class, ServerStatistics.class})
public class ServerStatistics
implements DataSampleProcessor<PortalRequestDataSample> {
    private CompanyLocalService _companyLocalService;
    private final Map<Long, CompanyStatistics> _companyStatisticsByCompanyId = new TreeMap<Long, CompanyStatistics>();
    private final Map<String, CompanyStatistics> _companyStatisticsByWebId = new TreeMap<String, CompanyStatistics>();

    public Set<Long> getCompanyIds() {
        return this._companyStatisticsByCompanyId.keySet();
    }

    public CompanyStatistics getCompanyStatistics(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._companyStatisticsByCompanyId.get(companyId);
        if (companyStatistics == null) {
            throw new MonitoringException("No statistics found for company id " + companyId);
        }
        return companyStatistics;
    }

    public CompanyStatistics getCompanyStatistics(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._companyStatisticsByWebId.get(webId);
        if (companyStatistics == null) {
            throw new MonitoringException("No statistics found for web id " + webId);
        }
        return companyStatistics;
    }

    public Set<CompanyStatistics> getCompanyStatisticsSet() {
        return new HashSet<CompanyStatistics>(this._companyStatisticsByWebId.values());
    }

    public Set<String> getWebIds() {
        return this._companyStatisticsByWebId.keySet();
    }

    public void processDataSample(PortalRequestDataSample portalRequestDataSample) {
        long companyId = portalRequestDataSample.getCompanyId();
        CompanyStatistics companyStatistics = this._companyStatisticsByCompanyId.get(companyId);
        if (companyStatistics == null) {
            try {
                Company company = this._companyLocalService.getCompany(companyId);
                companyStatistics = this.register(company.getWebId());
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unable to get company with company id " + companyId, exception);
            }
        }
        companyStatistics.processDataSample(portalRequestDataSample);
    }

    public synchronized CompanyStatistics register(String webId) {
        CompanyStatistics companyStatistics = new CompanyStatistics(this._companyLocalService, webId);
        this._companyStatisticsByCompanyId.put(companyStatistics.getCompanyId(), companyStatistics);
        this._companyStatisticsByWebId.put(webId, companyStatistics);
        return companyStatistics;
    }

    public void reset() {
        for (long companyId : this._companyStatisticsByCompanyId.keySet()) {
            this.reset(companyId);
        }
    }

    public void reset(long companyId) {
        CompanyStatistics companyStatistics = this._companyStatisticsByCompanyId.get(companyId);
        if (companyStatistics == null) {
            return;
        }
        companyStatistics.reset();
    }

    public void reset(String webId) {
        CompanyStatistics companyStatistics = this._companyStatisticsByWebId.get(webId);
        if (companyStatistics == null) {
            return;
        }
        companyStatistics.reset();
    }

    public synchronized void unregister(String webId) {
        CompanyStatistics companyStatistics = this._companyStatisticsByWebId.remove(webId);
        if (companyStatistics != null) {
            this._companyStatisticsByCompanyId.remove(companyStatistics.getCompanyId());
        }
    }

    @Activate
    protected void activate() {
        CompanyStatistics companyStatistics = new CompanyStatistics();
        this._companyStatisticsByCompanyId.put(companyStatistics.getCompanyId(), companyStatistics);
        this._companyStatisticsByWebId.put(companyStatistics.getWebId(), companyStatistics);
    }

    @Reference(unbind="-")
    protected void setCompanyLocalService(CompanyLocalService companyLocalService) {
        this._companyLocalService = companyLocalService;
    }
}

