/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.statistics.portlet;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.monitoring.PortletRequestType;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GroupThreadLocal;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.monitoring.internal.BaseDataSample;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;

public class PortletRequestDataSample
extends BaseDataSample {
    private static final Log _log = LogFactoryUtil.getLog(PortletRequestDataSample.class);
    private final String _displayName;
    private final String _portletId;
    private final PortletRequestType _requestType;

    public PortletRequestDataSample(PortletRequestType requestType, PortletRequest portletRequest, PortletResponse portletResponse, Portal portal) {
        this._requestType = requestType;
        LiferayPortletResponse liferayPortletResponse = PortalUtil.getLiferayPortletResponse((PortletResponse)portletResponse);
        Portlet portlet = liferayPortletResponse.getPortlet();
        this.setCompanyId(portlet.getCompanyId());
        this.setGroupId(portletRequest, portal);
        this.setName(portlet.getPortletName());
        this.setNamespace("com.liferay.monitoring.Portlet");
        this.setUser(portletRequest.getRemoteUser());
        this._displayName = portlet.getDisplayName();
        this._portletId = portlet.getPortletId();
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public String getPortletId() {
        return this._portletId;
    }

    public PortletRequestType getRequestType() {
        return this._requestType;
    }

    @Override
    public String toString() {
        StringBundler sb = new StringBundler(9);
        sb.append("{displayName=");
        sb.append(this._displayName);
        sb.append(", portletId=");
        sb.append(this._portletId);
        sb.append(", requestType=");
        sb.append((Object)this._requestType);
        sb.append(", ");
        sb.append(super.toString());
        sb.append("}");
        return sb.toString();
    }

    protected void setGroupId(PortletRequest portletRequest, Portal portal) {
        block5: {
            long groupId = GroupThreadLocal.getGroupId();
            if (groupId != 0L) {
                this.setGroupId(groupId);
                return;
            }
            if (portal == null) {
                return;
            }
            HttpServletRequest httpServletRequest = portal.getHttpServletRequest(portletRequest);
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (themeDisplay != null) {
                groupId = themeDisplay.getScopeGroupId();
                this.setGroupId(groupId);
                return;
            }
            try {
                groupId = portal.getScopeGroupId(portletRequest);
                this.setGroupId(groupId);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block5;
                _log.debug((Object)"Unable to obtain scope group ID", (Throwable)portalException);
            }
        }
    }
}

