/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.statistics.portlet;

import com.liferay.portal.kernel.monitoring.DataSampleProcessor;
import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.kernel.monitoring.PortletRequestType;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import com.liferay.portal.monitoring.internal.statistics.RequestStatistics;
import com.liferay.portal.monitoring.internal.statistics.portlet.PortletRequestDataSample;
import java.util.HashMap;
import java.util.Map;

public class PortletStatistics
implements DataSampleProcessor<PortletRequestDataSample> {
    private final RequestStatistics _actionRequestStatistics;
    private final String _displayName;
    private final RequestStatistics _eventRequestStatistics;
    private final RequestStatistics _headerRequestStatistics;
    private final String _portletId;
    private final String _portletName;
    private final RequestStatistics _renderRequestStatistics;
    private final Map<PortletRequestType, RequestStatistics> _requestStatistics = new HashMap<PortletRequestType, RequestStatistics>();
    private final RequestStatistics _resourceRequestStatistics;

    public PortletStatistics(String portletId, String portletName, String displayName) {
        this._portletId = portletId;
        this._portletName = portletName;
        this._displayName = displayName;
        this._actionRequestStatistics = new RequestStatistics(portletId);
        this._eventRequestStatistics = new RequestStatistics(portletId);
        this._headerRequestStatistics = new RequestStatistics(portletId);
        this._renderRequestStatistics = new RequestStatistics(portletId);
        this._resourceRequestStatistics = new RequestStatistics(portletId);
        this._requestStatistics.put(PortletRequestType.ACTION, this._actionRequestStatistics);
        this._requestStatistics.put(PortletRequestType.EVENT, this._eventRequestStatistics);
        this._requestStatistics.put(PortletRequestType.HEADER, this._headerRequestStatistics);
        this._requestStatistics.put(PortletRequestType.RENDER, this._renderRequestStatistics);
        this._requestStatistics.put(PortletRequestType.RESOURCE, this._resourceRequestStatistics);
    }

    public RequestStatistics getActionRequestStatistics() {
        return this._actionRequestStatistics;
    }

    public String getDisplayName() {
        return this._displayName;
    }

    public RequestStatistics getEventRequestStatistics() {
        return this._eventRequestStatistics;
    }

    public String getPortletId() {
        return this._portletId;
    }

    public String getPortletName() {
        return this._portletName;
    }

    public RequestStatistics getRenderRequestStatistics() {
        return this._renderRequestStatistics;
    }

    public RequestStatistics getResourceRequestStatistics() {
        return this._resourceRequestStatistics;
    }

    public void processDataSample(PortletRequestDataSample portletRequestDataSample) throws MonitoringException {
        String portletId = portletRequestDataSample.getPortletId();
        if (!portletId.equals(this._portletId)) {
            return;
        }
        PortletRequestType portletRequestType = portletRequestDataSample.getRequestType();
        RequestStatistics requestStatistics = this._requestStatistics.get(portletRequestType);
        if (requestStatistics == null) {
            throw new MonitoringException("No statistics found for " + portletRequestDataSample);
        }
        RequestStatus requestStatus = portletRequestDataSample.getRequestStatus();
        if (requestStatus.equals((Object)RequestStatus.ERROR)) {
            requestStatistics.incrementError();
        } else if (requestStatus.equals((Object)RequestStatus.SUCCESS)) {
            requestStatistics.incrementSuccessDuration(portletRequestDataSample.getDuration());
        } else if (requestStatus.equals((Object)RequestStatus.TIMEOUT)) {
            requestStatistics.incrementTimeout();
        }
    }

    public void reset() {
        this._actionRequestStatistics.reset();
        this._eventRequestStatistics.reset();
        this._headerRequestStatistics.reset();
        this._renderRequestStatistics.reset();
        this._resourceRequestStatistics.reset();
    }
}

