/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.monitoring.DataSample;
import com.liferay.portal.kernel.monitoring.RequestStatus;
import java.io.Serializable;
import java.util.Map;
import org.apache.commons.lang.time.StopWatch;

public class BaseDataSample
implements DataSample,
Serializable {
    private Map<String, String> _attributes;
    private long _companyId;
    private String _description;
    private long _duration;
    private long _groupId;
    private String _name;
    private String _namespace;
    private RequestStatus _requestStatus;
    private transient StopWatch _stopWatch;
    private long _timeout = -1L;
    private String _user;

    public void capture(RequestStatus requestStatus) {
        if (this._stopWatch != null) {
            this._stopWatch.stop();
            this._duration = this._stopWatch.getTime();
        }
        this._requestStatus = this._timeout > 0L && this._duration >= this._timeout && requestStatus != RequestStatus.ERROR ? RequestStatus.TIMEOUT : requestStatus;
    }

    public Map<String, String> getAttributes() {
        return this._attributes;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public String getDescription() {
        return this._description;
    }

    public long getDuration() {
        return this._duration;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public String getName() {
        return this._name;
    }

    public String getNamespace() {
        return this._namespace;
    }

    public RequestStatus getRequestStatus() {
        return this._requestStatus;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public String getUser() {
        return this._user;
    }

    public void prepare() {
        if (this._stopWatch == null) {
            this._stopWatch = new StopWatch();
        }
        this._stopWatch.start();
    }

    public void setAttributes(Map<String, String> attributes) {
        this._attributes = attributes;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setGroupId(long groupId) {
        this._groupId = groupId;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setNamespace(String namespace) {
        this._namespace = namespace;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public void setUser(String user) {
        this._user = user;
    }

    public String toString() {
        StringBundler sb = new StringBundler(23);
        sb.append("{attributes=");
        sb.append(this._attributes);
        sb.append(", companyId=");
        sb.append(this._companyId);
        sb.append(", groupId=");
        sb.append(this._groupId);
        sb.append(", description=");
        sb.append(this._description);
        sb.append(", duration=");
        sb.append(this._duration);
        sb.append(", name=");
        sb.append(this._name);
        sb.append(", namespace=");
        sb.append(this._namespace);
        sb.append(", requestStatus=");
        sb.append((Object)this._requestStatus);
        sb.append(", stopWatch=");
        sb.append((Object)this._stopWatch);
        sb.append(", timeout=");
        sb.append(this._timeout);
        sb.append(", user=");
        sb.append(this._user);
        sb.append("}");
        return sb.toString();
    }
}

