/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.statistics.portal;

import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.monitoring.internal.statistics.RequestStatistics;
import com.liferay.portal.monitoring.internal.statistics.SummaryStatistics;
import com.liferay.portal.monitoring.internal.statistics.portal.CompanyStatistics;
import com.liferay.portal.monitoring.internal.statistics.portal.ServerStatistics;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, immediate=true, property={"name=portalSummaryStatistics"}, service={ServerSummaryStatistics.class})
public class ServerSummaryStatistics
implements SummaryStatistics {
    private ServerStatistics _serverStatistics;

    @Override
    public long getAverageTime() {
        Set<CompanyStatistics> companyStatisticsSet = this._serverStatistics.getCompanyStatisticsSet();
        if (companyStatisticsSet.isEmpty()) {
            return 0L;
        }
        long averageTime = 0L;
        for (CompanyStatistics companyStatistics : companyStatisticsSet) {
            RequestStatistics requestStatistics = companyStatistics.getRequestStatistics();
            averageTime += requestStatistics.getAverageTime();
        }
        return averageTime / (long)companyStatisticsSet.size();
    }

    @Override
    public long getAverageTimeByCompany(long companyId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(companyId);
        return requestStatistics.getAverageTime();
    }

    @Override
    public long getAverageTimeByCompany(String webId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(webId);
        return requestStatistics.getAverageTime();
    }

    @Override
    public long getErrorCount() {
        int errorCount = 0;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            RequestStatistics requestStatistics = companyStatistics.getRequestStatistics();
            errorCount = (int)((long)errorCount + requestStatistics.getErrorCount());
        }
        return errorCount;
    }

    @Override
    public long getErrorCountByCompany(long companyId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(companyId);
        return requestStatistics.getErrorCount();
    }

    @Override
    public long getErrorCountByCompany(String webId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(webId);
        return requestStatistics.getErrorCount();
    }

    @Override
    public long getMaxTime() {
        long maxTime = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            if (companyStatistics.getMaxTime() <= maxTime) continue;
            maxTime = companyStatistics.getMaxTime();
        }
        return maxTime;
    }

    @Override
    public long getMaxTimeByCompany(long companyId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(companyId);
        return requestStatistics.getMaxTime();
    }

    @Override
    public long getMaxTimeByCompany(String webId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(webId);
        return requestStatistics.getMaxTime();
    }

    @Override
    public long getMinTime() {
        long minTime = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            if (companyStatistics.getMinTime() >= minTime) continue;
            minTime = companyStatistics.getMinTime();
        }
        return minTime;
    }

    @Override
    public long getMinTimeByCompany(long companyId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(companyId);
        return requestStatistics.getMinTime();
    }

    @Override
    public long getMinTimeByCompany(String webId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(webId);
        return requestStatistics.getMinTime();
    }

    @Override
    public long getRequestCount() {
        int requestCount = 0;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            RequestStatistics requestStatistics = companyStatistics.getRequestStatistics();
            requestCount = (int)((long)requestCount + requestStatistics.getRequestCount());
        }
        return requestCount;
    }

    @Override
    public long getRequestCountByCompany(long companyId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(companyId);
        return requestStatistics.getRequestCount();
    }

    @Override
    public long getRequestCountByCompany(String webId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(webId);
        return requestStatistics.getRequestCount();
    }

    @Override
    public long getSuccessCount() {
        int successCount = 0;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            RequestStatistics requestStatistics = companyStatistics.getRequestStatistics();
            successCount = (int)((long)successCount + requestStatistics.getSuccessCount());
        }
        return successCount;
    }

    @Override
    public long getSuccessCountByCompany(long companyId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(companyId);
        return requestStatistics.getSuccessCount();
    }

    @Override
    public long getSuccessCountByCompany(String webId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(webId);
        return requestStatistics.getSuccessCount();
    }

    @Override
    public long getTimeoutCount() {
        int timeoutCount = 0;
        for (CompanyStatistics companyStatistics : this._serverStatistics.getCompanyStatisticsSet()) {
            RequestStatistics requestStatistics = companyStatistics.getRequestStatistics();
            timeoutCount = (int)((long)timeoutCount + requestStatistics.getTimeoutCount());
        }
        return timeoutCount;
    }

    @Override
    public long getTimeoutCountByCompany(long companyId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(companyId);
        return requestStatistics.getTimeoutCount();
    }

    @Override
    public long getTimeoutCountByCompany(String webId) throws MonitoringException {
        RequestStatistics requestStatistics = this.getRequestStatistics(webId);
        return requestStatistics.getTimeoutCount();
    }

    protected RequestStatistics getRequestStatistics(long companyId) throws MonitoringException {
        try {
            CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(companyId);
            return companyStatistics.getRequestStatistics();
        }
        catch (Exception exception) {
            throw new MonitoringException("Unable to get company with company ID " + companyId, (Throwable)exception);
        }
    }

    protected RequestStatistics getRequestStatistics(String webId) throws MonitoringException {
        try {
            CompanyStatistics companyStatistics = this._serverStatistics.getCompanyStatistics(webId);
            return companyStatistics.getRequestStatistics();
        }
        catch (Exception exception) {
            throw new MonitoringException("Unable to get company with web ID " + webId, (Throwable)exception);
        }
    }

    @Reference(unbind="-")
    protected void setServerStatistics(ServerStatistics serverStatistics) {
        this._serverStatistics = serverStatistics;
    }
}

