/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.jmx;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.monitoring.Level;
import com.liferay.portal.kernel.monitoring.MethodSignature;
import com.liferay.portal.kernel.monitoring.MonitoringControl;
import com.liferay.portal.kernel.monitoring.PortalMonitoringControl;
import com.liferay.portal.kernel.monitoring.PortletMonitoringControl;
import com.liferay.portal.kernel.monitoring.ServiceMonitoringControl;
import com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration;
import com.liferay.portal.monitoring.internal.jmx.MonitoringConfigurationManagerMBean;
import java.util.Map;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.portal.monitoring.internal.configuration.MonitoringConfiguration"}, enabled=false, property={"jmx.objectname=com.liferay.portal.monitoring:classification=monitoring_service,name=MonitoringConfigurationManager", "jmx.objectname.cache.key=MonitoringProcessorManager"}, service={DynamicMBean.class})
public class MonitoringConfigurationManager
extends StandardMBean
implements MonitoringConfigurationManagerMBean {
    private volatile MonitoringConfiguration _monitoringConfiguration;
    @Reference
    private MonitoringControl _monitoringControl;
    @Reference
    private PortalMonitoringControl _portalMonitoringControl;
    @Reference
    private PortletMonitoringControl _portletMonitoringControl;
    @Reference
    private ServiceMonitoringControl _serviceMonitoringControl;

    public MonitoringConfigurationManager() throws NotCompliantMBeanException {
        super(MonitoringConfigurationManagerMBean.class);
    }

    public void addServiceClass(String className) {
        this._serviceMonitoringControl.addServiceClass(className);
    }

    public void addServiceClassMethod(String className, String methodName, String[] parameterTypes) {
        this._serviceMonitoringControl.addServiceClassMethod(className, methodName, parameterTypes);
    }

    @Override
    public String getLevel(String namespace) {
        Level level = this._monitoringControl.getLevel(namespace);
        if (level == null) {
            level = Level.OFF;
        }
        return level.toString();
    }

    @Override
    public String[] getNamespaces() {
        Set namespaces = this._monitoringControl.getNamespaces();
        return namespaces.toArray(new String[0]);
    }

    public Set<String> getServiceClasses() {
        return this._serviceMonitoringControl.getServiceClasses();
    }

    public Set<MethodSignature> getServiceClassMethods() {
        return this._serviceMonitoringControl.getServiceClassMethods();
    }

    public boolean isInclusiveMode() {
        return this._serviceMonitoringControl.isInclusiveMode();
    }

    @Override
    public boolean isMonitorPortalRequest() {
        return this._portalMonitoringControl.isMonitorPortalRequest();
    }

    public boolean isMonitorPortletActionRequest() {
        return this._portletMonitoringControl.isMonitorPortletActionRequest();
    }

    public boolean isMonitorPortletEventRequest() {
        return this._portletMonitoringControl.isMonitorPortletEventRequest();
    }

    public boolean isMonitorPortletHeaderRequest() {
        return this._portletMonitoringControl.isMonitorPortletHeaderRequest();
    }

    public boolean isMonitorPortletRenderRequest() {
        return this._portletMonitoringControl.isMonitorPortletRenderRequest();
    }

    public boolean isMonitorPortletResourceRequest() {
        return this._portletMonitoringControl.isMonitorPortletResourceRequest();
    }

    public boolean isMonitorServiceRequest() {
        return this._serviceMonitoringControl.isMonitorServiceRequest();
    }

    public void setInclusiveMode(boolean inclusiveMode) {
        this._serviceMonitoringControl.setInclusiveMode(inclusiveMode);
    }

    @Override
    public void setLevel(String namespace, String levelName) {
        Level level = Level.valueOf((String)levelName);
        this._monitoringControl.setLevel(namespace, level);
    }

    @Override
    public void setMonitorPortalRequest(boolean monitorPortalRequest) {
        this._portalMonitoringControl.setMonitorPortalRequest(monitorPortalRequest);
    }

    public void setMonitorPortletActionRequest(boolean monitorPortletActionRequest) {
        this._portletMonitoringControl.setMonitorPortletActionRequest(monitorPortletActionRequest);
    }

    public void setMonitorPortletEventRequest(boolean monitorPortletEventRequest) {
        this._portletMonitoringControl.setMonitorPortletEventRequest(monitorPortletEventRequest);
    }

    public void setMonitorPortletHeaderRequest(boolean monitoringPortletHeaderRequest) {
        this._portletMonitoringControl.setMonitorPortletHeaderRequest(monitoringPortletHeaderRequest);
    }

    public void setMonitorPortletRenderRequest(boolean monitorPortletRenderRequest) {
        this._portletMonitoringControl.setMonitorPortletRenderRequest(monitorPortletRenderRequest);
    }

    @Override
    public void setMonitorPortletRequests(boolean monitorPortletRequests) {
        this.setMonitorPortletActionRequest(monitorPortletRequests);
        this.setMonitorPortletEventRequest(monitorPortletRequests);
        this.setMonitorPortletHeaderRequest(monitorPortletRequests);
        this.setMonitorPortletRenderRequest(monitorPortletRequests);
        this.setMonitorPortletResourceRequest(monitorPortletRequests);
    }

    public void setMonitorPortletResourceRequest(boolean monitorPortletResourceRequest) {
        this._portletMonitoringControl.setMonitorPortletResourceRequest(monitorPortletResourceRequest);
    }

    public void setMonitorServiceRequest(boolean monitorServiceRequest) {
        this._serviceMonitoringControl.setMonitorServiceRequest(monitorServiceRequest);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._monitoringConfiguration = (MonitoringConfiguration)ConfigurableUtil.createConfigurable(MonitoringConfiguration.class, properties);
        this.setMonitorPortalRequest(this._monitoringConfiguration.monitorPortalRequest());
        this.setMonitorPortletActionRequest(this._monitoringConfiguration.monitorPortletActionRequest());
        this.setMonitorPortletEventRequest(this._monitoringConfiguration.monitorPortletEventRequest());
        this.setMonitorPortletHeaderRequest(this._monitoringConfiguration.monitorPortletHeaderRequest());
        this.setMonitorPortletRenderRequest(this._monitoringConfiguration.monitorPortletRenderRequest());
        this.setMonitorPortletResourceRequest(this._monitoringConfiguration.monitorPortletResourceRequest());
        this.setMonitorServiceRequest(this._monitoringConfiguration.monitorServiceRequest());
    }
}

