/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.statistics.portlet;

import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.monitoring.internal.statistics.RequestStatistics;
import com.liferay.portal.monitoring.internal.statistics.portlet.CompanyStatistics;
import com.liferay.portal.monitoring.internal.statistics.portlet.PortletSummaryStatistics;
import com.liferay.portal.monitoring.internal.statistics.portlet.ServerStatisticsHelper;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, service={PortletSummaryStatistics.class})
public class ResourceRequestSummaryStatistics
implements PortletSummaryStatistics {
    @Reference
    private ServerStatisticsHelper _serverStatisticsHelper;

    @Override
    public long getAverageTime() {
        long averageTime = 0L;
        long count = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            for (RequestStatistics requestStatistics : companyStatistics.getResourceRequestStatisticsSet()) {
                averageTime += requestStatistics.getAverageTime();
                ++count;
            }
        }
        if (count > 0L) {
            return averageTime / count;
        }
        return 0L;
    }

    @Override
    public long getAverageTimeByCompany(long companyId) throws MonitoringException {
        return this.getAverageTimeByCompany(this._serverStatisticsHelper.getCompanyStatistics(companyId));
    }

    @Override
    public long getAverageTimeByCompany(String webId) throws MonitoringException {
        return this.getAverageTimeByCompany(this._serverStatisticsHelper.getCompanyStatistics(webId));
    }

    @Override
    public long getAverageTimeByPortlet(String portletId) throws MonitoringException {
        long averageTime = 0L;
        Set<CompanyStatistics> companyStatisticsSet = this._serverStatisticsHelper.getCompanyStatisticsSet();
        for (CompanyStatistics companyStatistics : companyStatisticsSet) {
            RequestStatistics requestStatistics = companyStatistics.getResourceRequestStatistics(portletId);
            averageTime += requestStatistics.getAverageTime();
        }
        if (!companyStatisticsSet.isEmpty()) {
            return averageTime / (long)companyStatisticsSet.size();
        }
        return averageTime;
    }

    @Override
    public long getAverageTimeByPortlet(String portletId, long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatisticsHelper.getCompanyStatistics(companyId);
        RequestStatistics requestStatistics = companyStatistics.getResourceRequestStatistics(portletId);
        return requestStatistics.getAverageTime();
    }

    @Override
    public long getAverageTimeByPortlet(String portletId, String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatisticsHelper.getCompanyStatistics(webId);
        RequestStatistics requestStatistics = companyStatistics.getResourceRequestStatistics(portletId);
        return requestStatistics.getAverageTime();
    }

    @Override
    public long getErrorCount() {
        long errorCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            errorCount += this.getErrorCountByCompany(companyStatistics);
        }
        return errorCount;
    }

    @Override
    public long getErrorCountByCompany(long companyId) throws MonitoringException {
        return this.getErrorCountByCompany(this._serverStatisticsHelper.getCompanyStatistics(companyId));
    }

    @Override
    public long getErrorCountByCompany(String webId) throws MonitoringException {
        return this.getErrorCountByCompany(this._serverStatisticsHelper.getCompanyStatistics(webId));
    }

    @Override
    public long getErrorCountByPortlet(String portletId) throws MonitoringException {
        long errorCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            errorCount += this.getErrorCountByPortlet(portletId, companyStatistics);
        }
        return errorCount;
    }

    @Override
    public long getErrorCountByPortlet(String portletId, long companyId) throws MonitoringException {
        return this.getErrorCountByPortlet(portletId, this._serverStatisticsHelper.getCompanyStatistics(companyId));
    }

    @Override
    public long getErrorCountByPortlet(String portletId, String webId) throws MonitoringException {
        return this.getErrorCountByPortlet(portletId, this._serverStatisticsHelper.getCompanyStatistics(webId));
    }

    @Override
    public long getMaxTime() {
        long maxTime = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            for (RequestStatistics requestStatistics : companyStatistics.getResourceRequestStatisticsSet()) {
                if (requestStatistics.getMaxTime() <= maxTime) continue;
                maxTime = requestStatistics.getMaxTime();
            }
        }
        return maxTime;
    }

    @Override
    public long getMaxTimeByCompany(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatisticsHelper.getCompanyStatistics(companyId);
        return companyStatistics.getMaxTime();
    }

    @Override
    public long getMaxTimeByCompany(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatisticsHelper.getCompanyStatistics(webId);
        return companyStatistics.getMaxTime();
    }

    @Override
    public long getMaxTimeByPortlet(String portletId) throws MonitoringException {
        long maxTime = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            long curMaxTime = this.getMaxTimeByPortlet(portletId, companyStatistics);
            if (curMaxTime <= maxTime) continue;
            maxTime = curMaxTime;
        }
        return maxTime;
    }

    @Override
    public long getMaxTimeByPortlet(String portletId, long companyId) throws MonitoringException {
        return this.getMaxTimeByPortlet(portletId, this._serverStatisticsHelper.getCompanyStatistics(companyId));
    }

    @Override
    public long getMaxTimeByPortlet(String portletId, String webId) throws MonitoringException {
        return this.getMaxTimeByPortlet(portletId, this._serverStatisticsHelper.getCompanyStatistics(webId));
    }

    @Override
    public long getMinTime() {
        long minTime = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            for (RequestStatistics requestStatistics : companyStatistics.getResourceRequestStatisticsSet()) {
                if (requestStatistics.getMinTime() >= minTime) continue;
                minTime = requestStatistics.getMinTime();
            }
        }
        return minTime;
    }

    @Override
    public long getMinTimeByCompany(long companyId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatisticsHelper.getCompanyStatistics(companyId);
        return companyStatistics.getMinTime();
    }

    @Override
    public long getMinTimeByCompany(String webId) throws MonitoringException {
        CompanyStatistics companyStatistics = this._serverStatisticsHelper.getCompanyStatistics(webId);
        return companyStatistics.getMinTime();
    }

    @Override
    public long getMinTimeByPortlet(String portletId) throws MonitoringException {
        long minTime = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            long curMinTime = this.getMinTimeByPortlet(portletId, companyStatistics);
            if (curMinTime >= minTime) continue;
            minTime = curMinTime;
        }
        return minTime;
    }

    @Override
    public long getMinTimeByPortlet(String portletId, long companyId) throws MonitoringException {
        return this.getMinTimeByPortlet(portletId, this._serverStatisticsHelper.getCompanyStatistics(companyId));
    }

    @Override
    public long getMinTimeByPortlet(String portletId, String webId) throws MonitoringException {
        return this.getMinTimeByPortlet(portletId, this._serverStatisticsHelper.getCompanyStatistics(webId));
    }

    @Override
    public long getRequestCount() {
        long requestCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            requestCount += this.getRequestCountByCompany(companyStatistics);
        }
        return requestCount;
    }

    @Override
    public long getRequestCountByCompany(long companyId) throws MonitoringException {
        return this.getRequestCountByCompany(this._serverStatisticsHelper.getCompanyStatistics(companyId));
    }

    @Override
    public long getRequestCountByCompany(String webId) throws MonitoringException {
        return this.getRequestCountByCompany(this._serverStatisticsHelper.getCompanyStatistics(webId));
    }

    @Override
    public long getRequestCountByPortlet(String portletId) throws MonitoringException {
        long requestCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            requestCount += this.getRequestCountByPortlet(portletId, companyStatistics);
        }
        return requestCount;
    }

    @Override
    public long getRequestCountByPortlet(String portletId, long companyId) throws MonitoringException {
        return this.getRequestCountByPortlet(portletId, this._serverStatisticsHelper.getCompanyStatistics(companyId));
    }

    @Override
    public long getRequestCountByPortlet(String portletId, String webId) throws MonitoringException {
        return this.getRequestCountByPortlet(portletId, this._serverStatisticsHelper.getCompanyStatistics(webId));
    }

    @Override
    public long getSuccessCount() {
        long successCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            successCount += this.getSuccessCountByCompany(companyStatistics);
        }
        return successCount;
    }

    @Override
    public long getSuccessCountByCompany(long companyId) throws MonitoringException {
        return this.getSuccessCountByCompany(this._serverStatisticsHelper.getCompanyStatistics(companyId));
    }

    @Override
    public long getSuccessCountByCompany(String webId) throws MonitoringException {
        return this.getSuccessCountByCompany(this._serverStatisticsHelper.getCompanyStatistics(webId));
    }

    @Override
    public long getSuccessCountByPortlet(String portletId) throws MonitoringException {
        long successCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            successCount += this.getSuccessCountByPortlet(portletId, companyStatistics);
        }
        return successCount;
    }

    @Override
    public long getSuccessCountByPortlet(String portletId, long companyId) throws MonitoringException {
        return this.getSuccessCountByPortlet(portletId, this._serverStatisticsHelper.getCompanyStatistics(companyId));
    }

    @Override
    public long getSuccessCountByPortlet(String portletId, String webId) throws MonitoringException {
        return this.getSuccessCountByPortlet(portletId, this._serverStatisticsHelper.getCompanyStatistics(webId));
    }

    @Override
    public long getTimeoutCount() {
        long timeoutCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            timeoutCount += this.getTimeoutCountByCompany(companyStatistics);
        }
        return timeoutCount;
    }

    @Override
    public long getTimeoutCountByCompany(long companyId) throws MonitoringException {
        return this.getTimeoutCountByCompany(this._serverStatisticsHelper.getCompanyStatistics(companyId));
    }

    @Override
    public long getTimeoutCountByCompany(String webId) throws MonitoringException {
        return this.getTimeoutCountByCompany(this._serverStatisticsHelper.getCompanyStatistics(webId));
    }

    @Override
    public long getTimeoutCountByPortlet(String portletId) throws MonitoringException {
        long timeoutCount = 0L;
        for (CompanyStatistics companyStatistics : this._serverStatisticsHelper.getCompanyStatisticsSet()) {
            timeoutCount += this.getTimeoutCountByPortlet(portletId, companyStatistics);
        }
        return timeoutCount;
    }

    @Override
    public long getTimeoutCountByPortlet(String portletId, long companyId) throws MonitoringException {
        return this.getTimeoutCountByPortlet(portletId, this._serverStatisticsHelper.getCompanyStatistics(companyId));
    }

    @Override
    public long getTimeoutCountByPortlet(String portletId, String webId) throws MonitoringException {
        return this.getTimeoutCountByPortlet(portletId, this._serverStatisticsHelper.getCompanyStatistics(webId));
    }

    protected long getAverageTimeByCompany(CompanyStatistics companyStatistics) {
        long averageTime = 0L;
        Set<RequestStatistics> requestStatisticsSet = companyStatistics.getResourceRequestStatisticsSet();
        for (RequestStatistics requestStatistics : requestStatisticsSet) {
            averageTime += requestStatistics.getAverageTime();
        }
        if (!requestStatisticsSet.isEmpty()) {
            return averageTime / (long)requestStatisticsSet.size();
        }
        return averageTime;
    }

    protected long getErrorCountByCompany(CompanyStatistics companyStatistics) {
        long errorCount = 0L;
        for (RequestStatistics requestStatistics : companyStatistics.getResourceRequestStatisticsSet()) {
            errorCount += requestStatistics.getErrorCount();
        }
        return errorCount;
    }

    protected long getErrorCountByPortlet(String portletId, CompanyStatistics companyStatistics) throws MonitoringException {
        RequestStatistics requestStatistics = companyStatistics.getResourceRequestStatistics(portletId);
        return requestStatistics.getErrorCount();
    }

    protected long getMaxTimeByPortlet(String portletId, CompanyStatistics companyStatistics) throws MonitoringException {
        long maxTime = 0L;
        RequestStatistics requestStatistics = companyStatistics.getResourceRequestStatistics(portletId);
        if (requestStatistics.getMaxTime() > maxTime) {
            maxTime = requestStatistics.getMaxTime();
        }
        return maxTime;
    }

    protected long getMinTimeByPortlet(String portletId, CompanyStatistics companyStatistics) throws MonitoringException {
        long minTime = 0L;
        RequestStatistics requestStatistics = companyStatistics.getResourceRequestStatistics(portletId);
        if (requestStatistics.getMinTime() < minTime) {
            minTime = requestStatistics.getMinTime();
        }
        return minTime;
    }

    protected long getRequestCountByCompany(CompanyStatistics companyStatistics) {
        long requestCount = 0L;
        for (RequestStatistics requestStatistics : companyStatistics.getResourceRequestStatisticsSet()) {
            requestCount += requestStatistics.getRequestCount();
        }
        return requestCount;
    }

    protected long getRequestCountByPortlet(String portletId, CompanyStatistics companyStatistics) throws MonitoringException {
        RequestStatistics requestStatistics = companyStatistics.getResourceRequestStatistics(portletId);
        return requestStatistics.getRequestCount();
    }

    protected long getSuccessCountByCompany(CompanyStatistics companyStatistics) {
        long successCount = 0L;
        for (RequestStatistics requestStatistics : companyStatistics.getResourceRequestStatisticsSet()) {
            successCount += requestStatistics.getSuccessCount();
        }
        return successCount;
    }

    protected long getSuccessCountByPortlet(String portletId, CompanyStatistics companyStatistics) throws MonitoringException {
        RequestStatistics requestStatistics = companyStatistics.getResourceRequestStatistics(portletId);
        return requestStatistics.getSuccessCount();
    }

    protected long getTimeoutCountByCompany(CompanyStatistics companyStatistics) {
        long timeoutCount = 0L;
        for (RequestStatistics requestStatistics : companyStatistics.getResourceRequestStatisticsSet()) {
            timeoutCount += requestStatistics.getTimeoutCount();
        }
        return timeoutCount;
    }

    protected long getTimeoutCountByPortlet(String portletId, CompanyStatistics companyStatistics) throws MonitoringException {
        RequestStatistics requestStatistics = companyStatistics.getResourceRequestStatistics(portletId);
        return requestStatistics.getTimeoutCount();
    }
}

