/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.monitoring.internal.statistics.portlet.data.sample.processor;

import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.monitoring.DataSampleProcessor;
import com.liferay.portal.kernel.monitoring.MonitoringException;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.monitoring.internal.statistics.portlet.CompanyStatistics;
import com.liferay.portal.monitoring.internal.statistics.portlet.PortletRequestDataSample;
import com.liferay.portal.monitoring.internal.statistics.portlet.ServerStatisticsHelper;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(enabled=false, property={"namespace=com.liferay.monitoring.Portlet"}, service={DataSampleProcessor.class})
public class PortletRequestDataSampleProcessor
implements DataSampleProcessor<PortletRequestDataSample> {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ServerStatisticsHelper _serverStatisticsHelper;

    public void processDataSample(PortletRequestDataSample portletRequestDataSample) throws MonitoringException {
        long companyId = portletRequestDataSample.getCompanyId();
        CompanyStatistics companyStatistics = this._serverStatisticsHelper.getCompanyStatisticsByCompanyId(companyId);
        if (companyStatistics == null) {
            try {
                Company company = this._companyLocalService.getCompany(companyId);
                companyStatistics = this._serverStatisticsHelper.register(company.getWebId());
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unable to get company with company ID " + companyId, exception);
            }
        }
        companyStatistics.processDataSample(portletRequestDataSample);
    }
}

