/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.notifications.test.util;

import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserNotificationDelivery;
import com.liferay.portal.kernel.model.UserNotificationEvent;
import com.liferay.portal.kernel.service.UserNotificationDeliveryLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRun;
import com.liferay.portal.kernel.test.util.GroupTestUtil;
import com.liferay.portal.kernel.test.util.UserTestUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.test.mail.MailServiceTestUtil;
import com.liferay.portal.test.rule.Inject;
import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class BaseUserNotificationTestCase {
    @DeleteAfterTestRun
    protected Group group;
    @DeleteAfterTestRun
    protected User user;
    @Inject
    private JSONFactory _jsonFactory;
    private List<UserNotificationDelivery> _userNotificationDeliveries = new ArrayList<UserNotificationDelivery>();
    @Inject
    private UserNotificationDeliveryLocalService _userNotificationDeliveryLocalService;
    @Inject
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    @Before
    public void setUp() throws Exception {
        this.user = UserTestUtil.addOmniAdminUser();
        this.group = GroupTestUtil.addGroup();
        this.addContainerModel();
        this._userNotificationDeliveries = this._getUserNotificationDeliveries(this.user.getUserId());
    }

    @After
    public void tearDown() throws Exception {
        this._deleteUserNotificationEvents(this.user.getUserId());
        this._deleteUserNotificationDeliveries();
    }

    @Test
    public void testAddUserNotification() throws Exception {
        this.subscribeToContainer();
        BaseModel<?> baseModel = this.addBaseModel();
        Assert.assertEquals((long)1L, (long)MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId());
        Assert.assertEquals((String)userNotificationEventsJSONObjects.toString(), (long)1L, (long)userNotificationEventsJSONObjects.size());
        for (JSONObject userNotificationEventsJSONObject : userNotificationEventsJSONObjects) {
            Assert.assertTrue((boolean)this.isValidUserNotificationEventObject((Long)baseModel.getPrimaryKeyObj(), userNotificationEventsJSONObject));
            Assert.assertEquals((long)0L, (long)userNotificationEventsJSONObject.getInt("notificationType"));
        }
    }

    @Test
    public void testAddUserNotificationWhenEmailNotificationsDisabled() throws Exception {
        this.subscribeToContainer();
        this._updateUserNotificationDelivery(0, 10000, false);
        BaseModel<?> baseModel = this.addBaseModel();
        Assert.assertEquals((long)0L, (long)MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId());
        Assert.assertEquals((String)userNotificationEventsJSONObjects.toString(), (long)1L, (long)userNotificationEventsJSONObjects.size());
        for (JSONObject userNotificationEventsJSONObject : userNotificationEventsJSONObjects) {
            Assert.assertTrue((boolean)this.isValidUserNotificationEventObject((Long)baseModel.getPrimaryKeyObj(), userNotificationEventsJSONObject));
            Assert.assertEquals((long)0L, (long)userNotificationEventsJSONObject.getInt("notificationType"));
        }
    }

    @Test
    public void testAddUserNotificationWhenNotificationsDisabled() throws Exception {
        this.subscribeToContainer();
        this._updateUserNotificationsDelivery(false);
        this.addBaseModel();
        Assert.assertEquals((long)0L, (long)MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId());
        Assert.assertEquals((String)userNotificationEventsJSONObjects.toString(), (long)0L, (long)userNotificationEventsJSONObjects.size());
    }

    @Test
    public void testAddUserNotificationWhenWebsiteNotificationsDisabled() throws Exception {
        this.subscribeToContainer();
        this._updateUserNotificationDelivery(0, 10002, false);
        this.addBaseModel();
        Assert.assertEquals((long)1L, (long)MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId());
        Assert.assertEquals((String)userNotificationEventsJSONObjects.toString(), (long)0L, (long)userNotificationEventsJSONObjects.size());
    }

    @Test
    public void testUpdateUserNotification() throws Exception {
        BaseModel<?> baseModel = this.addBaseModel();
        this.subscribeToContainer();
        BaseModel<?> updatedBaseModel = this.updateBaseModel(baseModel);
        Assert.assertEquals((long)1L, (long)MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId());
        Assert.assertEquals((String)userNotificationEventsJSONObjects.toString(), (long)1L, (long)userNotificationEventsJSONObjects.size());
        for (JSONObject userNotificationEventsJSONObject : userNotificationEventsJSONObjects) {
            Assert.assertTrue((boolean)this.isValidUserNotificationEventObject((Long)updatedBaseModel.getPrimaryKeyObj(), userNotificationEventsJSONObject));
            Assert.assertEquals((long)userNotificationEventsJSONObject.getInt("notificationType"), (long)1L);
        }
    }

    @Test
    public void testUpdateUserNotificationWhenEmailNotificationsDisabled() throws Exception {
        this._updateUserNotificationDelivery(0, 10000, false);
        this._updateUserNotificationDelivery(1, 10000, false);
        BaseModel<?> baseModel = this.addBaseModel();
        this.subscribeToContainer();
        BaseModel<?> updatedBaseModel = this.updateBaseModel(baseModel);
        Assert.assertEquals((long)0L, (long)MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId());
        Assert.assertEquals((String)userNotificationEventsJSONObjects.toString(), (long)1L, (long)userNotificationEventsJSONObjects.size());
        for (JSONObject userNotificationEventsJSONObject : userNotificationEventsJSONObjects) {
            Assert.assertTrue((boolean)this.isValidUserNotificationEventObject((Long)updatedBaseModel.getPrimaryKeyObj(), userNotificationEventsJSONObject));
            Assert.assertEquals((long)userNotificationEventsJSONObject.getInt("notificationType"), (long)1L);
        }
    }

    @Test
    public void testUpdateUserNotificationWhenNotificationsDisabled() throws Exception {
        this._updateUserNotificationsDelivery(false);
        this.subscribeToContainer();
        this.updateBaseModel(this.addBaseModel());
        Assert.assertEquals((long)0L, (long)MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId());
        Assert.assertEquals((String)userNotificationEventsJSONObjects.toString(), (long)0L, (long)userNotificationEventsJSONObjects.size());
    }

    @Test
    public void testUpdateUserNotificationWhenWebsiteNotificationsDisabled() throws Exception {
        this._updateUserNotificationDelivery(0, 10002, false);
        this._updateUserNotificationDelivery(1, 10002, false);
        BaseModel<?> baseModel = this.addBaseModel();
        this.subscribeToContainer();
        this.updateBaseModel(baseModel);
        Assert.assertEquals((long)1L, (long)MailServiceTestUtil.getInboxSize());
        List<JSONObject> userNotificationEventsJSONObjects = this.getUserNotificationEventsJSONObjects(this.user.getUserId());
        Assert.assertEquals((String)userNotificationEventsJSONObjects.toString(), (long)0L, (long)userNotificationEventsJSONObjects.size());
    }

    protected abstract BaseModel<?> addBaseModel() throws Exception;

    protected void addContainerModel() throws Exception {
    }

    protected abstract String getPortletId();

    protected List<JSONObject> getUserNotificationEventsJSONObjects(long userId) throws Exception {
        List userNotificationEvents = this._userNotificationEventLocalService.getUserNotificationEvents(userId);
        ArrayList<JSONObject> userNotificationEventJSONObjects = new ArrayList<JSONObject>(userNotificationEvents.size());
        for (UserNotificationEvent userNotificationEvent : userNotificationEvents) {
            userNotificationEventJSONObjects.add(this._jsonFactory.createJSONObject(userNotificationEvent.getPayload()));
        }
        return userNotificationEventJSONObjects;
    }

    protected boolean isValidUserNotificationEventObject(long primaryKey, JSONObject userNotificationEventJSONObject) throws Exception {
        return userNotificationEventJSONObject.getLong("classPK") == primaryKey;
    }

    protected abstract void subscribeToContainer() throws Exception;

    protected abstract BaseModel<?> updateBaseModel(BaseModel<?> var1) throws Exception;

    private void _deleteUserNotificationDeliveries() {
        this._userNotificationDeliveryLocalService.deleteUserNotificationDeliveries(this.user.getUserId());
    }

    private void _deleteUserNotificationEvents(long userId) {
        List userNotificationEvents = this._userNotificationEventLocalService.getUserNotificationEvents(userId);
        for (UserNotificationEvent userNotificationEvent : userNotificationEvents) {
            this._userNotificationEventLocalService.deleteUserNotificationEvent(userNotificationEvent);
        }
    }

    private List<UserNotificationDelivery> _getUserNotificationDeliveries(long userId) throws Exception {
        return ListUtil.fromArray((Object[])new UserNotificationDelivery[]{this._userNotificationDeliveryLocalService.getUserNotificationDelivery(userId, this.getPortletId(), 0L, 0, 10000, true), this._userNotificationDeliveryLocalService.getUserNotificationDelivery(userId, this.getPortletId(), 0L, 0, 10002, true), this._userNotificationDeliveryLocalService.getUserNotificationDelivery(userId, this.getPortletId(), 0L, 1, 10000, true), this._userNotificationDeliveryLocalService.getUserNotificationDelivery(userId, this.getPortletId(), 0L, 1, 10002, true)});
    }

    private void _updateUserNotificationDelivery(int notificationType, int deliveryType, boolean deliver) {
        boolean exists = false;
        for (UserNotificationDelivery userNotificationDelivery : this._userNotificationDeliveries) {
            if (userNotificationDelivery.getNotificationType() != notificationType || userNotificationDelivery.getDeliveryType() != deliveryType) continue;
            this._userNotificationDeliveryLocalService.updateUserNotificationDelivery(userNotificationDelivery.getUserNotificationDeliveryId(), deliver);
            exists = true;
            break;
        }
        Assert.assertTrue((String)"User notification does not exist", (boolean)exists);
    }

    private void _updateUserNotificationsDelivery(boolean deliver) {
        for (UserNotificationDelivery userNotificationDelivery : this._userNotificationDeliveries) {
            this._userNotificationDeliveryLocalService.updateUserNotificationDelivery(userNotificationDelivery.getUserNotificationDeliveryId(), deliver);
        }
    }
}

