/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.odata.internal.filter.expression;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.odata.filter.expression.Expression;
import com.liferay.portal.odata.filter.expression.ExpressionVisitException;
import com.liferay.portal.odata.filter.expression.ExpressionVisitor;
import com.liferay.portal.odata.filter.expression.ListExpression;
import java.util.ArrayList;
import java.util.List;

public class ListExpressionImpl
implements ListExpression {
    private final Expression _leftOperationExpression;
    private final ListExpression.Operation _operation;
    private final List<Expression> _rightOperationExpressions;

    public ListExpressionImpl(Expression leftOperationExpression, ListExpression.Operation operation, List<Expression> rightOperationExpressions) {
        this._leftOperationExpression = leftOperationExpression;
        this._operation = operation;
        this._rightOperationExpressions = rightOperationExpressions;
    }

    public <T> T accept(ExpressionVisitor<T> expressionVisitor) throws ExpressionVisitException {
        ArrayList<Object> visitedRightOperationExpressions = new ArrayList<Object>();
        for (Expression rightOperationExpression : this._rightOperationExpressions) {
            visitedRightOperationExpressions.add(rightOperationExpression.accept(expressionVisitor));
        }
        return (T)expressionVisitor.visitListExpressionOperation(this._operation, this._leftOperationExpression.accept(expressionVisitor), visitedRightOperationExpressions);
    }

    public Expression getLeftOperationExpression() {
        return this._leftOperationExpression;
    }

    public ListExpression.Operation getOperation() {
        return this._operation;
    }

    public List<Expression> getRightOperationExpressions() {
        return this._rightOperationExpressions;
    }

    public String toString() {
        return StringBundler.concat((Object[])new Object[]{"{", this._leftOperationExpression, " ", this._operation.name(), " ", this._rightOperationExpressions, Character.valueOf('}')});
    }
}

