/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.portal.odata.internal.filter;

import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.odata.filter.expression.factory.ExpressionFactory;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Cristina González
 */
@Component(service = FilterParserProvider.class)
public class FilterParserProviderImpl implements FilterParserProvider {

	@Override
	public FilterParser provide(EntityModel entityModel) {
		return new FilterParserImpl(entityModel, _expressionFactory);
	}

	@Reference
	private ExpressionFactory _expressionFactory;

}