/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.context.helper.internal.definition;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.osgi.web.servlet.JSPServletFactory;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.FilterDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.ListenerDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.ServletDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.WebResourceCollectionDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.WebXMLDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.internal.JspServletWrapper;
import com.liferay.portal.osgi.web.servlet.context.helper.internal.order.OrderUtil;
import com.liferay.portal.osgi.web.servlet.context.helper.order.Order;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.framework.Bundle;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WebXMLDefinitionLoader
extends DefaultHandler {
    private static final String[] _LEAVES = new String[]{"async-supported", "dispatcher", "error-code", "exception-type", "filter-class", "filter-name", "http-method", "http-method-exception", "jsp-file", "listener-class", "location", "name", "param-name", "param-value", "servlet-class", "servlet-name", "taglib-location", "taglib-uri", "url-pattern", "web-resource-name"};
    private static final Log _log = LogFactoryUtil.getLog(WebXMLDefinitionLoader.class);
    private List<String> _absoluteOrderingNames;
    private boolean _after;
    private String _afterName;
    private final Set<Class<?>> _annotatedClasses;
    private boolean _before;
    private String _beforeName;
    private final Bundle _bundle;
    private final Set<Class<?>> _classes;
    private FilterDefinition _filterDefinition;
    private FilterMapping _filterMapping;
    private JSPConfig _jspConfig;
    private final JSPServletFactory _jspServletFactory;
    private ListenerDefinition _listenerDefinition;
    private String _name;
    private Order _order;
    private boolean _othersAbsoluteOrderingSet;
    private boolean _othersAfterSet;
    private boolean _othersBeforeSet;
    private String _parameterName;
    private String _parameterValue;
    private final SAXParserFactory _saxParserFactory;
    private ServletDefinition _servletDefinition;
    private ServletMapping _servletMapping;
    private final Stack<StringBuilder> _stack = new Stack();
    private String _taglibLocation;
    private String _taglibUri;
    private WebResourceCollection _webResourceCollection;
    private final WebXMLDefinition _webXMLDefinition = new WebXMLDefinition();

    public WebXMLDefinitionLoader(Bundle bundle, JSPServletFactory jspServletFactory, SAXParserFactory saxParserFactory, Set<Class<?>> classes, Set<Class<?>> annotatedClasses) {
        this._bundle = bundle;
        this._jspServletFactory = jspServletFactory;
        this._saxParserFactory = saxParserFactory;
        this._classes = classes;
        this._annotatedClasses = annotatedClasses;
    }

    @Override
    public void characters(char[] c, int start, int length) {
        if (this._stack.empty()) {
            return;
        }
        StringBuilder stringBuilder = this._stack.peek();
        stringBuilder.append(c, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        if (qName.equals("absolute-ordering")) {
            if (this._othersAbsoluteOrderingSet && this._absoluteOrderingNames != null) {
                this._absoluteOrderingNames.add(Order.OTHERS);
            }
            List absoluteOrderingNames = this._webXMLDefinition.getAbsoluteOrderingNames();
            absoluteOrderingNames.addAll(this._absoluteOrderingNames);
            this._absoluteOrderingNames = null;
            this._othersAbsoluteOrderingSet = false;
        } else if (qName.equals("after")) {
            this._after = false;
            this._afterName = this._name;
            this._name = null;
        } else if (qName.equals("async-supported")) {
            boolean asyncSupported = GetterUtil.getBoolean((Object)this._stack.pop());
            if (this._filterDefinition != null) {
                this._filterDefinition.setAsyncSupported(asyncSupported);
            } else if (this._servletDefinition != null) {
                this._servletDefinition.setAsyncSupported(asyncSupported);
            }
        } else if (qName.equals("before")) {
            this._before = false;
            this._beforeName = this._name;
            this._name = null;
        } else if (qName.equals("context-param")) {
            this._webXMLDefinition.setContextParameter(this._parameterName, this._parameterValue);
            this._parameterName = null;
            this._parameterValue = null;
        } else if (qName.equals("dispatcher")) {
            String dispatcher = String.valueOf(this._stack.pop());
            dispatcher = StringUtil.toUpperCase((String)dispatcher);
            dispatcher = dispatcher.trim();
            this._filterMapping.dispatchers.add(dispatcher);
        } else if (qName.equals("filter")) {
            if (this._filterDefinition.getFilter() != null) {
                this._webXMLDefinition.setFilterDefinition(this._filterDefinition.getName(), this._filterDefinition);
            }
            this._filterDefinition = null;
        } else if (qName.equals("filter-class")) {
            String filterClassName = String.valueOf(this._stack.pop());
            this._setFilter(this._filterDefinition, filterClassName.trim());
        } else if (qName.equals("filter-mapping")) {
            Map filterDefinitions = this._webXMLDefinition.getFilterDefinitions();
            FilterDefinition filterDefinition = (FilterDefinition)filterDefinitions.get(this._filterMapping.filterName);
            if (filterDefinition != null) {
                filterDefinition.setDispatchers(this._filterMapping.dispatchers);
                if (this._filterMapping.servletName != null) {
                    List servletNames = filterDefinition.getServletNames();
                    servletNames.add(this._filterMapping.servletName);
                }
                this._addURLPatterns(filterDefinition, this._filterMapping.urlPatterns);
            }
            this._filterMapping = null;
        } else if (qName.equals("filter-name")) {
            if (this._filterMapping != null) {
                String filterName = String.valueOf(this._stack.pop());
                this._filterMapping.filterName = filterName.trim();
            } else if (this._filterDefinition != null) {
                String filterName = String.valueOf(this._stack.pop());
                this._filterDefinition.setName(filterName.trim());
            }
        } else if (qName.equals("http-method")) {
            if (this._webResourceCollection != null) {
                String httpMethod = String.valueOf(this._stack.pop());
                this._webResourceCollection.httpMethods.add(httpMethod.trim());
            }
        } else if (qName.equals("http-method-exception")) {
            if (this._webResourceCollection != null) {
                String httpMethodException = String.valueOf(this._stack.pop());
                this._webResourceCollection.httpMethodExceptions.add(httpMethodException.trim());
            }
        } else if (qName.equals("init-param")) {
            if (this._filterDefinition != null) {
                this._filterDefinition.setInitParameter(this._parameterName, this._parameterValue);
            } else if (this._servletDefinition != null) {
                this._servletDefinition.setInitParameter(this._parameterName, this._parameterValue);
            }
            this._parameterName = null;
            this._parameterValue = null;
        } else if (qName.equals("jsp-config")) {
            this._webXMLDefinition.setJspTaglibMappings(this._jspConfig.mappings);
            this._jspConfig = null;
        } else if (qName.equals("jsp-file")) {
            String jspFile = String.valueOf(this._stack.pop());
            this._servletDefinition.setJSPFile(jspFile);
            this._servletDefinition.setServlet((Servlet)new JspServletWrapper(this._jspServletFactory.createJSPServlet(), jspFile));
        } else if (qName.equals("listener")) {
            if (this._listenerDefinition.getEventListener() != null) {
                this._webXMLDefinition.addListenerDefinition(this._listenerDefinition);
            }
            this._listenerDefinition = null;
        } else if (qName.equals("listener-class")) {
            String listenerClassName = String.valueOf(this._stack.pop());
            this._setEventListener(this._listenerDefinition, listenerClassName);
        } else if (qName.equals("name")) {
            String name = String.valueOf(this._stack.pop());
            if (this._absoluteOrderingNames != null) {
                this._absoluteOrderingNames.add(name);
            } else if (!this._after && !this._before) {
                this._webXMLDefinition.setFragmentName(name);
            } else {
                this._name = name;
            }
        } else if (qName.equals("ordering")) {
            if (this._order == null) {
                return;
            }
            EnumMap routes = this._order.getRoutes();
            ArrayList<String> beforeNames = new ArrayList<String>(2);
            if (this._beforeName != null) {
                beforeNames.add(this._beforeName);
            }
            if (this._othersBeforeSet) {
                beforeNames.add(Order.OTHERS);
            }
            if (ListUtil.isNotEmpty(beforeNames)) {
                routes.put(Order.Path.BEFORE, beforeNames.toArray(new String[0]));
            }
            ArrayList<String> afterNames = new ArrayList<String>(2);
            if (this._afterName != null) {
                afterNames.add(this._afterName);
            }
            if (this._othersAfterSet) {
                afterNames.add(Order.OTHERS);
            }
            if (ListUtil.isNotEmpty(afterNames)) {
                routes.put(Order.Path.AFTER, afterNames.toArray(new String[0]));
            }
            this._order.setRoutes(routes);
            this._webXMLDefinition.setOrder(this._order);
            this._afterName = null;
            this._beforeName = null;
            this._order = null;
            this._othersAfterSet = false;
            this._othersBeforeSet = false;
        } else if (qName.equals("others")) {
            if (this._absoluteOrderingNames != null) {
                this._othersAbsoluteOrderingSet = true;
            }
            if (this._after) {
                this._othersAfterSet = true;
            } else if (this._before) {
                this._othersBeforeSet = true;
            }
        } else if (qName.equals("param-name")) {
            this._parameterName = String.valueOf(this._stack.pop());
            this._parameterName = this._parameterName.trim();
        } else if (qName.equals("param-value")) {
            this._parameterValue = String.valueOf(this._stack.pop());
            this._parameterValue = this._parameterValue.trim();
        } else if (qName.equals("role-name") || qName.equals("transport-guarantee")) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{qName, " from web.xml in bundle ", this._bundle, " is not supported"}));
            }
        } else if (qName.equals("servlet")) {
            this._webXMLDefinition.setServletDefinition(this._servletDefinition.getName(), this._servletDefinition);
            this._servletDefinition = null;
        } else if (qName.equals("servlet-class")) {
            String servletClassName = String.valueOf(this._stack.pop());
            this._setServlet(this._servletDefinition, servletClassName.trim());
        } else if (qName.equals("servlet-mapping")) {
            Map servletDefinitions = this._webXMLDefinition.getServletDefinitions();
            ServletDefinition servletDefinition = (ServletDefinition)servletDefinitions.get(this._servletMapping.servletName);
            if (servletDefinition != null) {
                this._addURLPatterns(servletDefinition, this._servletMapping.urlPatterns);
            }
            this._servletMapping = null;
        } else if (qName.equals("servlet-name")) {
            if (this._filterMapping != null) {
                String servletName = String.valueOf(this._stack.pop());
                this._filterMapping.servletName = servletName.trim();
            } else if (this._servletDefinition != null) {
                String servletName = String.valueOf(this._stack.pop());
                this._servletDefinition.setName(servletName.trim());
            } else if (this._servletMapping != null) {
                String servletName = String.valueOf(this._stack.pop());
                this._servletMapping.servletName = servletName.trim();
            }
        } else if (qName.equals("taglib")) {
            this._jspConfig.mappings.put(this._taglibUri, this._taglibLocation);
            this._taglibUri = null;
            this._taglibLocation = null;
        } else if (qName.equals("taglib-location")) {
            this._taglibLocation = String.valueOf(this._stack.pop());
        } else if (qName.equals("taglib-uri")) {
            this._taglibUri = String.valueOf(this._stack.pop());
        } else if (qName.equals("url-pattern")) {
            if (this._filterMapping != null) {
                String urlPattern = String.valueOf(this._stack.pop());
                this._filterMapping.urlPatterns.add(urlPattern.trim());
            } else if (this._servletMapping != null) {
                String urlPattern = String.valueOf(this._stack.pop());
                this._servletMapping.urlPatterns.add(urlPattern.trim());
            } else if (this._webResourceCollection != null) {
                String urlPattern = String.valueOf(this._stack.pop());
                this._webResourceCollection.urlPatterns.add(urlPattern.trim());
            }
        } else if (qName.equals("web-resource-collection")) {
            List webResourceCollectionDefinitions = this._webXMLDefinition.getWebResourceCollectionDefinitions();
            WebResourceCollectionDefinition webResourceCollectionDefinition = new WebResourceCollectionDefinition(this._webResourceCollection.webResourceName);
            for (String httpMethod : this._webResourceCollection.httpMethods) {
                webResourceCollectionDefinition.addHttpMethod(httpMethod);
            }
            for (String httpMethodException : this._webResourceCollection.httpMethodExceptions) {
                webResourceCollectionDefinition.addHttpMethodException(httpMethodException);
            }
            for (String urlPattern : this._webResourceCollection.urlPatterns) {
                webResourceCollectionDefinition.addURLPattern(urlPattern);
            }
            webResourceCollectionDefinitions.add(webResourceCollectionDefinition);
            this._webResourceCollection = null;
        } else if (qName.equals("web-resource-name")) {
            String name = String.valueOf(this._stack.pop());
            this._webResourceCollection.webResourceName = name.trim();
        }
    }

    @Override
    public void error(SAXParseException saxParseException) {
        _log.error((Object)(this._bundle + ": " + saxParseException.getMessage()), (Throwable)saxParseException);
    }

    public WebXMLDefinition loadWebXML() throws Exception {
        WebXMLDefinition webXMLDefinition = this.loadWebXMLDefinition(this._bundle.getEntry("WEB-INF/web.xml"));
        if (webXMLDefinition.isMetadataComplete()) {
            return webXMLDefinition;
        }
        Enumeration enumeration = this._bundle.getResources("META-INF/web-fragment.xml");
        ArrayList<WebXMLDefinition> webXMLDefinitions = new ArrayList<WebXMLDefinition>();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                URL url = (URL)enumeration.nextElement();
                WebXMLDefinitionLoader webXMLDefinitionLoader = new WebXMLDefinitionLoader(this._bundle, this._jspServletFactory, this._saxParserFactory, this._classes, this._annotatedClasses);
                webXMLDefinitions.add(webXMLDefinitionLoader.loadWebXMLDefinition(url));
            }
        }
        WebXMLDefinition annotationWebXMLDefinition = new WebXMLDefinition();
        this._collectAnnotatedClasses(annotationWebXMLDefinition);
        webXMLDefinitions.add(annotationWebXMLDefinition);
        List<WebXMLDefinition> orderedWebXMLDefinitions = new ArrayList<WebXMLDefinition>();
        if (ListUtil.isNotEmpty(webXMLDefinitions)) {
            orderedWebXMLDefinitions = OrderUtil.getOrderedWebXMLDefinitions(webXMLDefinitions, webXMLDefinition.getAbsoluteOrderingNames());
        }
        return this._assembleWebXMLDefinition(webXMLDefinition, orderedWebXMLDefinitions);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WebXMLDefinition loadWebXMLDefinition(URL url) throws Exception {
        if (url == null) {
            return this._webXMLDefinition;
        }
        try (InputStream inputStream = url.openStream();){
            SAXParser saxParser = this._saxParserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.parse(new InputSource(inputStream));
            WebXMLDefinition webXMLDefinition = this._webXMLDefinition;
            return webXMLDefinition;
        }
        catch (SAXParseException saxParseException) {
            String message = saxParseException.getMessage();
            if (!message.contains("DOCTYPE is disallowed")) throw saxParseException;
            throw new Exception(url + " must be updated to the Servlet 3.0 specification");
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("absolute-ordering")) {
            this._absoluteOrderingNames = new ArrayList<String>();
        } else if (qName.equals("after")) {
            this._after = true;
        } else if (qName.equals("before")) {
            this._before = true;
        } else if (qName.equals("filter")) {
            this._filterDefinition = new FilterDefinition();
        } else if (qName.equals("filter-mapping")) {
            this._filterMapping = new FilterMapping();
        } else if (qName.equals("jsp-config")) {
            this._jspConfig = new JSPConfig();
        } else if (qName.equals("listener")) {
            this._listenerDefinition = new ListenerDefinition();
        } else if (qName.equals("ordering")) {
            this._order = new Order();
        } else if (qName.equals("servlet")) {
            this._servletDefinition = new ServletDefinition();
        } else if (qName.equals("servlet-mapping")) {
            this._servletMapping = new ServletMapping();
        } else if (qName.equals("web-app")) {
            boolean metadataComplete = GetterUtil.getBoolean((String)attributes.getValue("metadata-complete"));
            this._webXMLDefinition.setMetadataComplete(metadataComplete);
        } else if (qName.equals("web-resource-collection")) {
            this._webResourceCollection = new WebResourceCollection();
        } else if (Arrays.binarySearch(_LEAVES, qName) > -1) {
            this._stack.push(new StringBuilder());
        }
    }

    private void _addURLPatterns(FilterDefinition filterDefinition, List<String> value) {
        if (!ListUtil.isEmpty(value)) {
            this._addURLPatterns(filterDefinition, value.toArray(new String[0]), null);
        }
    }

    private void _addURLPatterns(FilterDefinition filterDefinition, String[] value, String[] urlPatterns) {
        if (!ArrayUtil.isEmpty((Object[])value)) {
            for (String urlPattern : value) {
                filterDefinition.addURLPattern(urlPattern);
            }
        }
        if (!ArrayUtil.isEmpty((Object[])urlPatterns)) {
            if (ListUtil.isNotEmpty((List)filterDefinition.getURLPatterns())) {
                throw new IllegalStateException("Both value and URL patterns are declared");
            }
            for (String urlPattern : urlPatterns) {
                filterDefinition.addURLPattern(urlPattern);
            }
        }
    }

    private void _addURLPatterns(ServletDefinition servletDefinition, List<String> value) {
        if (!ListUtil.isEmpty(value)) {
            this._addURLPatterns(servletDefinition, value.toArray(new String[0]), null);
        }
    }

    private void _addURLPatterns(ServletDefinition servletDefinition, String[] value, String[] urlPatterns) {
        if (!ArrayUtil.isEmpty((Object[])value)) {
            for (String urlPattern : value) {
                servletDefinition.addURLPattern(urlPattern);
            }
        }
        if (!ArrayUtil.isEmpty((Object[])urlPatterns)) {
            if (ListUtil.isNotEmpty((List)servletDefinition.getURLPatterns())) {
                throw new IllegalStateException("Both value and URL patterns are declared");
            }
            for (String urlPattern : urlPatterns) {
                servletDefinition.addURLPattern(urlPattern);
            }
        }
    }

    private void _assembleContextParameters(Map<String, String> assembledContextParameters, Map<String, String> fragmentContextParameters) {
        for (Map.Entry<String, String> entry : fragmentContextParameters.entrySet()) {
            String name = entry.getKey();
            if (assembledContextParameters.containsKey(name)) continue;
            assembledContextParameters.put(name, entry.getValue());
        }
    }

    private void _assembleFilterDefinitions(Map<String, FilterDefinition> webXMLFilterDefinitions, Map<String, FilterDefinition> assembledFilterDefinitions, Map<String, FilterDefinition> fragmentFilterDefinitions) throws Exception {
        for (Map.Entry<String, FilterDefinition> entry : fragmentFilterDefinitions.entrySet()) {
            Object assembledInitParameterValue;
            String filterName = entry.getKey();
            if (!assembledFilterDefinitions.containsKey(filterName)) {
                assembledFilterDefinitions.put(filterName, entry.getValue());
                continue;
            }
            FilterDefinition webXMLFilterDefinition = webXMLFilterDefinitions.get(filterName);
            Map webXMLInitParameters = null;
            if (webXMLFilterDefinition != null) {
                webXMLInitParameters = webXMLFilterDefinition.getInitParameters();
            }
            FilterDefinition assembledFilterDefinition = assembledFilterDefinitions.get(filterName);
            Map assembledInitParameters = assembledFilterDefinition.getInitParameters();
            FilterDefinition fragmentFilterDefinition = entry.getValue();
            Map fragmentInitParameters = fragmentFilterDefinition.getInitParameters();
            for (Map.Entry initParametersEntry : fragmentInitParameters.entrySet()) {
                String initParameterName = (String)initParametersEntry.getKey();
                String webXMLInitParameterValue = null;
                if (webXMLInitParameters != null) {
                    webXMLInitParameterValue = (String)webXMLInitParameters.get(initParameterName);
                }
                if (!Validator.isNull((String)(assembledInitParameterValue = (String)assembledInitParameters.get(initParameterName)))) continue;
                if (webXMLInitParameterValue == null && !Objects.equals(assembledInitParameterValue, initParametersEntry.getValue())) {
                    throw new Exception(StringBundler.concat((String[])new String[]{"Init paramter name ", initParameterName, " conflicts with filter name ", filterName}));
                }
                assembledInitParameters.put(initParameterName, initParametersEntry.getValue());
            }
            List assembledDispatchers = assembledFilterDefinition.getDispatchers();
            List fragmentDispatchers = fragmentFilterDefinition.getDispatchers();
            for (String dispatcher : fragmentDispatchers) {
                if (assembledDispatchers.contains(dispatcher)) continue;
                assembledDispatchers.add(dispatcher);
            }
            List assembledServletNames = assembledFilterDefinition.getServletNames();
            List fragmentServletNames = fragmentFilterDefinition.getServletNames();
            assembledInitParameterValue = fragmentServletNames.iterator();
            while (assembledInitParameterValue.hasNext()) {
                String servletName = (String)assembledInitParameterValue.next();
                if (assembledServletNames.contains(servletName)) continue;
                assembledServletNames.add(servletName);
            }
            List assembledURLPatterns = assembledFilterDefinition.getURLPatterns();
            List fragmentURLPatterns = fragmentFilterDefinition.getURLPatterns();
            for (String urlPattern : fragmentURLPatterns) {
                if (assembledURLPatterns.contains(urlPattern)) continue;
                assembledURLPatterns.add(urlPattern);
            }
        }
    }

    private void _assembleListenerDefinitions(List<ListenerDefinition> assembledListenerDefinitions, List<ListenerDefinition> fragmentListenerDefinitions) {
        for (ListenerDefinition fragmentListenerDefinition : fragmentListenerDefinitions) {
            if (assembledListenerDefinitions.contains(fragmentListenerDefinition)) continue;
            assembledListenerDefinitions.add(fragmentListenerDefinition);
        }
    }

    private void _assembleServletDefinitions(Map<String, ServletDefinition> webXMLServletDefinitions, Map<String, ServletDefinition> assembledServletDefinitions, Map<String, ServletDefinition> fragmentServletDefinitions) throws Exception {
        for (Map.Entry<String, ServletDefinition> entry : fragmentServletDefinitions.entrySet()) {
            String servletName = entry.getKey();
            if (!assembledServletDefinitions.containsKey(servletName)) {
                assembledServletDefinitions.put(servletName, entry.getValue());
                continue;
            }
            ServletDefinition webXMLServletDefinition = webXMLServletDefinitions.get(servletName);
            Map webXMLServletInitParameters = null;
            if (webXMLServletDefinition != null) {
                webXMLServletInitParameters = webXMLServletDefinition.getInitParameters();
            }
            ServletDefinition assembledServletDefinition = assembledServletDefinitions.get(servletName);
            Map assembledInitInitParameters = assembledServletDefinition.getInitParameters();
            ServletDefinition fragmentServletDefinition = entry.getValue();
            Map fragmentServletInitParameters = fragmentServletDefinition.getInitParameters();
            for (Map.Entry initParameterEntry : fragmentServletInitParameters.entrySet()) {
                String assembledInitParameterValue;
                String initParameterName = (String)initParameterEntry.getKey();
                String webXMLInitParameterValue = null;
                if (webXMLServletInitParameters != null) {
                    webXMLInitParameterValue = (String)webXMLServletInitParameters.get(initParameterName);
                }
                if (!Validator.isNull((String)(assembledInitParameterValue = (String)assembledInitInitParameters.get(initParameterName)))) continue;
                if (webXMLInitParameterValue == null && !Objects.equals(assembledInitParameterValue, initParameterEntry.getValue())) {
                    throw new Exception(StringBundler.concat((String[])new String[]{"Init paramter name ", initParameterName, " conflicts with servlet name ", servletName}));
                }
                assembledInitInitParameters.put(initParameterName, initParameterEntry.getValue());
            }
            List assembledURLPatterns = assembledServletDefinition.getURLPatterns();
            List fragmentURLPatterns = fragmentServletDefinition.getURLPatterns();
            for (String urlPattern : fragmentURLPatterns) {
                if (assembledURLPatterns.contains(urlPattern)) continue;
                assembledURLPatterns.add(urlPattern);
            }
            if (!Validator.isNull((String)assembledServletDefinition.getJspFile())) continue;
            assembledServletDefinition.setJSPFile(fragmentServletDefinition.getJspFile());
        }
    }

    private WebXMLDefinition _assembleWebXMLDefinition(WebXMLDefinition webXMLWebXMLDefinition, List<WebXMLDefinition> fragmentWebXMLDefinitions) throws Exception {
        Map webXMLFilterDefinitions = webXMLWebXMLDefinition.getFilterDefinitions();
        Map webXMLServletDefinitions = webXMLWebXMLDefinition.getServletDefinitions();
        WebXMLDefinition assembledWebXMLDefinition = (WebXMLDefinition)webXMLWebXMLDefinition.clone();
        Map assembledContextParameters = assembledWebXMLDefinition.getContextParameters();
        Map assembledFilterDefinitions = assembledWebXMLDefinition.getFilterDefinitions();
        List assembledListenerDefinitions = assembledWebXMLDefinition.getListenerDefinitions();
        Map assembledServletDefinitions = assembledWebXMLDefinition.getServletDefinitions();
        for (WebXMLDefinition fragmentWebXMLDefinition : fragmentWebXMLDefinitions) {
            Map fragmentContextParameters = fragmentWebXMLDefinition.getContextParameters();
            this._assembleContextParameters(assembledContextParameters, fragmentContextParameters);
            Map fragmentFilterDefinitions = fragmentWebXMLDefinition.getFilterDefinitions();
            this._assembleFilterDefinitions(webXMLFilterDefinitions, assembledFilterDefinitions, fragmentFilterDefinitions);
            List fragmentListenerDefinitions = fragmentWebXMLDefinition.getListenerDefinitions();
            this._assembleListenerDefinitions(assembledListenerDefinitions, fragmentListenerDefinitions);
            Map fragmentServletDefinitions = fragmentWebXMLDefinition.getServletDefinitions();
            this._assembleServletDefinitions(webXMLServletDefinitions, assembledServletDefinitions, fragmentServletDefinitions);
        }
        return assembledWebXMLDefinition;
    }

    private void _collectAnnotatedClasses(WebXMLDefinition webXMLDefinition) {
        for (Class<?> clazz : this._classes) {
            this._collectAnnotatedClasses(webXMLDefinition, clazz);
        }
    }

    private void _collectAnnotatedClasses(WebXMLDefinition webXMLDefinition, Class<?> clazz) {
        WebListener webListener;
        WebFilter webFilter;
        WebServlet webServlet = null;
        try {
            webServlet = clazz.getAnnotation(WebServlet.class);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                StringBundler sb = new StringBundler(6);
                sb.append("Unexpected error retrieving the annotation ");
                sb.append(WebServlet.class);
                sb.append("from class ");
                sb.append(clazz);
                sb.append(" because a some dependency may not be present in ");
                sb.append("the classpath");
                _log.debug((Object)sb.toString(), (Throwable)exception);
            }
            return;
        }
        boolean annotated = false;
        if (webServlet != null) {
            annotated = true;
            ServletDefinition servletDefinition = new ServletDefinition();
            servletDefinition.setAsyncSupported(webServlet.asyncSupported());
            this._setInitParameters(webServlet.initParams(), servletDefinition.getInitParameters());
            String name = webServlet.name();
            if (Validator.isNotNull((String)name)) {
                servletDefinition.setName(name);
            } else {
                servletDefinition.setName(clazz.getCanonicalName());
            }
            this._addURLPatterns(servletDefinition, webServlet.value(), webServlet.urlPatterns());
            this._setServlet(servletDefinition, clazz.getCanonicalName());
            webXMLDefinition.setServletDefinition(servletDefinition.getName(), servletDefinition);
        }
        if ((webFilter = clazz.getAnnotation(WebFilter.class)) != null) {
            annotated = true;
            FilterDefinition filterDefinition = new FilterDefinition();
            filterDefinition.setAsyncSupported(webFilter.asyncSupported());
            Object[] dispatcherTypes = webFilter.dispatcherTypes();
            if (!ArrayUtil.isEmpty((Object[])dispatcherTypes)) {
                for (Object dispatcherType : dispatcherTypes) {
                    filterDefinition.addDispatcher(dispatcherType.name());
                }
            }
            this._setFilter(filterDefinition, clazz.getCanonicalName());
            this._setInitParameters(webFilter.initParams(), filterDefinition.getInitParameters());
            String filterName = webFilter.filterName();
            if (Validator.isNotNull((String)filterName)) {
                filterDefinition.setName(filterName);
            } else {
                filterDefinition.setName(clazz.getCanonicalName());
            }
            Object[] servletNames = webFilter.servletNames();
            if (!ArrayUtil.isEmpty((Object[])servletNames)) {
                for (Object servletName : servletNames) {
                    filterDefinition.addServletName((String)servletName);
                }
            }
            this._addURLPatterns(filterDefinition, webFilter.value(), webFilter.urlPatterns());
            webXMLDefinition.setFilterDefinition(filterDefinition.getName(), filterDefinition);
        }
        if ((webListener = clazz.getAnnotation(WebListener.class)) != null) {
            annotated = true;
            ListenerDefinition listenerDefinition = new ListenerDefinition();
            this._setEventListener(listenerDefinition, clazz.getCanonicalName());
            webXMLDefinition.addListenerDefinition(listenerDefinition);
        }
        if (annotated) {
            this._annotatedClasses.add(clazz);
        }
    }

    private Filter _getFilterInstance(String filterClassName) {
        try {
            Class clazz = this._bundle.loadClass(filterClassName);
            Class<Filter> filterClass = clazz.asSubclass(Filter.class);
            return filterClass.newInstance();
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Bundle ", this._bundle, " is unable to load filter ", filterClassName}), (Throwable)exception);
            return null;
        }
    }

    private EventListener _getListenerInstance(String listenerClassName) {
        try {
            Class clazz = this._bundle.loadClass(listenerClassName);
            Class<EventListener> eventListenerClass = clazz.asSubclass(EventListener.class);
            return eventListenerClass.newInstance();
        }
        catch (Exception exception) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Bundle ", this._bundle, " is unable to load listener ", listenerClassName}), (Throwable)exception);
            return null;
        }
    }

    private Servlet _getServletInstance(String servletClassName) {
        try {
            Class clazz = this._bundle.loadClass(servletClassName);
            Class<Servlet> servletClass = clazz.asSubclass(Servlet.class);
            return servletClass.newInstance();
        }
        catch (Exception exception) {
            _log.error((Object)(this._bundle + " unable to load servlet " + servletClassName), (Throwable)exception);
            return null;
        }
    }

    private void _setEventListener(ListenerDefinition listenerDefinition, String listenerClassName) {
        listenerDefinition.setEventListener(this._getListenerInstance(listenerClassName));
    }

    private void _setFilter(FilterDefinition filterDefinition, String filterClassName) {
        filterDefinition.setFilter(this._getFilterInstance(filterClassName));
    }

    private void _setInitParameters(WebInitParam[] webInitParams, Map<String, String> initParametersMap) {
        if (!ArrayUtil.isEmpty((Object[])webInitParams)) {
            for (WebInitParam webInitParam : webInitParams) {
                initParametersMap.put(webInitParam.name(), webInitParam.value());
            }
        }
    }

    private void _setServlet(ServletDefinition servletDefinition, String servletClassName) {
        servletDefinition.setServlet(this._getServletInstance(servletClassName));
    }

    private static class WebResourceCollection {
        protected List<String> httpMethodExceptions = new ArrayList<String>();
        protected List<String> httpMethods = new ArrayList<String>();
        protected List<String> urlPatterns = new ArrayList<String>();
        protected String webResourceName;

        private WebResourceCollection() {
        }
    }

    private static class ServletMapping {
        protected String servletName;
        protected List<String> urlPatterns = new ArrayList<String>();

        private ServletMapping() {
        }
    }

    private static class JSPConfig {
        protected Map<String, String> mappings = new HashMap<String, String>();

        private JSPConfig() {
        }
    }

    private static class FilterMapping {
        protected List<String> dispatchers = new ArrayList<String>();
        protected String filterName;
        protected String servletName;
        protected List<String> urlPatterns = new ArrayList<String>();

        private FilterMapping() {
        }
    }
}

