/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.servlet.context.helper.internal.order;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.osgi.web.servlet.context.helper.definition.WebXMLDefinition;
import com.liferay.portal.osgi.web.servlet.context.helper.internal.order.OrderBeforeAndAfterException;
import com.liferay.portal.osgi.web.servlet.context.helper.internal.order.OrderCircularDependencyException;
import com.liferay.portal.osgi.web.servlet.context.helper.internal.order.OrderMaxAttemptsException;
import com.liferay.portal.osgi.web.servlet.context.helper.order.Order;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class OrderUtil {
    private static final Comparator<Map.Entry<String, Integer>> _COMPARATOR = new MapEntryComparator();
    private static final int _MAX_ATTEMPTS = 1048;

    public static List<WebXMLDefinition> getOrderedWebXMLDefinitions(List<WebXMLDefinition> webXMLDefinitions, List<String> absoluteOrderingNames) throws OrderBeforeAndAfterException, OrderCircularDependencyException, OrderMaxAttemptsException {
        if (ListUtil.isEmpty(absoluteOrderingNames)) {
            return OrderUtil._getOrderedWebXMLDefinitions(webXMLDefinitions);
        }
        return OrderUtil._getOrderedWebXMLDefinitions(webXMLDefinitions, absoluteOrderingNames);
    }

    private static String[] _appendAndSort(String[] ... namesArray) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (namesArray[0] != null && Arrays.binarySearch(namesArray[0], Order.OTHERS) >= 0) {
            map.put(Order.OTHERS, 1);
        }
        String[][] stringArray = namesArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] names;
            for (String name : names = stringArray[i]) {
                if (name.equals(Order.OTHERS)) continue;
                map.put(name, 1);
            }
        }
        Set set = map.keySet();
        Object[] orderedNames = set.toArray(new String[0]);
        Arrays.sort(orderedNames);
        return orderedNames;
    }

    private static void _checkForBothBeforeAndAfter(WebXMLDefinition webXMLDefinition) throws OrderBeforeAndAfterException {
        String[] names;
        String[] afterNames;
        String[] beforeNames;
        Order order = webXMLDefinition.getOrder();
        EnumMap routes = order.getRoutes();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String beforeName : beforeNames = (String[])routes.get(Order.Path.BEFORE)) {
            Integer value = (Integer)map.get(beforeName);
            value = value == null ? Integer.valueOf(1) : Integer.valueOf(value + 1);
            map.put(beforeName, value);
        }
        for (String afterName : afterNames = (String[])routes.get(Order.Path.AFTER)) {
            Integer value = (Integer)map.get(afterName);
            value = value == null ? Integer.valueOf(1) : Integer.valueOf(value + 1);
            map.put(afterName, value);
        }
        Set set = map.keySet();
        for (String name : names = set.toArray(new String[0])) {
            if ((Integer)map.get(name) <= 1) continue;
            throw new OrderBeforeAndAfterException(webXMLDefinition.getFragmentName(), name);
        }
    }

    private static void _checkForSpecExceptions(List<WebXMLDefinition> webXMLDefinitions) throws OrderBeforeAndAfterException, OrderCircularDependencyException {
        for (WebXMLDefinition webXMLDefinition : webXMLDefinitions) {
            OrderUtil._checkForBothBeforeAndAfter(webXMLDefinition);
            for (Order.Path path : Order.Path.values()) {
                OrderUtil._mapRoutes(webXMLDefinition, path, webXMLDefinitions);
            }
        }
    }

    private static List<String> _getFragmentNames(WebXMLDefinition[] webXMLDefinitions) {
        LinkedList<String> fragmentNames = new LinkedList<String>();
        for (WebXMLDefinition webXMLDefinition : webXMLDefinitions) {
            fragmentNames.add(webXMLDefinition.getFragmentName());
        }
        return fragmentNames;
    }

    private static List<WebXMLDefinition> _getOrderedWebXMLDefinitions(List<WebXMLDefinition> webXMLDefinitions) throws OrderBeforeAndAfterException, OrderCircularDependencyException, OrderMaxAttemptsException {
        OrderUtil._checkForSpecExceptions(webXMLDefinitions);
        webXMLDefinitions = OrderUtil._preSort(webXMLDefinitions);
        WebXMLDefinition[] webXMLDefinitionsArray = webXMLDefinitions.toArray(new WebXMLDefinition[0]);
        OrderUtil._innerSort(webXMLDefinitionsArray);
        OrderUtil._postSort(webXMLDefinitionsArray);
        return new ArrayList<WebXMLDefinition>(Arrays.asList(webXMLDefinitionsArray));
    }

    private static List<WebXMLDefinition> _getOrderedWebXMLDefinitions(List<WebXMLDefinition> webXMLDefinitions, List<String> absoluteOrderingNames) {
        ArrayList<WebXMLDefinition> orderedWebXMLDefinitions = new ArrayList<WebXMLDefinition>();
        CopyOnWriteArrayList<WebXMLDefinition> tempWebXMLDefinitions = new CopyOnWriteArrayList<WebXMLDefinition>();
        tempWebXMLDefinitions.addAll(webXMLDefinitions);
        block0: for (String absoluteOrderingName : absoluteOrderingNames) {
            if (Order.OTHERS.equals(absoluteOrderingName)) continue;
            boolean found = false;
            for (WebXMLDefinition webXMLDefinition : tempWebXMLDefinitions) {
                String fragmentName = webXMLDefinition.getFragmentName();
                if (!found && absoluteOrderingName.equals(fragmentName)) {
                    found = true;
                    orderedWebXMLDefinitions.add(webXMLDefinition);
                    tempWebXMLDefinitions.remove(webXMLDefinition);
                    continue;
                }
                if (!found || !absoluteOrderingName.equals(fragmentName)) continue;
                continue block0;
            }
        }
        int index = absoluteOrderingNames.indexOf(Order.OTHERS);
        if (index != -1) {
            for (WebXMLDefinition webXMLDefinition : tempWebXMLDefinitions) {
                orderedWebXMLDefinitions.add(index, webXMLDefinition);
            }
        }
        return orderedWebXMLDefinitions;
    }

    private static Map<String, WebXMLDefinition> _getWebXMLDefinitionsMap(List<WebXMLDefinition> webXMLDefinitions) {
        HashMap<String, WebXMLDefinition> webXMLDefinitionsMap = new HashMap<String, WebXMLDefinition>();
        for (WebXMLDefinition webXMLDefinition : webXMLDefinitions) {
            webXMLDefinitionsMap.put(webXMLDefinition.getFragmentName(), webXMLDefinition);
        }
        return webXMLDefinitionsMap;
    }

    private static int _innerSort(WebXMLDefinition[] webXMLDefinitions) throws OrderMaxAttemptsException {
        boolean attempting = true;
        int attempts = 0;
        while (attempting) {
            if (attempts > 1048) {
                throw new OrderMaxAttemptsException(1048);
            }
            attempting = false;
            int last = webXMLDefinitions.length - 1;
            for (int i = 0; i < webXMLDefinitions.length; ++i) {
                int x = i;
                int y = x + 1;
                if (x == last) {
                    y = x;
                    x = 0;
                }
                if (!OrderUtil._isDisordered(webXMLDefinitions[x], webXMLDefinitions[y])) continue;
                WebXMLDefinition webXMLDefinition = webXMLDefinitions[x];
                webXMLDefinitions[x] = webXMLDefinitions[y];
                webXMLDefinitions[y] = webXMLDefinition;
                attempting = true;
            }
            ++attempts;
        }
        return attempts;
    }

    private static boolean _isDisordered(WebXMLDefinition webXMLDefinition1, WebXMLDefinition webXMLDefinition2) {
        EnumMap routes;
        Order order1 = webXMLDefinition1.getOrder();
        Order order2 = webXMLDefinition2.getOrder();
        if (order1.isOrdered() && !order2.isOrdered() && !ArrayUtil.isEmpty((Object[])((Object[])(routes = order1.getRoutes()).get(Order.Path.AFTER))) && !order1.isBeforeOthers()) {
            return true;
        }
        if (order2.isBefore(webXMLDefinition1.getFragmentName()) || order1.isAfter(webXMLDefinition2.getFragmentName())) {
            return true;
        }
        if (!(!order1.isAfterOthers() || order1.isBefore(webXMLDefinition2.getFragmentName()) || order1.isAfterOthers() && order2.isAfterOthers())) {
            return true;
        }
        return order2.isBeforeOthers() && !order2.isAfter(webXMLDefinition1.getFragmentName()) && (!order1.isBeforeOthers() || !order2.isBeforeOthers());
    }

    private static void _mapRoutes(WebXMLDefinition webXMLDefinition, Order.Path path, List<WebXMLDefinition> webXMLDefinitions) throws OrderCircularDependencyException {
        String[] pathNames;
        Order order = webXMLDefinition.getOrder();
        EnumMap orderRoutes = order.getRoutes();
        for (String pathName : pathNames = (String[])orderRoutes.get(path)) {
            if (pathName.equals(Order.OTHERS)) continue;
            for (WebXMLDefinition curWebXMLDefinition : webXMLDefinitions) {
                EnumMap<Order.Path, Object> routes;
                String fragmentName;
                if (!pathName.equals(curWebXMLDefinition.getFragmentName())) continue;
                Order curOrder = curWebXMLDefinition.getOrder();
                EnumMap curRoutes = curOrder.getRoutes();
                Object[] curPathNames = (String[])curRoutes.get(path);
                if (Arrays.binarySearch(curPathNames, fragmentName = webXMLDefinition.getFragmentName()) >= 0) {
                    throw new OrderCircularDependencyException(path, webXMLDefinitions);
                }
                Order.Path oppositePath = null;
                oppositePath = path == Order.Path.BEFORE ? Order.Path.AFTER : Order.Path.BEFORE;
                Object[] oppositePathNames = (String[])curRoutes.get(oppositePath);
                if (Arrays.binarySearch(oppositePathNames, fragmentName) < 0) {
                    routes = new EnumMap<Order.Path, Object>(Order.Path.class);
                    routes.put(path, (Object)curPathNames);
                    routes.put(oppositePath, (Object)OrderUtil._appendAndSort((String[])curRoutes.get(oppositePath), {fragmentName}));
                    curOrder.setRoutes(routes);
                }
                if (!ArrayUtil.isNotEmpty((Object[])curPathNames)) continue;
                routes = new EnumMap(Order.Path.class);
                routes.put(path, (Object)OrderUtil._appendAndSort(new String[][]{pathNames, curPathNames}));
                routes.put(oppositePath, orderRoutes.get(oppositePath));
                order.setRoutes(routes);
            }
        }
    }

    private static void _postSort(WebXMLDefinition[] webXMLDefinitions) {
        int i = 0;
        while (i < webXMLDefinitions.length) {
            List<String> fragmentNames = OrderUtil._getFragmentNames(webXMLDefinitions);
            boolean done = true;
            block1: for (int j = 0; j < webXMLDefinitions.length; ++j) {
                int k = 0;
                for (String curFragmentName : fragmentNames) {
                    if (curFragmentName.equals(webXMLDefinitions[j].getFragmentName())) break;
                    Order order = webXMLDefinitions[j].getOrder();
                    if (order.isBefore(curFragmentName)) {
                        WebXMLDefinition webXMLDefinition = null;
                        for (int l = 0; l < webXMLDefinitions.length; ++l) {
                            if (l == k) {
                                webXMLDefinition = webXMLDefinitions[l];
                            }
                            if (webXMLDefinition != null && l != j) {
                                webXMLDefinitions[l] = webXMLDefinitions[l + 1];
                            }
                            if (l != j) continue;
                            webXMLDefinitions[l] = webXMLDefinition;
                            done = false;
                            break;
                        }
                        if (!done) continue block1;
                    }
                    ++k;
                }
            }
            if (!done) continue;
            break;
        }
    }

    private static List<WebXMLDefinition> _preSort(List<WebXMLDefinition> webXMLDefinitions) {
        ArrayList<WebXMLDefinition> preSortWebXMLDefinitions = new ArrayList<WebXMLDefinition>();
        Map<String, Integer> map = new LinkedHashMap<String, Integer>();
        LinkedList<WebXMLDefinition> tempWebXMLDefinitions = new LinkedList<WebXMLDefinition>();
        for (WebXMLDefinition webXMLDefinition : webXMLDefinitions) {
            Order order = webXMLDefinition.getOrder();
            if (Validator.isNull((String)webXMLDefinition.getFragmentName()) && !order.isOrdered()) {
                tempWebXMLDefinitions.add(webXMLDefinition);
                continue;
            }
            EnumMap routes = order.getRoutes();
            String[] afterPathNames = (String[])routes.get(Order.Path.AFTER);
            String[] beforePathNames = (String[])routes.get(Order.Path.BEFORE);
            map.put(webXMLDefinition.getFragmentName(), afterPathNames.length + beforePathNames.length);
        }
        map = OrderUtil._sortDescendingByValue(map);
        Map<String, WebXMLDefinition> webXMLDefinitionsMap = OrderUtil._getWebXMLDefinitionsMap(webXMLDefinitions);
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            preSortWebXMLDefinitions.add(webXMLDefinitionsMap.get(entry.getKey()));
        }
        for (WebXMLDefinition webXMLDefinition : tempWebXMLDefinitions) {
            preSortWebXMLDefinitions.add(webXMLDefinition);
        }
        return preSortWebXMLDefinitions;
    }

    private static Map<String, Integer> _sortDescendingByValue(Map<String, Integer> map) {
        LinkedList<Map.Entry<String, Integer>> list = new LinkedList<Map.Entry<String, Integer>>(map.entrySet());
        Collections.sort(list, _COMPARATOR);
        LinkedHashMap<String, Integer> sortedMap = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : list) {
            sortedMap.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return sortedMap;
    }

    private static class MapEntryComparator
    implements Comparator<Map.Entry<String, Integer>> {
        private MapEntryComparator() {
        }

        @Override
        public int compare(Map.Entry<String, Integer> map1, Map.Entry<String, Integer> map2) {
            Integer integer1 = map1.getValue();
            Integer integer2 = map2.getValue();
            return integer2.compareTo(integer1);
        }
    }
}

