/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.AnnotationDefaultAttribute;
import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.BootstrapMethodsAttribute;
import aQute.bnd.classfile.CodeAttribute;
import aQute.bnd.classfile.ConstantPool;
import aQute.bnd.classfile.ConstantValueAttribute;
import aQute.bnd.classfile.DeprecatedAttribute;
import aQute.bnd.classfile.ElementInfo;
import aQute.bnd.classfile.EnclosingMethodAttribute;
import aQute.bnd.classfile.ExceptionsAttribute;
import aQute.bnd.classfile.FieldInfo;
import aQute.bnd.classfile.InnerClassesAttribute;
import aQute.bnd.classfile.LineNumberTableAttribute;
import aQute.bnd.classfile.LocalVariableTableAttribute;
import aQute.bnd.classfile.LocalVariableTypeTableAttribute;
import aQute.bnd.classfile.MethodInfo;
import aQute.bnd.classfile.MethodParametersAttribute;
import aQute.bnd.classfile.ModuleAttribute;
import aQute.bnd.classfile.ModuleMainClassAttribute;
import aQute.bnd.classfile.ModulePackagesAttribute;
import aQute.bnd.classfile.NestHostAttribute;
import aQute.bnd.classfile.NestMembersAttribute;
import aQute.bnd.classfile.RuntimeInvisibleAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeInvisibleTypeAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleParameterAnnotationsAttribute;
import aQute.bnd.classfile.RuntimeVisibleTypeAnnotationsAttribute;
import aQute.bnd.classfile.SignatureAttribute;
import aQute.bnd.classfile.SourceDebugExtensionAttribute;
import aQute.bnd.classfile.SourceFileAttribute;
import aQute.bnd.classfile.StackMapTableAttribute;
import aQute.bnd.classfile.SyntheticAttribute;
import aQute.bnd.classfile.UnrecognizedAttribute;
import aQute.lib.io.ByteBufferDataInput;
import java.io.DataInput;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class ClassFile
extends ElementInfo {
    public static final int MAJOR_VERSION = 55;
    private static final int ACC_ANNOTATION = 8192;
    private static final int ACC_ENUM = 16384;
    private static final int ACC_MODULE = 32768;
    public final int minor_version;
    public final int major_version;
    public final ConstantPool constant_pool;
    public final String this_class;
    public final String super_class;
    public final String[] interfaces;
    public final FieldInfo[] fields;
    public final MethodInfo[] methods;

    ClassFile(int minor_version, int major_version, ConstantPool constant_pool, int access_flags, String this_class, String super_class, String[] interfaces, FieldInfo[] fields, MethodInfo[] methods, Attribute[] attributes) {
        super(access_flags, attributes);
        this.minor_version = minor_version;
        this.major_version = major_version;
        this.constant_pool = constant_pool;
        this.this_class = this_class;
        this.super_class = super_class;
        this.interfaces = interfaces;
        this.fields = fields;
        this.methods = methods;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Modifier.toString(this.access & Modifier.classModifiers()));
        if (sb.length() > 0) {
            sb.append(' ');
        }
        if ((this.access & 0x200) != 0) {
            if ((this.access & 0x2000) != 0) {
                sb.append('@');
            }
            sb.append("interface ");
        } else if ((this.access & 0x4000) != 0) {
            sb.append("enum ");
        } else if ((this.access & 0x8000) == 0) {
            sb.append("class ");
        }
        return sb.append(this.this_class).append(' ').append(Arrays.toString(this.attributes)).toString();
    }

    public static ClassFile parseClassFile(DataInput in) throws IOException {
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new IOException("Not a valid class file (no CAFEBABE header)");
        }
        int minor_version = in.readUnsignedShort();
        int major_version = in.readUnsignedShort();
        ConstantPool constant_pool = ConstantPool.parseConstantPool(in);
        int access_flags = in.readUnsignedShort();
        int this_class_index = in.readUnsignedShort();
        String this_class = constant_pool.className(this_class_index);
        int super_class_index = in.readUnsignedShort();
        String super_class = super_class_index != 0 ? constant_pool.className(super_class_index) : null;
        int interfaces_count = in.readUnsignedShort();
        String[] interfaces = new String[interfaces_count];
        for (int i = 0; i < interfaces_count; ++i) {
            int interface_index = in.readUnsignedShort();
            interfaces[i] = constant_pool.className(interface_index);
        }
        int fields_count = in.readUnsignedShort();
        FieldInfo[] fields = new FieldInfo[fields_count];
        for (int i = 0; i < fields_count; ++i) {
            fields[i] = FieldInfo.parseFieldInfo(in, constant_pool);
        }
        int methods_count = in.readUnsignedShort();
        MethodInfo[] methods = new MethodInfo[methods_count];
        for (int i = 0; i < methods_count; ++i) {
            methods[i] = MethodInfo.parseMethodInfo(in, constant_pool);
        }
        Attribute[] attributes = ClassFile.parseAttributes(in, constant_pool);
        ClassFile class_file = new ClassFile(minor_version, major_version, constant_pool, access_flags, this_class, super_class, interfaces, fields, methods, attributes);
        return class_file;
    }

    static Attribute[] parseAttributes(DataInput in, ConstantPool constant_pool) throws IOException {
        int attributes_count = in.readUnsignedShort();
        Attribute[] attributes = new Attribute[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            attributes[i] = ClassFile.parseAttribute(in, constant_pool);
        }
        return attributes;
    }

    static Attribute parseAttribute(DataInput in, ConstantPool constant_pool) throws IOException {
        String attribute_name;
        int attribute_name_index = in.readUnsignedShort();
        int attribute_length = in.readInt();
        switch (attribute_name = constant_pool.utf8(attribute_name_index)) {
            case "AnnotationDefault": {
                return AnnotationDefaultAttribute.parseAnnotationDefaultAttribute(in, constant_pool);
            }
            case "BootstrapMethods": {
                return BootstrapMethodsAttribute.parseBootstrapMethodsAttribute(in, constant_pool);
            }
            case "Code": {
                return CodeAttribute.parseCodeAttribute(in, constant_pool);
            }
            case "ConstantValue": {
                return ConstantValueAttribute.parseConstantValueAttribute(in, constant_pool);
            }
            case "Deprecated": {
                return DeprecatedAttribute.parseDeprecatedAttribute(in, constant_pool);
            }
            case "EnclosingMethod": {
                return EnclosingMethodAttribute.parseEnclosingMethodAttribute(in, constant_pool);
            }
            case "Exceptions": {
                return ExceptionsAttribute.parseExceptionsAttribute(in, constant_pool);
            }
            case "InnerClasses": {
                return InnerClassesAttribute.parseInnerClassesAttribute(in, constant_pool);
            }
            case "LineNumberTable": {
                return LineNumberTableAttribute.parseLineNumberTableAttribute(in, constant_pool);
            }
            case "LocalVariableTable": {
                return LocalVariableTableAttribute.parseLocalVariableTableAttribute(in, constant_pool);
            }
            case "LocalVariableTypeTable": {
                return LocalVariableTypeTableAttribute.parseLocalVariableTypeTableAttribute(in, constant_pool);
            }
            case "MethodParameters": {
                return MethodParametersAttribute.parseMethodParametersAttribute(in, constant_pool);
            }
            case "Module": {
                return ModuleAttribute.parseModuleAttribute(in, constant_pool);
            }
            case "ModuleMainClass": {
                return ModuleMainClassAttribute.parseModuleMainClassAttribute(in, constant_pool);
            }
            case "ModulePackages": {
                return ModulePackagesAttribute.parseModulePackagesAttribute(in, constant_pool);
            }
            case "NestHost": {
                return NestHostAttribute.parseNestHostAttribute(in, constant_pool);
            }
            case "NestMembers": {
                return NestMembersAttribute.parseNestMembersAttribute(in, constant_pool);
            }
            case "RuntimeInvisibleAnnotations": {
                return RuntimeInvisibleAnnotationsAttribute.parseRuntimeInvisibleAnnotationsAttribute(in, constant_pool);
            }
            case "RuntimeInvisibleParameterAnnotations": {
                return RuntimeInvisibleParameterAnnotationsAttribute.parseRuntimeInvisibleParameterAnnotationsAttribute(in, constant_pool);
            }
            case "RuntimeInvisibleTypeAnnotations": {
                return RuntimeInvisibleTypeAnnotationsAttribute.parseRuntimeInvisibleTypeAnnotationsAttribute(in, constant_pool);
            }
            case "RuntimeVisibleAnnotations": {
                return RuntimeVisibleAnnotationsAttribute.parseRuntimeVisibleAnnotationsAttribute(in, constant_pool);
            }
            case "RuntimeVisibleParameterAnnotations": {
                return RuntimeVisibleParameterAnnotationsAttribute.parseRuntimeVisibleParameterAnnotationsAttribute(in, constant_pool);
            }
            case "RuntimeVisibleTypeAnnotations": {
                return RuntimeVisibleTypeAnnotationsAttribute.parseRuntimeVisibleTypeAnnotationsAttribute(in, constant_pool);
            }
            case "Signature": {
                return SignatureAttribute.parseSignatureAttribute(in, constant_pool);
            }
            case "SourceDebugExtension": {
                return SourceDebugExtensionAttribute.parseSourceDebugExtensionAttribute(in, attribute_length);
            }
            case "SourceFile": {
                return SourceFileAttribute.parseSourceFileAttribute(in, constant_pool);
            }
            case "StackMapTable": {
                return StackMapTableAttribute.parseStackMapTableAttribute(in, constant_pool);
            }
            case "Synthetic": {
                return SyntheticAttribute.parseSyntheticAttribute(in, constant_pool);
            }
        }
        return UnrecognizedAttribute.parseUnrecognizedAttribute(in, attribute_name, attribute_length);
    }

    static ByteBuffer slice(DataInput in, int length) throws IOException {
        if (in instanceof ByteBufferDataInput) {
            ByteBufferDataInput bbin = (ByteBufferDataInput)in;
            return bbin.slice(length);
        }
        byte[] array = new byte[length];
        in.readFully(array, 0, length);
        return ByteBuffer.wrap(array, 0, length);
    }
}

