/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Verifier;
import aQute.bnd.version.MavenVersion;
import aQute.bnd.version.Version;
import aQute.bnd.version.VersionRange;
import aQute.lib.base64.Base64;
import aQute.lib.collections.Iterables;
import aQute.lib.exceptions.Exceptions;
import aQute.lib.filter.ExtendedFilter;
import aQute.lib.filter.Get;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import aQute.lib.utf8properties.UTF8Properties;
import aQute.libg.glob.Glob;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class Macro {
    private static final String NULLVALUE = "c29e43048791e250dfd5723e7b8aa048df802c9262cfa8fbc4475b2e392a8ad2";
    private static final String LITERALVALUE = "017a3ddbfc0fcd27bcdb2590cdb713a379ae59ef";
    private static final Pattern NUMERIC_P = Pattern.compile("[-+]?(\\d*\\.?\\d+|\\d+\\.)(e[-+]?[0-9]+)?");
    private static final Pattern PRINTF_P = Pattern.compile("%(?:(\\d+)\\$)?(-|\\+|0|\\(|,|\\^|#| )*(\\d*)?(?:\\.(\\d+))?(a|A|b|B|h|H|d|f|c|s|x|X|u|o|z|Z|e|E|g|G|p|n|b|B|%)");
    Processor domain;
    Reporter reporter;
    Object[] targets;
    boolean flattening;
    String profile;
    private boolean nosystem;
    ScriptEngine engine = null;
    ScriptContext context = null;
    Bindings bindings = null;
    StringWriter stdout = new StringWriter();
    StringWriter stderr = new StringWriter();
    private static final String ESCAPING = "(?<!(?<!(?<!(?<!\\\\)\\\\)\\\\)\\\\)";
    private static final String SEMICOLON = ";";
    private static final String ESCAPED_SEMICOLON = "\\\\;";
    private static final Pattern SEMICOLON_P = Pattern.compile("(?<!(?<!(?<!(?<!\\\\)\\\\)\\\\)\\\\);");
    private static final Pattern ESCAPED_SEMICOLON_P = Pattern.compile("(?<!(?<!(?<!(?<!\\\\)\\\\)\\\\)\\\\)\\\\;");
    static final String _uniqHelp = "${uniq;<list> ...}";
    static final String _removeallHelp = "${removeall;<list>;<list>}";
    static final String _retainallHelp = "${retainall;<list>;<list>}";
    static final String _filterHelp = "${%s;<list>;<regex>}";
    static final String _sortHelp = "${sort;<list>...}";
    static final String _nsortHelp = "${nsort;<list>...}";
    static final String _joinHelp = "${join;<list>...}";
    static final String _sjoinHelp = "${sjoin;<separator>;<list>...}";
    static final String _ifHelp = "${if;<condition>;<iftrue> [;<iffalse>] } condition is either a filter expression or truthy";
    public static final String _nowHelp = "${now;pattern|'long'}, returns current time";
    public static final String _fmodifiedHelp = "${fmodified;<list of filenames>...}, return latest modification date";
    static final String _defHelp = "${def;<name>[;<value>]}, get the property or a default value if unset";
    static final String _listHelp = "${list;[<name>...]}, returns a list of the values of the named properties with escaped semicolons";
    static final String _replaceHelp = "${replace;<list>;<regex>;[<replace>[;delimiter]]}";
    static final String _replacelistHelp = "${replacelist;<list>;<regex>;[<replace>[;delimiter]]}";
    static final String _replacestringHelp = "${replacesting;<target>;<regex>;[<replace>]}";
    static final String _toclassnameHelp = "${toclassname;<list of class paths>}, convert class paths to FQN class names ";
    static final String _toclasspathHelp = "${toclasspath;<list>[;boolean]}, convert a list of class names to paths";
    static final String _lsrHelp = "${lsr;<dir>;[<selector>...]}";
    static final String _lsaHelp = "${lsa;<dir>;[<selector>...]}";
    static final String MASK_STRING = "[\\-+=~0123456789]{0,3}[=~]?";
    static final Pattern MASK = Pattern.compile("[\\-+=~0123456789]{0,3}[=~]?");
    static final String _versionmaskHelp = "${versionmask;<mask>;<version>}, modify a version\n<mask> ::= [ M [ M [ M [ MQ ]]]\nM ::= '+' | '-' | MQ\nMQ ::= '~' | '='";
    static final String _versionHelp = "${versionmask;<mask>;<version>}, modify a version\n<mask> ::= [ M [ M [ M [ MQ ]]]\nM ::= '+' | '-' | MQ\nMQ ::= '~' | '='";
    static final Pattern[] _versionPattern = new Pattern[]{null, null, MASK, Verifier.VERSION};
    static final Pattern RANGE_MASK = Pattern.compile("(\\[|\\()([\\-+=~0123456789]{0,3}[=~]?),([\\-+=~0123456789]{0,3}[=~]?)(\\]|\\))");
    static final String _rangeHelp = "${range;<mask>[;<version>]}, range for version, if version not specified lookup ${@}\n<mask> ::= [ M [ M [ M [ MQ ]]]\nM ::= '+' | '-' | MQ\nMQ ::= '~' | '='";
    static final Pattern[] _rangePattern = new Pattern[]{null, RANGE_MASK};
    private static final String LOCALTARGET_NAME = "@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*";
    private static final Pattern LOCALTARGET_P = Pattern.compile("\\$(\\{@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*\\}|\\[@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*\\]|\\(@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*\\)|<@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*>|\u00ab@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*\u00bb|\u2039@[^${}\\[\\]()<>\u00ab\u00bb\u2039\u203a]*\u203a)");
    static final String _envHelp = "${env;<name>[;alternative]}, get the environment variable";
    static final String _catHelp = "${cat;<in>}, get the content of a file";
    static final String _base64Help = "${base64;<file>[;fileSizeLimit]}, get the Base64 encoding of a file";
    static final String _digestHelp = "${digest;<algo>;<in>}, get a digest (e.g. MD5, SHA-256) of a file";
    public static final String _fileHelp = "${file;<base>;<paths>...}, create correct OS dependent path";
    static final String _osfileHelp = "${osfile;<base>;<path>}, create correct OS dependent path";
    public static final String _sizeHelp = "${size;<collection>;...}, count the number of elements (of all collections combined)";
    static final String _startswithHelp = "${startswith;<string>;<prefix>}";
    static final String _endswithHelp = "${endswith;<string>;<suffix>}";
    static final String _extensionHelp = "${extension;<string>}";
    static final String _stemHelp = "${stem;<string>}";
    static final String _substringHelp = "${substring;<string>;<start>[;<end>]}";
    static final String _randHelp = "${rand;[<min>[;<end>]]}";
    static final Random random = new Random();
    static final String _lengthHelp = "${length;<string>}";
    static final String _getHelp = "${get;<index>;<list>}";
    static final String _sublistHelp = "${sublist;<start>;<end>[;<list>...]}";
    static final String _firstHelp = "${first;<list>[;<list>...]}";
    static final String _lastHelp = "${last;<list>[;<list>...]}";
    static final String _maxHelp = "${max;<list>[;<list>...]}";
    static final String _minHelp = "${min;<list>[;<list>...]}";
    static final String _nmaxHelp = "${nmax;<list>[;<list>...]}";
    static final String _nminHelp = "${nmin;<list>[;<list>...]}";
    static final String _sumHelp = "${sum;<list>[;<list>...]}";
    static final String _averageHelp = "${average;<list>[;<list>...]}";
    static final String _reverseHelp = "${reverse;<list>[;<list>...]}";
    static final String _indexofHelp = "${indexof;<value>;<list>[;<list>...]}";
    static final String _lastindexofHelp = "${lastindexof;<value>;<list>[;<list>...]}";
    static final String _findHelp = "${find;<target>;<searched>}";
    static final String _findlastHelp = "${findlast;<find>;<target>}";
    static final String _splitHelp = "${split;<regex>[;<target>...]}";
    static final String _jsHelp = "${js [;<js expr>...]}";
    static final String _toupperHelp = "${toupper;<target>}";
    static final String _tolowerHelp = "${tolower;<target>}";
    static final String _compareHelp = "${compare;<astring>;<bstring>}";
    static final String _ncompareHelp = "${ncompare;<anumber>;<bnumber>}";
    static final String _matchesHelp = "${matches;<target>;<regex>}";
    static final String _substHelp = "${subst;<target>;<regex>[;<replace>[;count]]}";
    static final String _trimHelp = "${trim;<target>}";
    static final String _formatHelp = "${format;<format>[;args...]}";
    static final String _isemptyHelp = "${isempty;[<target>...]}";
    static final String _isnumberHelp = "${isnumber;<target>[;<target>...]}";
    static final String _isHelp = "${is;<a>;<b>}";
    static final String _mapHelp = "${map;<macro>[;<list>...]}";
    static final String _foreachHelp = "${foreach;<macro>[;<list>...]}";
    static final String _applyHelp = "${apply;<macro>[;<list>...]}";
    static final String _globHelp = "${glob;<globexp>} (turn it into a regular expression)";

    public Macro(Processor domain, Object ... targets) {
        this.domain = domain;
        this.reporter = domain;
        this.targets = targets;
        if (targets != null) {
            for (Object o : targets) {
                assert (o != null);
            }
        }
    }

    public String process(String line, Processor source) {
        return this.process(line, new Link(source, null, line));
    }

    String process(String line, Link link) {
        StringBuilder sb = new StringBuilder();
        this.process(line, 0, '\u0000', '\u0000', sb, link);
        return sb.toString();
    }

    int process(CharSequence org, int index, char begin, char end, StringBuilder result, Link link) {
        if (org == null) {
            return index;
        }
        StringBuilder line = new StringBuilder(org);
        int nesting = 1;
        StringBuilder variable = new StringBuilder();
        while (index < line.length()) {
            char c1;
            if ((c1 = line.charAt(index++)) == end) {
                if (--nesting == 0) {
                    result.append(this.replace(variable.toString(), link, begin, end));
                    return index;
                }
            } else if (c1 == begin) {
                ++nesting;
            } else {
                if (c1 == '\\' && index < line.length() - 1 && line.charAt(index) == '$') {
                    ++index;
                    variable.append('$');
                    continue;
                }
                if (c1 == '$' && index < line.length() - 2) {
                    char c2 = line.charAt(index);
                    char terminator = Macro.getTerminator(c2);
                    if (terminator != '\u0000') {
                        index = this.process(line, index + 1, c2, terminator, variable, link);
                        continue;
                    }
                } else if (c1 == '.' && index < line.length() && line.charAt(index) == '/' && (index == 1 || Character.isWhitespace(line.charAt(index - 2)))) {
                    ++index;
                    variable.append(IO.absolutePath(this.domain.getBase()));
                    variable.append('/');
                    continue;
                }
            }
            variable.append(c1);
        }
        result.append((CharSequence)variable);
        return index;
    }

    public static char getTerminator(char c) {
        switch (c) {
            case '(': {
                return ')';
            }
            case '[': {
                return ']';
            }
            case '{': {
                return '}';
            }
            case '<': {
                return '>';
            }
            case '\u00ab': {
                return '\u00bb';
            }
            case '\u2039': {
                return '\u203a';
            }
        }
        return '\u0000';
    }

    protected String getMacro(String key, Link link) {
        return this.getMacro(key, link, '{', '}', null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getMacro(String key, Link link, char begin, char end, String profile) {
        if (link != null && link.contains(key)) {
            return "${infinite:" + link.toString() + "}";
        }
        if (key != null) {
            if (!(key = key.trim()).isEmpty()) {
                String[] parts;
                String keyins = key;
                if (profile != null) {
                    key = "[" + profile + "]" + key;
                    keyins = "\\[" + profile + "\\]" + keyins;
                }
                if (key.indexOf(59) < 0) {
                    Instruction ins = new Instruction(keyins);
                    if (!ins.isLiteral()) {
                        String keyname = key;
                        return this.domain.stream().filter(ins::matches).sorted().map(k -> this.replace((String)k, new Link(this.domain, link, keyname), begin, end)).filter(Objects::nonNull).collect(Strings.joining());
                    }
                    key = ins.getLiteral();
                }
                for (Processor source = this.domain; source != null; source = source.getParent()) {
                    String value = source.getProperties().getProperty(key);
                    if (value == null) continue;
                    return this.process(value, new Link(source, link, key));
                }
                String value = this.doCommands(key, link);
                if (value != null) {
                    if (value == NULLVALUE) {
                        return null;
                    }
                    if (value == LITERALVALUE) {
                        return LITERALVALUE;
                    }
                    return this.process(value, new Link(this.domain, link, key));
                }
                if (key != null && key.trim().length() > 0) {
                    value = System.getProperty(key);
                    if (value == null && key.startsWith("env.")) {
                        value = System.getenv(key.substring(4));
                    }
                    if (value != null) {
                        return value;
                    }
                }
                if (key != null && key.indexOf(59) >= 0 && (parts = SEMICOLON_P.split(key, 0)).length > 1) {
                    String template;
                    if (parts.length >= 16) {
                        this.reporter.error("too many arguments for template: %s, max is 16", key);
                    }
                    if ((template = this.domain.getProperties().getProperty(parts[0])) != null) {
                        this.domain = new Processor(this.domain);
                        for (int i = 0; i < 16; ++i) {
                            this.domain.setProperty("" + i, i < parts.length ? parts[i] : "null");
                        }
                        String joined = Arrays.stream(parts, 1, parts.length).collect(Strings.joining());
                        this.domain.setProperty("#", joined);
                        try {
                            value = this.process(template, new Link(this.domain, link, key));
                            if (value != null) {
                                String string = value;
                                return string;
                            }
                        }
                        finally {
                            this.domain = this.domain.getParent();
                        }
                    }
                }
            } else {
                this.reporter.warning("Found empty macro key", new Object[0]);
            }
        } else {
            this.reporter.warning("Found null macro key", new Object[0]);
        }
        if (key != null && !key.startsWith("[") && !key.equals("-profile")) {
            String replace;
            if (profile == null) {
                profile = this.domain.getProperty("-profile");
            }
            if (profile != null && (replace = this.getMacro(key, link, begin, end, profile)) != null) {
                return replace;
            }
        }
        return null;
    }

    public String replace(String key, Link link) {
        return this.replace(key, link, '{', '}');
    }

    private String replace(String key, Link link, char begin, char end) {
        String value = this.getMacro(key, link, begin, end, null);
        if (value != LITERALVALUE) {
            if (value != null) {
                return value;
            }
            if (!this.flattening && !key.startsWith("@")) {
                this.reporter.warning("No translation found for macro: %s", key);
            }
        }
        return "$" + begin + key + end;
    }

    private String doCommands(String key, Link source) {
        String[] args = SEMICOLON_P.split(key, 0);
        if (args == null || args.length == 0) {
            return null;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].indexOf(92) < 0) continue;
            args[i] = ESCAPED_SEMICOLON_P.matcher(args[i]).replaceAll(SEMICOLON);
        }
        if (args[0].startsWith("^")) {
            Processor parent;
            String varname = args[0].substring(1).trim();
            if (source != null && (parent = source.start.getParent()) != null) {
                return parent.getProperty(varname);
            }
            return null;
        }
        for (Processor rover = this.domain; rover != null; rover = rover.getParent()) {
            String result = this.doCommand(rover, args[0], args);
            if (result == null) continue;
            return result;
        }
        for (int i = 0; this.targets != null && i < this.targets.length; ++i) {
            String result = this.doCommand(this.targets[i], args[0], args);
            if (result == null) continue;
            return result;
        }
        return this.doCommand(this, args[0], args);
    }

    private String doCommand(Object target, String method, String[] args) {
        if (target != null) {
            MethodHandle mh;
            Method m;
            if (method.startsWith("-")) {
                return null;
            }
            String part = method.replaceAll("-", "_");
            for (int i = 0; i < part.length(); ++i) {
                if (Character.isJavaIdentifierPart(part.charAt(i))) continue;
                return null;
            }
            String cname = "_" + part;
            try {
                m = target.getClass().getMethod(cname, String[].class);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            try {
                mh = MethodHandles.publicLookup().unreflect(m);
            }
            catch (Exception e) {
                this.reporter.warning("Exception in replace: method=%s %s ", method, Exceptions.toString(e));
                return NULLVALUE;
            }
            try {
                Object result = Modifier.isStatic(m.getModifiers()) ? mh.invoke(args) : mh.invoke(target, args);
                return result == null ? NULLVALUE : result.toString();
            }
            catch (Error e) {
                throw e;
            }
            catch (WrongMethodTypeException e) {
                this.reporter.warning("Exception in replace: method=%s %s ", method, Exceptions.toString(e));
                return NULLVALUE;
            }
            catch (Exception e) {
                this.reporter.error("%s, for cmd: %s, arguments; %s", e.getMessage(), method, Arrays.toString(args));
                return NULLVALUE;
            }
            catch (Throwable e) {
                this.reporter.warning("Exception in replace: method=%s %s ", method, Exceptions.toString(e));
                return NULLVALUE;
            }
        }
        return null;
    }

    public String _uniq(String[] args) {
        Macro.verifyCommand(args, _uniqHelp, null, 1, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).distinct().collect(Strings.joining());
        return result;
    }

    public String _removeall(String[] args) {
        Macro.verifyCommand(args, _removeallHelp, null, 1, 3);
        if (args.length < 2) {
            return "";
        }
        List<String> result = Strings.splitQuoted(args[1]);
        if (args.length > 2) {
            result.removeAll(Strings.splitQuoted(args[2]));
        }
        return Strings.join(result);
    }

    public String _retainall(String[] args) {
        Macro.verifyCommand(args, _retainallHelp, null, 1, 3);
        if (args.length < 3) {
            return "";
        }
        List<String> result = Strings.splitQuoted(args[1]);
        result.retainAll(Strings.splitQuoted(args[2]));
        return Strings.join(result);
    }

    public String _pathseparator(String[] args) {
        return File.pathSeparator;
    }

    public String _separator(String[] args) {
        return File.separator;
    }

    public String _filter(String[] args) {
        return this.filter(args, false);
    }

    public String _select(String[] args) {
        return this.filter(args, false);
    }

    public String _filterout(String[] args) {
        return this.filter(args, true);
    }

    public String _reject(String[] args) {
        return this.filter(args, true);
    }

    String filter(String[] args, boolean include) {
        Macro.verifyCommand(args, String.format(_filterHelp, args[0]), null, 3, 3);
        Pattern pattern = Pattern.compile(args[2]);
        String result = Strings.splitQuotedAsStream(args[1]).filter(s -> pattern.matcher((CharSequence)s).matches() != include).collect(Strings.joining());
        return result;
    }

    public String _sort(String[] args) {
        Macro.verifyCommand(args, _sortHelp, null, 2, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).sorted().collect(Strings.joining());
        return result;
    }

    public String _nsort(String[] args) {
        Macro.verifyCommand(args, _nsortHelp, null, 2, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitAsStream).sorted((a, b) -> {
            while (a.startsWith("0")) {
                a = a.substring(1);
            }
            while (b.startsWith("0")) {
                b = b.substring(1);
            }
            if (a.length() == b.length()) {
                return a.compareTo((String)b);
            }
            return a.length() > b.length() ? 1 : -1;
        }).collect(Strings.joining());
        return result;
    }

    public String _join(String[] args) {
        Macro.verifyCommand(args, _joinHelp, null, 1, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitAsStream).collect(Strings.joining());
        return result;
    }

    public String _sjoin(String[] args) throws Exception {
        Macro.verifyCommand(args, _sjoinHelp, null, 2, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 2, args.length).flatMap(Strings::splitQuotedAsStream).collect(Collectors.joining(args[1]));
        return result;
    }

    public String _if(String[] args) throws Exception {
        Macro.verifyCommand(args, _ifHelp, null, 2, 4);
        String condition = args[1];
        if (this.isTruthy(condition)) {
            return args.length > 2 ? args[2] : "true";
        }
        if (args.length > 3) {
            return args[3];
        }
        return "";
    }

    public boolean isTruthy(String condition) throws Exception {
        if (condition == null) {
            return false;
        }
        if ((condition = condition.trim()).startsWith("(") && condition.endsWith(")")) {
            return this.doCondition(condition);
        }
        return !condition.equalsIgnoreCase("false") && !condition.equals("0") && !condition.equals("0.0") && condition.length() != 0;
    }

    public Object _now(String[] args) {
        Macro.verifyCommand(args, _nowHelp, null, 1, 2);
        Date now = new Date();
        if (args.length == 2) {
            if ("long".equals(args[1])) {
                return now.getTime();
            }
            SimpleDateFormat df = new SimpleDateFormat(args[1], Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("UTC"));
            return df.format(now);
        }
        return now;
    }

    public String _fmodified(String[] args) throws Exception {
        Macro.verifyCommand(args, _fmodifiedHelp, null, 2, Integer.MAX_VALUE);
        long time = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).map(File::new).filter(File::exists).mapToLong(File::lastModified).max().orElse(0L);
        return Long.toString(time);
    }

    public String _long2date(String[] args) {
        try {
            return new Date(Long.parseLong(args[1])).toString();
        }
        catch (Exception e) {
            return "not a valid long";
        }
    }

    public String _literal(String[] args) {
        if (args.length != 2) {
            throw new RuntimeException("Need a value for the ${literal;<value>} macro");
        }
        return "${" + args[1] + "}";
    }

    public String _def(String[] args) {
        Macro.verifyCommand(args, _defHelp, null, 2, 3);
        return this.domain.getProperty(args[1], args.length == 3 ? args[2] : "");
    }

    public String _list(String[] args) {
        Macro.verifyCommand(args, _listHelp, null, 1, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).map(this.domain::getProperty).flatMap(Strings::splitQuotedAsStream).map(element -> element.indexOf(59) < 0 ? element : SEMICOLON_P.matcher((CharSequence)element).replaceAll(ESCAPED_SEMICOLON)).collect(Strings.joining());
        return result;
    }

    public String _replace(String[] args) {
        return this.replace0(_replaceHelp, Strings::splitAsStream, args);
    }

    public String _replacelist(String[] args) {
        return this.replace0(_replacelistHelp, Strings::splitQuotedAsStream, args);
    }

    private String replace0(String help, Function<String, Stream<String>> splitter, String[] args) {
        Macro.verifyCommand(args, help, null, 3, 5);
        Pattern regex = Pattern.compile(args[2]);
        String replace = args.length > 3 ? args[3] : "";
        Collector<CharSequence, ?, String> joining = args.length > 4 ? Collectors.joining(args[4]) : Strings.joining();
        String result = splitter.apply(args[1]).map(element -> regex.matcher((CharSequence)element).replaceAll(replace)).collect(joining);
        return result;
    }

    public String _replacestring(String[] args) {
        Macro.verifyCommand(args, _replacestringHelp, null, 3, 4);
        Pattern regex = Pattern.compile(args[2]);
        String replace = args.length > 3 ? args[3] : "";
        String result = regex.matcher(args[1]).replaceAll(replace);
        return result;
    }

    public String _warning(String[] args) throws Exception {
        for (int i = 1; i < args.length; ++i) {
            Reporter.SetLocation warning = this.reporter.warning("%s", this.process(args[i]));
            Processor.FileLine header = this.domain.getHeader(Pattern.compile(".*"), Pattern.compile("\\$\\{warning;"));
            if (header == null) continue;
            header.set(warning);
        }
        return "";
    }

    public String _error(String[] args) throws Exception {
        for (int i = 1; i < args.length; ++i) {
            Reporter.SetLocation error = this.reporter.error("%s", this.process(args[i]));
            Processor.FileLine header = this.domain.getHeader(Pattern.compile(".*"), Pattern.compile("\\$\\{error;"));
            if (header == null) continue;
            header.set(error);
        }
        return "";
    }

    public String _toclassname(String[] args) {
        Macro.verifyCommand(args, _toclassnameHelp, null, 2, 2);
        String result = Strings.splitAsStream(args[1]).map(path -> {
            if (path.endsWith(".class")) {
                return path.substring(0, path.length() - 6).replace('/', '.');
            }
            if (path.endsWith(".java")) {
                return path.substring(0, path.length() - 5).replace('/', '.');
            }
            this.reporter.warning("in toclassname, %s is not a class path because it does not end in .class", path);
            return null;
        }).filter(Objects::nonNull).collect(Strings.joining());
        return result;
    }

    public String _toclasspath(String[] args) {
        Macro.verifyCommand(args, _toclasspathHelp, null, 2, 3);
        boolean cl = args.length > 2 ? Boolean.parseBoolean(args[2]) : true;
        Function<String, String> mapper = cl ? name -> name.replace('.', '/') + ".class" : name -> name.replace('.', '/');
        String result = Strings.splitAsStream(args[1]).map(mapper).collect(Strings.joining());
        return result;
    }

    public String _dir(String[] args) {
        if (args.length < 2) {
            this.reporter.warning("Need at least one file name for ${dir;...}", new Object[0]);
            return null;
        }
        String result = Arrays.stream(args, 1, args.length).map(this.domain::getFile).filter(File::exists).map(File::getParentFile).filter(File::exists).map(IO::absolutePath).collect(Strings.joining());
        return result;
    }

    public String _basename(String[] args) {
        if (args.length < 2) {
            this.reporter.warning("Need at least one file name for ${basename;...}", new Object[0]);
            return null;
        }
        String result = Arrays.stream(args, 1, args.length).map(this.domain::getFile).filter(f -> f.exists() && f.getParentFile().exists()).map(File::getName).collect(Strings.joining());
        return result;
    }

    public String _isfile(String[] args) {
        if (args.length < 2) {
            this.reporter.warning("Need at least one file name for ${isfile;...}", new Object[0]);
            return null;
        }
        boolean isfile = Arrays.stream(args, 1, args.length).map(File::new).map(File::getAbsoluteFile).allMatch(File::isFile);
        return Boolean.toString(isfile);
    }

    public String _isdir(String[] args) {
        boolean isdir = args.length < 2 ? false : Arrays.stream(args, 1, args.length).map(File::new).map(File::getAbsoluteFile).allMatch(File::isDirectory);
        return Boolean.toString(isdir);
    }

    public String _tstamp(String[] args) {
        long now;
        String format = args.length > 1 ? args[1] : "yyyyMMddHHmm";
        TimeZone tz = args.length > 2 ? TimeZone.getTimeZone(args[2]) : TimeZone.getTimeZone("UTC");
        if (args.length > 3) {
            now = Long.parseLong(args[3]);
        } else {
            String tstamp = this.domain.getProperty("_@tstamp");
            if (tstamp != null) {
                try {
                    now = Long.parseLong(tstamp);
                }
                catch (NumberFormatException e) {
                    now = System.currentTimeMillis();
                }
            } else {
                now = System.currentTimeMillis();
            }
        }
        if (args.length > 4) {
            this.reporter.warning("Too many arguments for tstamp: %s", Arrays.toString(args));
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format, Locale.US);
        sdf.setTimeZone(tz);
        return sdf.format(new Date(now));
    }

    public String _lsr(String[] args) {
        return this.ls(_lsrHelp, args, true);
    }

    public String _lsa(String[] args) {
        return this.ls(_lsaHelp, args, false);
    }

    private String ls(String help, String[] args, boolean relative) {
        Function<File, String> mapper;
        Macro.verifyCommand(args, help, null, 2, Integer.MAX_VALUE);
        File dir = this.domain.getFile(args[1]);
        if (!dir.isAbsolute()) {
            throw new IllegalArgumentException(String.format("the ${%s} macro directory parameter is not absolute: %s", args[0], dir));
        }
        if (!dir.exists()) {
            throw new IllegalArgumentException(String.format("the ${%s} macro directory parameter does not exist: %s", args[0], dir));
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(String.format("the ${%s} macro directory parameter points to a file instead of a directory: %s", args[0], dir));
        }
        Object[] array = dir.listFiles();
        if (array == null || array.length == 0) {
            return "";
        }
        Arrays.sort(array);
        Function<File, String> function = mapper = relative ? File::getName : IO::absolutePath;
        if (args.length < 3) {
            String result = Arrays.stream(array).map(mapper).collect(Strings.joining());
            return result;
        }
        LinkedList files = new LinkedList();
        Collections.addAll(files, array);
        ArrayList result = new ArrayList(array.length);
        Arrays.stream(args, 2, args.length).flatMap(Strings::splitQuotedAsStream).map(Instruction::new).forEachOrdered(ins -> {
            Iterator iter = files.iterator();
            while (iter.hasNext()) {
                File file = (File)iter.next();
                if (!ins.matches(file.getPath())) continue;
                iter.remove();
                if (ins.isNegated()) continue;
                result.add(mapper.apply(file));
            }
        });
        return Strings.join(result);
    }

    public String _currenttime(String[] args) {
        return Long.toString(System.currentTimeMillis());
    }

    public String _version(String[] args) {
        return this._versionmask(args);
    }

    public String _versionmask(String[] args) {
        Macro.verifyCommand(args, "${versionmask;<mask>;<version>}, modify a version\n<mask> ::= [ M [ M [ M [ MQ ]]]\nM ::= '+' | '-' | MQ\nMQ ::= '~' | '='", null, 2, 3);
        String mask = args[1];
        Version version = null;
        if (args.length >= 3) {
            if (this.isLocalTarget(args[2])) {
                return LITERALVALUE;
            }
            version = Version.parseVersion(args[2]);
        }
        return this.version(version, mask);
    }

    String version(Version version, String mask) {
        if (version == null) {
            String v = this.domain.getProperty("@");
            if (v == null) {
                return LITERALVALUE;
            }
            version = new Version(v);
        }
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (int i = 0; i < mask.length(); ++i) {
            char c = mask.charAt(i);
            String result = null;
            if (c == '~') continue;
            if (i == 3) {
                result = version.getQualifier();
                MavenVersion mv = new MavenVersion(version);
                if (c == 'S') {
                    if (mv.isSnapshot()) {
                        return sb.append("-SNAPSHOT").toString();
                    }
                } else if (c == 's') {
                    if (mv.isSnapshot()) {
                        return sb.append("-SNAPSHOT").toString();
                    }
                    return sb.toString();
                }
            } else if (Character.isDigit(c)) {
                result = String.valueOf(c);
            } else {
                int x = version.get(i);
                switch (c) {
                    case '+': {
                        ++x;
                        break;
                    }
                    case '-': {
                        --x;
                        break;
                    }
                }
                result = Integer.toString(x);
            }
            if (result == null) continue;
            sb.append(del);
            del = ".";
            sb.append(result);
        }
        return sb.toString();
    }

    public String _range(String[] args) {
        Macro.verifyCommand(args, _rangeHelp, _rangePattern, 2, 3);
        Version version = null;
        if (args.length >= 3) {
            String string = args[2];
            if (this.isLocalTarget(string)) {
                return LITERALVALUE;
            }
            version = new Version(string);
        } else {
            String v = this.domain.getProperty("@");
            if (v == null) {
                return LITERALVALUE;
            }
            version = new Version(v);
        }
        String spec = args[1];
        Matcher m = RANGE_MASK.matcher(spec);
        m.matches();
        String floor = m.group(1);
        String floorMask = m.group(2);
        String ceilingMask = m.group(3);
        String ceiling = m.group(4);
        String left = this.version(version, floorMask);
        String right = this.version(version, ceilingMask);
        StringBuilder sb = new StringBuilder();
        sb.append(floor);
        sb.append(left);
        sb.append(",");
        sb.append(right);
        sb.append(ceiling);
        String s = sb.toString();
        VersionRange vr = new VersionRange(s);
        if (!vr.includes(vr.getHigh()) && !vr.includes(vr.getLow())) {
            this.reporter.error("${range} macro created an invalid range %s from %s and mask %s", s, version, spec);
        }
        return sb.toString();
    }

    boolean isLocalTarget(String string) {
        return LOCALTARGET_P.matcher(string).matches();
    }

    public String system_internal(boolean allowFail, String[] args) throws Exception {
        if (this.nosystem) {
            throw new RuntimeException("Macros in this mode cannot excute system commands");
        }
        Macro.verifyCommand(args, "${" + (allowFail ? "system-allow-fail" : "system") + ";<command>[;<in>]}, execute a system command", null, 2, 3);
        String command = args[1];
        String input = null;
        if (args.length > 2) {
            input = args[2];
        }
        if (File.separatorChar == '\\') {
            command = "cmd /c \"" + command + "\"";
        }
        Process process = Runtime.getRuntime().exec(command, null, this.domain.getBase());
        if (input != null) {
            process.getOutputStream().write(input.getBytes(StandardCharsets.UTF_8));
        }
        process.getOutputStream().close();
        String s = IO.collect(process.getInputStream(), StandardCharsets.UTF_8);
        int exitValue = process.waitFor();
        if (exitValue != 0) {
            if (!allowFail) {
                this.reporter.error("System command %s failed with exit code %d", command, exitValue);
            } else {
                this.reporter.warning("System command %s failed with exit code %d (allowed)", command, exitValue);
            }
            return null;
        }
        return s.trim();
    }

    public String _system(String[] args) throws Exception {
        return this.system_internal(false, args);
    }

    public String _system_allow_fail(String[] args) throws Exception {
        String result = "";
        try {
            result = this.system_internal(true, args);
            return result == null ? "" : result;
        }
        catch (Throwable t) {
            return "";
        }
    }

    public String _env(String[] args) {
        Macro.verifyCommand(args, _envHelp, null, 2, 3);
        try {
            String ret = System.getenv(args[1]);
            if (ret != null) {
                return ret;
            }
            if (args.length > 2) {
                return args[2];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    public String _cat(String[] args) throws IOException {
        Macro.verifyCommand(args, _catHelp, null, 2, 2);
        File f = this.domain.getFile(args[1]);
        if (f.isFile()) {
            return IO.collect(f).replaceAll("\\\\", "\\\\\\\\");
        }
        if (f.isDirectory()) {
            return Arrays.toString(f.list());
        }
        try {
            URL url = new URL(args[1]);
            return IO.collect(url, StandardCharsets.UTF_8);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String _base64(String ... args) throws IOException {
        Macro.verifyCommand(args, _base64Help, null, 2, 3);
        File file = this.domain.getFile(args[1]);
        long maxLength = 100000L;
        if (args.length > 2) {
            maxLength = Long.parseLong(args[2]);
        }
        if (file.length() > maxLength) {
            throw new IllegalArgumentException("Maximum file size (" + maxLength + ") for base64 macro exceeded for file " + file);
        }
        return Base64.encodeBase64(file);
    }

    public String _digest(String ... args) throws NoSuchAlgorithmException, IOException {
        Macro.verifyCommand(args, _digestHelp, null, 3, 3);
        MessageDigest digester = MessageDigest.getInstance(args[1]);
        File f = this.domain.getFile(args[2]);
        IO.copy(f, digester);
        byte[] digest = digester.digest();
        return Hex.toHexString(digest);
    }

    public static void verifyCommand(String[] args, String help, Pattern[] patterns, int low, int high) {
        String message = "";
        if (args.length > high) {
            message = "too many arguments";
        } else if (args.length < low) {
            message = "too few arguments";
        } else {
            for (int i = 0; patterns != null && i < patterns.length && i < args.length; ++i) {
                Matcher m;
                if (patterns[i] == null || (m = patterns[i].matcher(args[i])).matches()) continue;
                message = message + String.format("Argument %s (%s) does not match %s%n", i, args[i], patterns[i].pattern());
            }
        }
        if (message.length() != 0) {
            StringBuilder sb = new StringBuilder();
            String del = "${";
            for (String arg : args) {
                sb.append(del);
                sb.append(arg);
                del = SEMICOLON;
            }
            sb.append("}, is not understood. ");
            sb.append(message);
            throw new IllegalArgumentException(sb.toString());
        }
    }

    public Properties getFlattenedProperties() {
        return this.getFlattenedProperties(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getFlattenedProperties(boolean ignoreInstructions) {
        this.flattening = true;
        try {
            UTF8Properties flattened = new UTF8Properties();
            Properties source = this.domain.getProperties();
            for (String key : Iterables.iterable(source.propertyNames(), String.class::cast)) {
                if (key.startsWith("_")) continue;
                String value = source.getProperty(key);
                if (value == null) {
                    Object raw = source.get(key);
                    this.reporter.warning("Key '%s' has a non-String value: %s:%s", key, raw == null ? "" : raw.getClass().getName(), raw);
                    continue;
                }
                if (ignoreInstructions && key.startsWith("-")) {
                    flattened.put(key, value);
                    continue;
                }
                flattened.put(key, this.process(value));
            }
            UTF8Properties uTF8Properties = flattened;
            return uTF8Properties;
        }
        finally {
            this.flattening = false;
        }
    }

    public String _osfile(String[] args) {
        Macro.verifyCommand(args, _osfileHelp, null, 3, 3);
        File base = new File(args[1]);
        File f = IO.getFile(base, args[2]);
        return IO.absolutePath(f);
    }

    public String _path(String[] args) {
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).collect(Collectors.joining(File.pathSeparator));
        return result;
    }

    public int _size(String[] args) {
        Macro.verifyCommand(args, _sizeHelp, null, 1, Integer.MAX_VALUE);
        long size = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).count();
        return (int)size;
    }

    public static Properties getParent(Properties p) {
        try {
            Field f = Properties.class.getDeclaredField("defaults");
            f.setAccessible(true);
            MethodHandle mh = MethodHandles.publicLookup().unreflectGetter(f);
            return mh.invoke(p);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            return null;
        }
    }

    public String process(String line) {
        return this.process(line, this.domain);
    }

    public boolean isNosystem() {
        return this.nosystem;
    }

    public boolean setNosystem(boolean nosystem) {
        boolean tmp = this.nosystem;
        this.nosystem = nosystem;
        return tmp;
    }

    public String _unescape(String[] args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            sb.append(args[i]);
        }
        block8: for (int j = 0; j < sb.length() - 1; ++j) {
            if (sb.charAt(j) != '\\') continue;
            switch (sb.charAt(j + 1)) {
                case 'n': {
                    sb.replace(j, j + 2, "\n");
                    continue block8;
                }
                case 'r': {
                    sb.replace(j, j + 2, "\r");
                    continue block8;
                }
                case 'b': {
                    sb.replace(j, j + 2, "\b");
                    continue block8;
                }
                case 'f': {
                    sb.replace(j, j + 2, "\f");
                    continue block8;
                }
                case 't': {
                    sb.replace(j, j + 2, "\t");
                    continue block8;
                }
            }
        }
        return sb.toString();
    }

    public String _startswith(String[] args) throws Exception {
        Macro.verifyCommand(args, _startswithHelp, null, 3, 3);
        if (args[1].startsWith(args[2])) {
            return args[1];
        }
        return "";
    }

    public String _endswith(String[] args) throws Exception {
        Macro.verifyCommand(args, _endswithHelp, null, 3, 3);
        if (args[1].endsWith(args[2])) {
            return args[1];
        }
        return "";
    }

    public String _extension(String[] args) throws Exception {
        Macro.verifyCommand(args, _extensionHelp, null, 2, 2);
        String name = args[1];
        int n = name.indexOf(46);
        if (n < 0) {
            return "";
        }
        return name.substring(n + 1);
    }

    public String _stem(String[] args) throws Exception {
        Macro.verifyCommand(args, _stemHelp, null, 2, 2);
        String name = args[1];
        int n = name.indexOf(46);
        if (n < 0) {
            return name;
        }
        return name.substring(0, n);
    }

    public String _substring(String[] args) throws Exception {
        Macro.verifyCommand(args, _substringHelp, null, 3, 4);
        String string = args[1];
        int start = Integer.parseInt(args[2].equals("") ? "0" : args[2]);
        int end = string.length();
        if (args.length > 3 && (end = Integer.parseInt(args[3])) < 0) {
            end = string.length() + end;
        }
        if (start < 0) {
            start = string.length() + start;
        }
        if (start > end) {
            int t = start;
            start = end;
            end = t;
        }
        return string.substring(start, end);
    }

    public long _rand(String[] args) throws Exception {
        Macro.verifyCommand(args, _randHelp, null, 2, 3);
        int min = 0;
        int max = 100;
        if (args.length > 1) {
            max = Integer.parseInt(args[1]);
            if (args.length > 2) {
                min = Integer.parseInt(args[2]);
            }
        }
        int diff = max - min;
        double d = random.nextDouble() * (double)diff + (double)min;
        return Math.round(d);
    }

    public int _length(String[] args) throws Exception {
        Macro.verifyCommand(args, _lengthHelp, null, 1, 2);
        if (args.length == 1) {
            return 0;
        }
        return args[1].length();
    }

    public String _get(String[] args) throws Exception {
        Macro.verifyCommand(args, _getHelp, null, 3, 3);
        int index = Integer.parseInt(args[1]);
        List<String> list = this.toList(args, 2, args.length);
        if (index < 0) {
            index = list.size() + index;
        }
        return list.get(index);
    }

    public String _sublist(String[] args) throws Exception {
        Macro.verifyCommand(args, _sublistHelp, null, 4, Integer.MAX_VALUE);
        int start = Integer.parseInt(args[1]);
        int end = Integer.parseInt(args[2]);
        List<String> list = this.toList(args, 3, args.length);
        if (start < 0) {
            start = list.size() + start + 1;
        }
        if (end < 0) {
            end = list.size() + end + 1;
        }
        if (start > end) {
            int t = start;
            start = end;
            end = t;
        }
        return Strings.join(list.subList(start, end));
    }

    private List<String> toList(String[] args, int startInclusive, int endExclusive) {
        List<String> list = Arrays.stream(args, startInclusive, endExclusive).flatMap(Strings::splitQuotedAsStream).collect(Collectors.toList());
        return list;
    }

    public String _first(String[] args) throws Exception {
        Macro.verifyCommand(args, _firstHelp, null, 1, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).findFirst().orElse("");
        return result;
    }

    public String _last(String[] args) throws Exception {
        Macro.verifyCommand(args, _lastHelp, null, 1, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).reduce((first, second) -> second).orElse("");
        return result;
    }

    public String _max(String[] args) throws Exception {
        Macro.verifyCommand(args, _maxHelp, null, 2, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).max(String::compareTo).orElse("");
        return result;
    }

    public String _min(String[] args) throws Exception {
        Macro.verifyCommand(args, _minHelp, null, 2, Integer.MAX_VALUE);
        String result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).min(String::compareTo).orElse("");
        return result;
    }

    public String _nmax(String[] args) throws Exception {
        Macro.verifyCommand(args, _nmaxHelp, null, 2, Integer.MAX_VALUE);
        double result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitAsStream).mapToDouble(Double::parseDouble).max().orElse(Double.NaN);
        return this.toString(result);
    }

    public String _nmin(String[] args) throws Exception {
        Macro.verifyCommand(args, _nminHelp, null, 2, Integer.MAX_VALUE);
        double result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitAsStream).mapToDouble(Double::parseDouble).min().orElse(Double.NaN);
        return this.toString(result);
    }

    public String _sum(String[] args) throws Exception {
        Macro.verifyCommand(args, _sumHelp, null, 2, Integer.MAX_VALUE);
        double result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitAsStream).mapToDouble(Double::parseDouble).sum();
        return this.toString(result);
    }

    public String _average(String[] args) throws Exception {
        Macro.verifyCommand(args, _sumHelp, null, 2, Integer.MAX_VALUE);
        double result = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).mapToDouble(Double::parseDouble).average().orElseThrow(() -> new IllegalArgumentException("No members in list to calculate average"));
        return this.toString(result);
    }

    public String _reverse(String[] args) throws Exception {
        Macro.verifyCommand(args, _reverseHelp, null, 2, Integer.MAX_VALUE);
        Deque reversed = Arrays.stream(args, 1, args.length).flatMap(Strings::splitQuotedAsStream).collect(Collector.of(ArrayDeque::new, (deq, t) -> deq.addFirst(t), (d1, d2) -> {
            d2.addAll(d1);
            return d2;
        }, new Collector.Characteristics[0]));
        return Strings.join(reversed);
    }

    public int _indexof(String[] args) throws Exception {
        Macro.verifyCommand(args, _indexofHelp, null, 3, Integer.MAX_VALUE);
        String value = args[1];
        List<String> list = this.toList(args, 2, args.length);
        return list.indexOf(value);
    }

    public int _lastindexof(String[] args) throws Exception {
        Macro.verifyCommand(args, _lastindexofHelp, null, 3, Integer.MAX_VALUE);
        String value = args[1];
        List<String> list = this.toList(args, 2, args.length);
        return list.lastIndexOf(value);
    }

    public int _find(String[] args) throws Exception {
        Macro.verifyCommand(args, _findHelp, null, 3, 3);
        return args[1].indexOf(args[2]);
    }

    public int _findlast(String[] args) throws Exception {
        Macro.verifyCommand(args, _findlastHelp, null, 3, 3);
        return args[2].lastIndexOf(args[1]);
    }

    public String _split(String[] args) throws Exception {
        Macro.verifyCommand(args, _splitHelp, null, 2, Integer.MAX_VALUE);
        Pattern regex = Pattern.compile(args[1]);
        String result = Arrays.stream(args, 2, args.length).flatMap(regex::splitAsStream).filter(element -> !element.isEmpty()).collect(Strings.joining());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object _js(String[] args) throws Exception {
        Macro.verifyCommand(args, _jsHelp, null, 2, Integer.MAX_VALUE);
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            sb.append(args[i]).append(';');
        }
        if (this.context == null) {
            Macro i = this;
            synchronized (i) {
                if (this.engine == null) {
                    this.engine = new ScriptEngineManager().getEngineByName("javascript");
                }
            }
            this.context = this.engine.getContext();
            this.bindings = this.context.getBindings(100);
            this.bindings.put("domain", (Object)this.domain);
            String javascript = this.domain.mergeProperties("javascript", SEMICOLON);
            if (javascript != null && javascript.length() > 0) {
                this.engine.eval(javascript, this.context);
            }
            this.context.setErrorWriter(this.stderr);
            this.context.setWriter(this.stdout);
        }
        Object eval = this.engine.eval(sb.toString(), this.context);
        StringBuffer buffer = this.stdout.getBuffer();
        if (buffer.length() > 0) {
            this.reporter.error("Executing js: %s: %s", sb, buffer);
            buffer.setLength(0);
        }
        if (eval != null) {
            return this.toString(eval);
        }
        String out = this.stdout.toString();
        this.stdout.getBuffer().setLength(0);
        return out;
    }

    private String toString(Object eval) {
        if (eval == null) {
            return "null";
        }
        if (eval instanceof Double || eval instanceof Float) {
            String v = eval.toString();
            return v.endsWith(".0") ? v.substring(0, v.length() - 2) : v;
        }
        return eval.toString();
    }

    private String toString(double eval) {
        String v = Double.toString(eval);
        return v.endsWith(".0") ? v.substring(0, v.length() - 2) : v;
    }

    public String _toupper(String[] args) throws Exception {
        Macro.verifyCommand(args, _tolowerHelp, null, 2, 2);
        return args[1].toUpperCase();
    }

    public String _tolower(String[] args) throws Exception {
        Macro.verifyCommand(args, _tolowerHelp, null, 2, 2);
        return args[1].toLowerCase();
    }

    public int _compare(String[] args) throws Exception {
        Macro.verifyCommand(args, _compareHelp, null, 3, 3);
        int n = args[1].compareTo(args[2]);
        return Integer.signum(n);
    }

    public int _ncompare(String[] args) throws Exception {
        Macro.verifyCommand(args, _ncompareHelp, null, 3, 3);
        double a = Double.parseDouble(args[1]);
        double b = Double.parseDouble(args[2]);
        return Integer.signum(Double.compare(a, b));
    }

    public boolean _matches(String[] args) throws Exception {
        Macro.verifyCommand(args, _matchesHelp, null, 3, 3);
        return args[1].matches(args[2]);
    }

    public StringBuffer _subst(String[] args) throws Exception {
        Macro.verifyCommand(args, _substHelp, null, 3, 5);
        Pattern p = Pattern.compile(args[2]);
        Matcher matcher = p.matcher(args[1]);
        String replace = args.length > 3 ? args[3] : "";
        int count = args.length > 4 ? Integer.parseInt(args[4]) : Integer.MAX_VALUE;
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < count && matcher.find(); ++i) {
            matcher.appendReplacement(sb, replace);
        }
        matcher.appendTail(sb);
        return sb;
    }

    public String _trim(String[] args) throws Exception {
        Macro.verifyCommand(args, _trimHelp, null, 2, 2);
        return args[1].trim();
    }

    public String _format(String[] args) throws Exception {
        Macro.verifyCommand(args, _formatHelp, null, 2, Integer.MAX_VALUE);
        Object[] args2 = new Object[args.length + 10];
        Matcher m = PRINTF_P.matcher(args[1]);
        int n = 2;
        while (n < args.length && m.find()) {
            char conversion = m.group(5).charAt(0);
            switch (conversion) {
                case 'X': 
                case 'Z': 
                case 'd': 
                case 'o': 
                case 'u': 
                case 'x': 
                case 'z': {
                    args2[n - 2] = Long.parseLong(args[n]);
                    ++n;
                    break;
                }
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    args2[n - 2] = Double.parseDouble(args[n]);
                    ++n;
                    break;
                }
                case 'c': {
                    if (args[n].length() != 1) {
                        throw new IllegalArgumentException("Character expected but found '" + args[n] + "'");
                    }
                    args2[n - 2] = Character.valueOf(args[n].charAt(0));
                    ++n;
                    break;
                }
                case 'b': {
                    String v = args[n].toLowerCase();
                    args2[n - 2] = v == null || v.equals("false") || v.isEmpty() || NUMERIC_P.matcher(v).matches() && Double.parseDouble(v) == 0.0 ? Boolean.valueOf(false) : Boolean.valueOf(false);
                    ++n;
                    break;
                }
                case 'H': 
                case 'h': 
                case 'p': 
                case 's': {
                    args2[n - 2] = args[n];
                    ++n;
                    break;
                }
                case 'T': 
                case 't': {
                    SimpleDateFormat df;
                    String dt = args[n];
                    if (NUMERIC_P.matcher(dt).matches()) {
                        args2[n - 2] = Long.parseLong(dt);
                        break;
                    }
                    switch (args[n].length()) {
                        case 6: {
                            df = new SimpleDateFormat("yyMMdd", Locale.US);
                            break;
                        }
                        case 8: {
                            df = new SimpleDateFormat("yyyyMMdd", Locale.US);
                            break;
                        }
                        case 12: {
                            df = new SimpleDateFormat("yyyyMMddHHmm", Locale.US);
                            break;
                        }
                        case 14: {
                            df = new SimpleDateFormat("yyyyMMddHHmmss", Locale.US);
                            break;
                        }
                        case 19: {
                            df = new SimpleDateFormat("yyyyMMddHHmmss.SSSZ", Locale.US);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown dateformat " + args[n]);
                        }
                    }
                    df.setTimeZone(TimeZone.getTimeZone("UTC"));
                    args2[n - 2] = df.parse(args[n]);
                    break;
                }
            }
        }
        try (Formatter f = new Formatter();){
            f.format(args[1], args2);
            String string = f.toString();
            return string;
        }
    }

    public boolean _isempty(String[] args) throws Exception {
        Macro.verifyCommand(args, _isemptyHelp, null, 1, Integer.MAX_VALUE);
        boolean result = Arrays.stream(args, 1, args.length).noneMatch(s -> !s.trim().isEmpty());
        return result;
    }

    public boolean _isnumber(String[] args) throws Exception {
        Macro.verifyCommand(args, _isnumberHelp, null, 2, Integer.MAX_VALUE);
        boolean result = Arrays.stream(args, 1, args.length).allMatch(s -> NUMERIC_P.matcher((CharSequence)s).matches());
        return result;
    }

    public boolean _is(String[] args) throws Exception {
        Macro.verifyCommand(args, _isHelp, null, 3, Integer.MAX_VALUE);
        String a = args[1];
        boolean result = Arrays.stream(args, 2, args.length).allMatch(a::equals);
        return result;
    }

    public String _map(String[] args) throws Exception {
        Macro.verifyCommand(args, _mapHelp, null, 2, Integer.MAX_VALUE);
        String macro = args[1];
        String result = Arrays.stream(args, 2, args.length).flatMap(Strings::splitQuotedAsStream).map(s -> this.process("${" + macro + SEMICOLON + s + "}")).collect(Strings.joining());
        return result;
    }

    public String _foreach(String[] args) throws Exception {
        Macro.verifyCommand(args, _foreachHelp, null, 2, Integer.MAX_VALUE);
        String macro = args[1];
        List<String> list = this.toList(args, 2, args.length);
        String result = IntStream.range(0, list.size()).mapToObj(n -> this.process("${" + macro + SEMICOLON + (String)list.get(n) + SEMICOLON + n + "}")).collect(Strings.joining());
        return result;
    }

    public String _apply(String[] args) throws Exception {
        Macro.verifyCommand(args, _applyHelp, null, 2, Integer.MAX_VALUE);
        String macro = args[1];
        String result = Arrays.stream(args, 2, args.length).flatMap(Strings::splitQuotedAsStream).collect(Collectors.joining(SEMICOLON, "${" + macro + SEMICOLON, "}"));
        return this.process(result);
    }

    public String _bytes(String[] args) {
        try (Formatter sb = new Formatter();){
            for (int i = 0; i < args.length; ++i) {
                long l = Long.parseLong(args[1]);
                this.bytes(sb, l, 0, new String[]{"b", "Kb", "Mb", "Gb", "Tb", "Pb", "Eb", "Zb", "Yb", "Bb", "Geopbyte"});
            }
            String string = sb.toString();
            return string;
        }
    }

    private void bytes(Formatter sb, double l, int i, String[] strings) {
        if (l > 1024.0 && i < strings.length - 1) {
            this.bytes(sb, l / 1024.0, i + 1, strings);
            return;
        }
        l = Math.round(l * 10.0) / 10L;
        sb.format("%s %s", l, strings[i]);
    }

    public String _glob(String[] args) {
        Macro.verifyCommand(args, _globHelp, null, 2, 2);
        String glob = args[1];
        boolean negate = false;
        if (glob.startsWith("!")) {
            glob = glob.substring(1);
            negate = true;
        }
        Pattern pattern = Glob.toPattern(glob);
        if (negate) {
            return "(?!" + pattern.pattern() + ")";
        }
        return pattern.pattern();
    }

    public boolean doCondition(String arg) throws Exception {
        ExtendedFilter f = new ExtendedFilter(arg);
        return f.match(new Get(){

            @Override
            public Object get(String key) throws Exception {
                if (key.endsWith("[]")) {
                    key = key.substring(0, key.length() - 2);
                    return Strings.split(Macro.this.domain.getProperty(key));
                }
                return Macro.this.domain.getProperty(key);
            }
        });
    }

    public Map<String, String> getCommands() {
        LinkedHashSet<Object> targets = new LinkedHashSet<Object>();
        targets.addAll(Arrays.asList(targets));
        for (Processor rover = this.domain; rover != null; rover = rover.getParent()) {
            targets.add(rover);
        }
        targets.add(this);
        return targets.stream().map(Object::getClass).map(Class::getMethods).flatMap(Arrays::stream).filter(m -> !Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers()) && m.getName().startsWith("_")).collect(Collectors.toMap(m -> m.getName().substring(1), m -> {
            try {
                Field f = m.getDeclaringClass().getDeclaredField(m.getName() + "Help");
                f.setAccessible(true);
                MethodHandle mh = MethodHandles.publicLookup().unreflectGetter(f);
                return mh.invoke();
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                return "";
            }
        }, (u, v) -> u, TreeMap::new));
    }

    static class Link {
        final Link previous;
        final String key;
        final Processor start;

        public Link(Processor start, Link previous, String key) {
            this.start = Objects.requireNonNull(start);
            this.previous = previous;
            this.key = key;
        }

        public boolean contains(String key) {
            if (this.key.equals(key)) {
                return true;
            }
            if (this.previous == null) {
                return false;
            }
            return this.previous.contains(key);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            String del = "[";
            Link r = this;
            while (r != null) {
                sb.append(del);
                sb.append(r.key);
                del = ",";
                r = r.previous;
            }
            sb.append("]");
            return sb.toString();
        }
    }
}

