/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.qtokens;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class QuotedTokenizer
implements Iterable<String> {
    private final String string;
    private final String separators;
    private final boolean returnTokens;
    private final boolean retainQuotes;
    private int index = 0;
    private String peek;
    private char separator;

    public QuotedTokenizer(String string, String separators, boolean returnTokens, boolean retainQuotes) {
        this.string = Objects.requireNonNull(string, "string argument must be not null");
        this.separators = Objects.requireNonNull(separators, "separators argument must be not null");
        this.returnTokens = returnTokens;
        this.retainQuotes = retainQuotes;
    }

    public QuotedTokenizer(String string, String separators, boolean returnTokens) {
        this(string, separators, returnTokens, false);
    }

    public QuotedTokenizer(String string, String separators) {
        this(string, separators, false);
    }

    private QuotedTokenizer copy() {
        return new QuotedTokenizer(this.string, this.separators, this.returnTokens, this.retainQuotes);
    }

    public String toString() {
        return String.format("\"%s\" - \"%s\" - %s", this.string, this.separators, this.returnTokens);
    }

    public String nextToken(String separators) {
        this.separator = '\u0000';
        if (this.peek != null) {
            String tmp = this.peek;
            this.peek = null;
            return tmp;
        }
        if (this.index == this.string.length()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean hadstring = false;
        boolean validspace = false;
        block3: while (this.index < this.string.length()) {
            char c;
            if (separators.indexOf(c = this.string.charAt(this.index++)) >= 0) {
                if (this.returnTokens) {
                    this.peek = Character.toString(c);
                    break;
                }
                this.separator = c;
                break;
            }
            if (Character.isWhitespace(c)) {
                if (this.index == this.string.length()) break;
                if (!validspace) continue;
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\"': 
                case '\'': {
                    hadstring = true;
                    this.quotedString(sb, c);
                    validspace = false;
                    continue block3;
                }
            }
            sb.append(c);
            validspace = true;
        }
        String result = sb.toString();
        if (!hadstring) {
            result = result.trim();
        }
        if (!hadstring && result.isEmpty() && this.index == this.string.length()) {
            return null;
        }
        return result;
    }

    public String nextToken() {
        return this.nextToken(this.separators);
    }

    private void quotedString(StringBuilder sb, char quote) {
        boolean retain;
        boolean bl = retain = this.retainQuotes || sb.length() != 0;
        if (retain) {
            sb.append(quote);
        }
        while (this.index < this.string.length()) {
            char c;
            if ((c = this.string.charAt(this.index++)) == quote) {
                if (!retain) break;
                sb.append(quote);
                break;
            }
            if (c == '\\' && this.index < this.string.length()) {
                c = this.string.charAt(this.index++);
                if (retain || c != quote) {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
    }

    public String[] getTokens() {
        return (String[])QuotedTokenizer.stream(this).toArray(String[]::new);
    }

    public char getSeparator() {
        return this.separator;
    }

    public List<String> getTokenSet() {
        return QuotedTokenizer.stream(this).collect(Collectors.toList());
    }

    public Stream<String> stream() {
        return QuotedTokenizer.stream(this.copy());
    }

    private static Stream<String> stream(QuotedTokenizer qt) {
        return StreamSupport.stream(QuotedTokenizer.spliterator(qt), false);
    }

    @Override
    public Spliterator<String> spliterator() {
        return QuotedTokenizer.spliterator(this.copy());
    }

    private static Spliterator<String> spliterator(final QuotedTokenizer qt) {
        return new Spliterators.AbstractSpliterator<String>(Long.MAX_VALUE, 272){

            @Override
            public boolean tryAdvance(Consumer<? super String> action) {
                Objects.requireNonNull(action);
                String next = qt.nextToken();
                if (next != null) {
                    action.accept(next);
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    public Iterator<String> iterator() {
        return QuotedTokenizer.iterator(this.copy());
    }

    private static Iterator<String> iterator(final QuotedTokenizer qt) {
        return new Iterator<String>(){
            private boolean hasNext = false;
            private String next;

            @Override
            public boolean hasNext() {
                if (this.hasNext) {
                    return true;
                }
                this.next = qt.nextToken();
                this.hasNext = this.next != null;
                return this.hasNext;
            }

            @Override
            public String next() {
                if (this.hasNext()) {
                    this.hasNext = false;
                    return this.next;
                }
                throw new NoSuchElementException();
            }
        };
    }
}

