/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.generator.internal.artifact;

import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import com.liferay.whip.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArtifactURLUtil {
    private static final Pattern _pattern = Pattern.compile("(.*?)(-\\d+\\.\\d+\\.\\d+\\.\\d+)?");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL transform(URL artifact) throws IOException {
        int y;
        int x;
        String path = artifact.getPath();
        String symbolicName = path.substring((x = path.lastIndexOf(47)) + 1, y = path.lastIndexOf(".war"));
        Matcher matcher = _pattern.matcher(symbolicName);
        if (matcher.matches()) {
            symbolicName = matcher.group(1);
        }
        String contextName = null;
        try (Jar jar = new Jar("WAR", artifact.openStream());){
            if (jar.getBsn() != null) {
                URL uRL = artifact;
                return uRL;
            }
            contextName = ArtifactURLUtil._readServletContextName(jar);
        }
        catch (Exception exception) {
            ReflectionUtil.throwException(exception);
        }
        if (contextName == null) {
            contextName = symbolicName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(artifact.getPath());
        sb.append("?");
        sb.append("Bundle-SymbolicName");
        sb.append("=");
        sb.append(symbolicName);
        sb.append("&Web-ContextPath=/");
        sb.append(contextName);
        sb.append("&protocol=file");
        return new URL("webbundle", null, sb.toString());
    }

    private static String _readServletContextName(Jar jar) throws Exception {
        Resource resource = jar.getResource("WEB-INF/liferay-plugin-package.properties");
        if (resource == null) {
            return null;
        }
        Properties properties = new Properties();
        try (InputStream inputStream = resource.openInputStream();){
            properties.load(inputStream);
        }
        return properties.getProperty("servlet-context-name");
    }
}

