/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;

public class NestMembersAttribute
implements Attribute {
    public static final String NAME = "NestMembers";
    public final String[] classes;

    NestMembersAttribute(String[] classes) {
        this.classes = classes;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String toString() {
        return "NestMembers " + Arrays.toString(this.classes);
    }

    static NestMembersAttribute parseNestMembersAttribute(DataInput in, ConstantPool constant_pool) throws IOException {
        int number_of_classes = in.readUnsignedShort();
        String[] classes = new String[number_of_classes];
        for (int i = 0; i < number_of_classes; ++i) {
            int member_class_index = in.readUnsignedShort();
            classes[i] = constant_pool.className(member_class_index);
        }
        return new NestMembersAttribute(classes);
    }
}

