/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.AnnotationInfo;
import aQute.bnd.classfile.ConstantPool;
import aQute.bnd.classfile.ElementValueInfo;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;

public class TypeAnnotationInfo
extends AnnotationInfo {
    public static final int TYPEUSE_INDEX_NONE = -1;
    public static final int TYPEUSE_TARGET_INDEX_EXTENDS = 65535;
    public final int target_type;
    public final byte[] target_info;
    public final int target_index;
    public final byte[] type_path;

    TypeAnnotationInfo(int target_type, byte[] target_info, int target_index, byte[] type_path, String type, ElementValueInfo[] values) {
        super(type, values);
        this.target_type = target_type;
        this.target_info = target_info;
        this.target_index = target_index;
        this.type_path = type_path;
    }

    @Override
    public String toString() {
        return this.type + " " + Arrays.toString(this.values);
    }

    static TypeAnnotationInfo parseTypeAnnotationInfo(DataInput in, ConstantPool constant_pool) throws IOException {
        int target_index;
        byte[] target_info;
        int target_type = in.readUnsignedByte();
        switch (target_type) {
            case 0: 
            case 1: {
                target_info = new byte[1];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[0]);
                break;
            }
            case 16: {
                target_info = new byte[2];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[0]) << 8 | Byte.toUnsignedInt(target_info[1]);
                break;
            }
            case 17: 
            case 18: {
                target_info = new byte[2];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[0]);
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                target_info = new byte[]{};
                target_index = -1;
                break;
            }
            case 22: {
                target_info = new byte[1];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[0]);
                break;
            }
            case 23: {
                target_info = new byte[2];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[0]) << 8 | Byte.toUnsignedInt(target_info[1]);
                break;
            }
            case 64: 
            case 65: {
                int table_length = in.readUnsignedShort();
                target_info = new byte[table_length * 6];
                in.readFully(target_info);
                target_index = -1;
                break;
            }
            case 66: {
                target_info = new byte[2];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[0]) << 8 | Byte.toUnsignedInt(target_info[1]);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                target_info = new byte[2];
                in.readFully(target_info);
                target_index = -1;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                target_info = new byte[3];
                in.readFully(target_info);
                target_index = Byte.toUnsignedInt(target_info[2]);
                break;
            }
            default: {
                throw new IOException("Unknown target_type: " + target_type);
            }
        }
        int path_length = in.readUnsignedByte();
        byte[] type_path = new byte[path_length * 2];
        in.readFully(type_path);
        return TypeAnnotationInfo.parseAnnotationInfo(in, constant_pool, (type, values) -> new TypeAnnotationInfo(target_type, target_info, target_index, type_path, (String)type, (ElementValueInfo[])values));
    }
}

