/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.component;

import aQute.bnd.component.DSAnnotationReader;
import aQute.bnd.component.PropertiesDef;
import aQute.bnd.component.PropertyDef;
import aQute.bnd.component.ReferenceDef;
import aQute.bnd.component.annotations.ConfigurationPolicy;
import aQute.bnd.component.annotations.ServiceScope;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.version.Version;
import aQute.bnd.xmlattribute.ExtensionDef;
import aQute.bnd.xmlattribute.Namespaces;
import aQute.bnd.xmlattribute.XMLAttributeFinder;
import aQute.lib.tag.Tag;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ComponentDef
extends ExtensionDef {
    static final String NAMESPACE_STEM = "http://www.osgi.org/xmlns/scr";
    final SortedMap<String, PropertyDef> propertyDefs;
    static final String PROPERTYDEF_CONSTRUCTORFORMAT = "1-<init>-%04d";
    static final String PROPERTYDEF_FIELDFORMAT = "2-field-%s";
    static final String PROPERTYDEF_ACTIVATEFORMAT = "3-activate-%04d";
    static final String PROPERTYDEF_MODIFIEDFORMAT = "4-modified-%04d";
    static final String PROPERTYDEF_DEACTIVATEFORMAT = "5-deactivate-%04d";
    static final String PROPERTYDEF_ANNOTATIONFORMAT = "6-annotation-%04d";
    static final String PROPERTYDEF_COMPONENT = "7-component";
    final PropertyDef property;
    final PropertiesDef properties;
    final PropertyDef factoryProperty;
    final PropertiesDef factoryProperties;
    final Map<String, ReferenceDef> references = new LinkedHashMap<String, ReferenceDef>();
    Version version;
    String name;
    String factory;
    Boolean immediate;
    ServiceScope scope;
    ConfigurationPolicy configurationPolicy;
    Descriptors.TypeRef implementation;
    Descriptors.TypeRef[] service;
    String activate;
    List<String> activation_fields = new ArrayList<String>();
    String deactivate;
    String modified;
    Boolean enabled;
    String xmlns;
    String[] configurationPid;
    Integer init;
    private final Analyzer analyzer;

    public ComponentDef(Analyzer analyzer, XMLAttributeFinder finder, Version minVersion) {
        super(finder);
        this.analyzer = analyzer;
        this.version = minVersion;
        this.propertyDefs = new TreeMap<String, PropertyDef>();
        this.property = new PropertyDef(analyzer);
        this.propertyDefs.put(PROPERTYDEF_COMPONENT, this.property);
        this.factoryProperty = new PropertyDef(analyzer);
        this.properties = new PropertiesDef(analyzer);
        this.factoryProperties = new PropertiesDef(analyzer);
    }

    String effectiveName() {
        if (this.name != null) {
            return this.name;
        }
        if (this.implementation != null) {
            return this.implementation.getFQN();
        }
        return "<name not yet determined>";
    }

    void prepare(Analyzer analyzer) throws Exception {
        this.prepareVersion(analyzer);
        if (this.implementation == null) {
            analyzer.error("No Implementation defined for component %s", this.name);
            return;
        }
        analyzer.nonClassReferTo(this.implementation);
        if (this.name == null) {
            this.name = this.implementation.getFQN();
        }
        if (this.service != null && this.service.length > 0) {
            for (Descriptors.TypeRef interfaceName : this.service) {
                analyzer.nonClassReferTo(interfaceName);
            }
        } else if (this.scope != null && this.scope != ServiceScope.BUNDLE) {
            analyzer.warning("The servicefactory:=true directive is set but no service is provided, ignoring it", new Object[0]);
        }
        if (!(this.factory != null || this.factoryProperty.isEmpty() && this.factoryProperties.isEmpty())) {
            analyzer.error("The factoryProperty and/or factoryProperies elements are used on a non-factory component", new Object[0]);
        }
        this.properties.stream().filter(p -> !analyzer.getJar().exists((String)p)).forEach(p -> analyzer.warning("The properties entry \"%s\" is not found in the jar", p));
        this.factoryProperties.stream().filter(p -> !analyzer.getJar().exists((String)p)).forEach(p -> analyzer.warning("The factoryProperties entry \"%s\" is not found in the jar", p));
    }

    private void prepareVersion(Analyzer analyzer) throws Exception {
        for (ReferenceDef ref : this.references.values()) {
            ref.prepare(analyzer);
            this.updateVersion(ref.version);
        }
        if (this.configurationPolicy != null) {
            this.updateVersion(DSAnnotationReader.V1_1);
        }
        if (this.configurationPid != null) {
            this.updateVersion(DSAnnotationReader.V1_2);
        }
        if (this.modified != null) {
            this.updateVersion(DSAnnotationReader.V1_1);
        }
        if (!this.factoryProperty.isEmpty() || !this.factoryProperties.isEmpty()) {
            this.updateVersion(DSAnnotationReader.V1_4);
        }
    }

    void sortReferences() {
        TreeMap<String, ReferenceDef> temp = new TreeMap<String, ReferenceDef>(this.references);
        this.references.clear();
        this.references.putAll(temp);
    }

    Tag getTag() {
        String xmlns = this.xmlns;
        if (xmlns == null && !this.version.equals(DSAnnotationReader.V1_0)) {
            xmlns = "http://www.osgi.org/xmlns/scr/v" + this.version;
        }
        Tag component = new Tag(xmlns == null ? "component" : "scr:component", new Object[0]);
        Namespaces namespaces = null;
        if (xmlns != null) {
            namespaces = new Namespaces();
            namespaces.registerNamespace("scr", xmlns);
            this.addNamespaces(namespaces, xmlns);
            for (ReferenceDef ref : this.references.values()) {
                ref.addNamespaces(namespaces, xmlns);
            }
            namespaces.addNamespaces(component);
        }
        component.addAttribute("name", this.name).addAttribute("configuration-policy", (Object)this.configurationPolicy).addAttribute("enabled", this.enabled).addAttribute("immediate", this.immediate).addAttribute("factory", this.factory);
        if (!this.version.equals(DSAnnotationReader.V1_0)) {
            component.addAttribute("activate", this.activate).addAttribute("deactivate", this.deactivate);
        }
        component.addAttribute("modified", this.modified);
        if (this.configurationPid != null) {
            component.addAttribute("configuration-pid", Stream.of(this.configurationPid).map(this::map$).collect(Collectors.joining(" ")));
        }
        if (!this.activation_fields.isEmpty()) {
            component.addAttribute("activation-fields", this.activation_fields.stream().collect(Collectors.joining(" ")));
        }
        component.addAttribute("init", this.init);
        this.addAttributes(component, namespaces);
        PropertyDef mergedProperty = new PropertyDef(this.analyzer).addAll(this.propertyDefs.values());
        mergedProperty.propertyTags("property").forEachOrdered(component::addContent);
        this.properties.propertiesTags("properties").forEachOrdered(component::addContent);
        this.factoryProperty.propertyTags("factory-property").forEachOrdered(component::addContent);
        this.factoryProperties.propertiesTags("factory-properties").forEachOrdered(component::addContent);
        if (this.service != null && this.service.length != 0) {
            Tag s = new Tag(component, "service", new Object[0]);
            if (this.scope != null) {
                if (DSAnnotationReader.V1_3.compareTo(this.version) > 0) {
                    if (this.scope == ServiceScope.PROTOTYPE) {
                        throw new IllegalStateException("verification failed, pre 1.3 component with scope PROTOTYPE");
                    }
                    s.addAttribute("servicefactory", this.scope == ServiceScope.BUNDLE);
                } else {
                    s.addAttribute("scope", (Object)this.scope);
                }
            }
            for (Descriptors.TypeRef ss : this.service) {
                Tag provide = new Tag(s, "provide", new Object[0]);
                provide.addAttribute("interface", ss.getFQN());
            }
        }
        for (ReferenceDef ref : this.references.values()) {
            Tag refTag = ref.getTag(namespaces);
            component.addContent(refTag);
        }
        Tag impl = new Tag(component, "implementation", new Object[0]);
        impl.addAttribute("class", this.implementation.getFQN());
        return component;
    }

    private String map$(String v) {
        return "$".equals(v) ? this.name : v;
    }

    void updateVersion(Version version) {
        this.version = ComponentDef.max(this.version, version);
    }

    static <T extends Comparable<T>> T max(T a, T b) {
        int n = a.compareTo(b);
        if (n >= 0) {
            return a;
        }
        return b;
    }
}

