/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

class CapReq {
    private final MODE mode;
    private final String namespace;
    private final Resource resource;
    private final Map<String, String> directives;
    private final Map<String, Object> attributes;
    private transient int hashCode = 0;

    CapReq(MODE mode, String namespace, Resource resource, Map<String, String> directives, Map<String, Object> attributes) {
        this.mode = Objects.requireNonNull(mode);
        this.namespace = Objects.requireNonNull(namespace);
        this.resource = resource;
        this.directives = Collections.unmodifiableMap(new HashMap<String, String>(directives));
        this.attributes = Collections.unmodifiableMap(new HashMap<String, Object>(attributes));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, String> getDirectives() {
        return this.directives;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int hashCode() {
        if (this.hashCode != 0) {
            return this.hashCode;
        }
        this.hashCode = Objects.hash(new Object[]{this.attributes, this.directives, this.mode, this.namespace, this.resource});
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof CapReq) {
            return this.equalsNative((CapReq)obj);
        }
        if (this.mode == MODE.Capability && obj instanceof Capability) {
            return this.equalsCap((Capability)obj);
        }
        if (this.mode == MODE.Requirement && obj instanceof Requirement) {
            return this.equalsReq((Requirement)obj);
        }
        return false;
    }

    private boolean equalsCap(Capability other) {
        if (!Objects.equals(this.namespace, other.getNamespace())) {
            return false;
        }
        if (!Objects.equals(this.attributes, other.getAttributes())) {
            return false;
        }
        if (!Objects.equals(this.directives, other.getDirectives())) {
            return false;
        }
        return Objects.equals(this.resource, other.getResource());
    }

    private boolean equalsNative(CapReq other) {
        if (this.mode != other.mode) {
            return false;
        }
        if (!Objects.equals(this.namespace, other.getNamespace())) {
            return false;
        }
        if (!Objects.equals(this.attributes, other.getAttributes())) {
            return false;
        }
        if (!Objects.equals(this.directives, other.getDirectives())) {
            return false;
        }
        return Objects.equals(this.resource, other.getResource());
    }

    private boolean equalsReq(Requirement other) {
        if (!Objects.equals(this.namespace, other.getNamespace())) {
            return false;
        }
        if (!Objects.equals(this.attributes, other.getAttributes())) {
            return false;
        }
        if (!Objects.equals(this.directives, other.getDirectives())) {
            return false;
        }
        return Objects.equals(this.resource, other.getResource());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.mode == MODE.Capability) {
            Object value = this.attributes.get(this.namespace);
            builder.append(this.namespace).append('=').append(value);
        } else {
            String filter = this.directives.get("filter");
            builder.append(filter);
            if ("optional".equals(this.directives.get("resolution"))) {
                builder.append("%OPT");
            }
        }
        return builder.toString();
    }

    protected void toString(StringBuilder sb) {
        sb.append("[").append(this.namespace).append("]");
        sb.append(this.attributes);
        sb.append(this.directives);
    }

    static enum MODE {
        Capability,
        Requirement;

    }
}

