/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.generator.internal.artifact;

import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Resource;
import com.liferay.petra.string.StringBundler;
import com.liferay.whip.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArtifactURLUtil {
    private static final Pattern _pattern = Pattern.compile("(.*?)(-[0-9\\.]+)");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL transform(URL artifact) throws IOException {
        int y;
        int x;
        String path = artifact.getPath();
        String symbolicName = path.substring((x = path.lastIndexOf(47)) + 1, y = path.lastIndexOf(46));
        Matcher matcher = _pattern.matcher(symbolicName);
        if (matcher.matches()) {
            symbolicName = matcher.group(1);
        }
        String contextName = null;
        String fileExtension = path.substring(y + 1);
        if (fileExtension.equals("war")) {
            try (Jar jar = new Jar("WAR", artifact.openStream());){
                if (jar.getBsn() != null) {
                    URL uRL = artifact;
                    return uRL;
                }
                contextName = ArtifactURLUtil._readServletContextName(jar);
            }
            catch (Exception exception) {
                ReflectionUtil.throwException(exception);
            }
        }
        if (contextName == null) {
            contextName = symbolicName;
        }
        return new URL("webbundle", null, StringBundler.concat((String[])new String[]{artifact.getPath(), "?", "Bundle-SymbolicName", "=", symbolicName, "&Web-ContextPath=/", contextName, "&fileExtension=", fileExtension, "&protocol=file"}));
    }

    private static String _readServletContextName(Jar jar) throws Exception {
        Resource resource = jar.getResource("WEB-INF/liferay-plugin-package.properties");
        if (resource == null) {
            return null;
        }
        Properties properties = new Properties();
        try (InputStream inputStream = resource.openInputStream();){
            properties.load(inputStream);
        }
        return properties.getProperty("servlet-context-name");
    }
}

