/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;

public class ConstantPool {
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_MethodHandle = 15;
    public static final int CONSTANT_MethodType = 16;
    public static final int CONSTANT_Dynamic = 17;
    public static final int CONSTANT_InvokeDynamic = 18;
    public static final int CONSTANT_Module = 19;
    public static final int CONSTANT_Package = 20;
    final Object[] pool;

    ConstantPool(Object[] pool) {
        this.pool = pool;
    }

    public int size() {
        return this.pool.length;
    }

    public <T> T entry(int index) {
        return (T)this.pool[index];
    }

    public int tag(int index) {
        Object entry = this.pool[index];
        if (entry instanceof Info) {
            return ((Info)entry).tag();
        }
        if (entry instanceof String) {
            return 1;
        }
        if (entry instanceof Integer) {
            return 3;
        }
        if (entry instanceof Long) {
            return 5;
        }
        if (entry instanceof Float) {
            return 4;
        }
        if (entry instanceof Double) {
            return 6;
        }
        return 0;
    }

    public String utf8(int utf8_index) {
        return (String)this.pool[utf8_index];
    }

    public String className(int class_info_index) {
        ClassInfo classInfo = (ClassInfo)this.entry(class_info_index);
        return this.utf8(classInfo.class_index);
    }

    public String moduleName(int module_info_index) {
        ModuleInfo moduleInfo = (ModuleInfo)this.entry(module_info_index);
        return this.utf8(moduleInfo.name_index);
    }

    public String packageName(int package_info_index) {
        PackageInfo packageInfo = (PackageInfo)this.entry(package_info_index);
        return this.utf8(packageInfo.name_index);
    }

    public String string(int string_info_index) {
        StringInfo stringInfo = (StringInfo)this.entry(string_info_index);
        return this.utf8(stringInfo.string_index);
    }

    public String toString() {
        return Arrays.toString(this.pool);
    }

    static ConstantPool parseConstantPool(DataInput in) throws IOException {
        int constant_pool_count = in.readUnsignedShort();
        Object[] pool = new Object[constant_pool_count];
        block19: for (int index = 1; index < constant_pool_count; ++index) {
            int tag = in.readUnsignedByte();
            switch (tag) {
                case 1: {
                    pool[index] = ConstantPool.parseUtf8Info(in);
                    continue block19;
                }
                case 3: {
                    pool[index] = ConstantPool.parseIntegerInfo(in);
                    continue block19;
                }
                case 4: {
                    pool[index] = ConstantPool.parseFloatInfo(in);
                    continue block19;
                }
                case 5: {
                    pool[index] = ConstantPool.parseLongInfo(in);
                    ++index;
                    continue block19;
                }
                case 6: {
                    pool[index] = ConstantPool.parseDoubleInfo(in);
                    ++index;
                    continue block19;
                }
                case 7: {
                    pool[index] = ConstantPool.parseClassInfo(in);
                    continue block19;
                }
                case 8: {
                    pool[index] = ConstantPool.parseStringInfo(in);
                    continue block19;
                }
                case 9: {
                    pool[index] = ConstantPool.parseFieldrefInfo(in);
                    continue block19;
                }
                case 10: {
                    pool[index] = ConstantPool.parseMethodrefInfo(in);
                    continue block19;
                }
                case 11: {
                    pool[index] = ConstantPool.parseInterfaceMethodrefInfo(in);
                    continue block19;
                }
                case 12: {
                    pool[index] = ConstantPool.parseNameAndTypeInfo(in);
                    continue block19;
                }
                case 15: {
                    pool[index] = ConstantPool.parseMethodHandleInfo(in);
                    continue block19;
                }
                case 16: {
                    pool[index] = ConstantPool.parseMethodTypeInfo(in);
                    continue block19;
                }
                case 17: {
                    pool[index] = ConstantPool.parseDynamicInfo(in);
                    continue block19;
                }
                case 18: {
                    pool[index] = ConstantPool.parseInvokeDynamicInfo(in);
                    continue block19;
                }
                case 19: {
                    pool[index] = ConstantPool.parseModuleInfo(in);
                    continue block19;
                }
                case 20: {
                    pool[index] = ConstantPool.parsePackageInfo(in);
                    continue block19;
                }
                default: {
                    throw new IOException("Unrecognized constant pool tag value " + tag + " at index " + index);
                }
            }
        }
        return new ConstantPool(pool);
    }

    static String parseUtf8Info(DataInput in) throws IOException {
        return in.readUTF();
    }

    static Integer parseIntegerInfo(DataInput in) throws IOException {
        int constant = in.readInt();
        return constant;
    }

    static Float parseFloatInfo(DataInput in) throws IOException {
        float constant = in.readFloat();
        return Float.valueOf(constant);
    }

    static Long parseLongInfo(DataInput in) throws IOException {
        long constant = in.readLong();
        return constant;
    }

    static Double parseDoubleInfo(DataInput in) throws IOException {
        double constant = in.readDouble();
        return constant;
    }

    static ClassInfo parseClassInfo(DataInput in) throws IOException {
        int name_index = in.readUnsignedShort();
        return new ClassInfo(name_index);
    }

    static StringInfo parseStringInfo(DataInput in) throws IOException {
        int string_index = in.readUnsignedShort();
        return new StringInfo(string_index);
    }

    static <R extends AbstractRefInfo> R parseRefInfo(DataInput in, IntBiFunction<R> constructor) throws IOException {
        int class_index = in.readUnsignedShort();
        int name_and_type_index = in.readUnsignedShort();
        return (R)((AbstractRefInfo)constructor.apply(class_index, name_and_type_index));
    }

    static FieldrefInfo parseFieldrefInfo(DataInput in) throws IOException {
        return ConstantPool.parseRefInfo(in, FieldrefInfo::new);
    }

    static MethodrefInfo parseMethodrefInfo(DataInput in) throws IOException {
        return ConstantPool.parseRefInfo(in, MethodrefInfo::new);
    }

    static InterfaceMethodrefInfo parseInterfaceMethodrefInfo(DataInput in) throws IOException {
        return ConstantPool.parseRefInfo(in, InterfaceMethodrefInfo::new);
    }

    static NameAndTypeInfo parseNameAndTypeInfo(DataInput in) throws IOException {
        int name_index = in.readUnsignedShort();
        int descriptor_index = in.readUnsignedShort();
        return new NameAndTypeInfo(name_index, descriptor_index);
    }

    static MethodHandleInfo parseMethodHandleInfo(DataInput in) throws IOException {
        int reference_kind = in.readUnsignedByte();
        int reference_index = in.readUnsignedShort();
        return new MethodHandleInfo(reference_kind, reference_index);
    }

    static MethodTypeInfo parseMethodTypeInfo(DataInput in) throws IOException {
        int descriptor_index = in.readUnsignedShort();
        return new MethodTypeInfo(descriptor_index);
    }

    static <D extends AbstractDynamicInfo> D parseAbstractDynamicInfo(DataInput in, IntBiFunction<D> constructor) throws IOException {
        int bootstrap_method_attr_index = in.readUnsignedShort();
        int name_and_type_index = in.readUnsignedShort();
        return (D)((AbstractDynamicInfo)constructor.apply(bootstrap_method_attr_index, name_and_type_index));
    }

    static DynamicInfo parseDynamicInfo(DataInput in) throws IOException {
        return ConstantPool.parseAbstractDynamicInfo(in, DynamicInfo::new);
    }

    static InvokeDynamicInfo parseInvokeDynamicInfo(DataInput in) throws IOException {
        return ConstantPool.parseAbstractDynamicInfo(in, InvokeDynamicInfo::new);
    }

    static ModuleInfo parseModuleInfo(DataInput in) throws IOException {
        int name_index = in.readUnsignedShort();
        return new ModuleInfo(name_index);
    }

    static PackageInfo parsePackageInfo(DataInput in) throws IOException {
        int name_index = in.readUnsignedShort();
        return new PackageInfo(name_index);
    }

    public static class PackageInfo
    implements Info {
        public final int name_index;

        PackageInfo(int name_index) {
            this.name_index = name_index;
        }

        @Override
        public int tag() {
            return 20;
        }

        public String toString() {
            return "PackageInfo:" + this.name_index;
        }
    }

    public static class ModuleInfo
    implements Info {
        public final int name_index;

        ModuleInfo(int name_index) {
            this.name_index = name_index;
        }

        @Override
        public int tag() {
            return 19;
        }

        public String toString() {
            return "ModuleInfo:" + this.name_index;
        }
    }

    public static class InvokeDynamicInfo
    extends AbstractDynamicInfo {
        InvokeDynamicInfo(int bootstrap_method_attr_index, int name_and_type_index) {
            super(bootstrap_method_attr_index, name_and_type_index);
        }

        @Override
        public int tag() {
            return 18;
        }

        public String toString() {
            return "InvokeDynamicInfo:" + this.bootstrap_method_attr_index + ":" + this.name_and_type_index;
        }
    }

    public static class DynamicInfo
    extends AbstractDynamicInfo {
        DynamicInfo(int bootstrap_method_attr_index, int name_and_type_index) {
            super(bootstrap_method_attr_index, name_and_type_index);
        }

        @Override
        public int tag() {
            return 17;
        }

        public String toString() {
            return "DynamicInfo:" + this.bootstrap_method_attr_index + ":" + this.name_and_type_index;
        }
    }

    public static abstract class AbstractDynamicInfo
    implements Info {
        public final int bootstrap_method_attr_index;
        public final int name_and_type_index;

        AbstractDynamicInfo(int bootstrap_method_attr_index, int name_and_type_index) {
            this.bootstrap_method_attr_index = bootstrap_method_attr_index;
            this.name_and_type_index = name_and_type_index;
        }
    }

    public static class MethodTypeInfo
    implements Info {
        public final int descriptor_index;

        MethodTypeInfo(int descriptor_index) {
            this.descriptor_index = descriptor_index;
        }

        @Override
        public int tag() {
            return 16;
        }

        public String toString() {
            return "MethodTypeInfo:" + this.descriptor_index;
        }
    }

    public static class MethodHandleInfo
    implements Info {
        public static final int REF_getField = 1;
        public static final int REF_getStatic = 2;
        public static final int REF_putField = 3;
        public static final int REF_putStatic = 4;
        public static final int REF_invokeVirtual = 5;
        public static final int REF_invokeStatic = 6;
        public static final int REF_invokeSpecial = 7;
        public static final int REF_newInvokeSpecial = 8;
        public static final int REF_invokeInterface = 9;
        public final int reference_kind;
        public final int reference_index;

        MethodHandleInfo(int reference_kind, int reference_index) {
            this.reference_kind = reference_kind;
            this.reference_index = reference_index;
        }

        @Override
        public int tag() {
            return 15;
        }

        public String toString() {
            return "MethodHandleInfo:" + this.reference_kind + ":" + this.reference_index;
        }
    }

    public static class NameAndTypeInfo
    implements Info {
        public final int name_index;
        public final int descriptor_index;

        NameAndTypeInfo(int name_index, int descriptor_index) {
            this.name_index = name_index;
            this.descriptor_index = descriptor_index;
        }

        @Override
        public int tag() {
            return 12;
        }

        public String toString() {
            return "NameAndTypeInfo:" + this.name_index + ":" + this.descriptor_index;
        }
    }

    public static class InterfaceMethodrefInfo
    extends AbstractRefInfo {
        InterfaceMethodrefInfo(int class_index, int name_and_type_index) {
            super(class_index, name_and_type_index);
        }

        @Override
        public int tag() {
            return 11;
        }

        public String toString() {
            return "InterfaceMethodrefInfo:" + this.class_index + ":" + this.name_and_type_index;
        }
    }

    public static class MethodrefInfo
    extends AbstractRefInfo {
        MethodrefInfo(int class_index, int name_and_type_index) {
            super(class_index, name_and_type_index);
        }

        @Override
        public int tag() {
            return 10;
        }

        public String toString() {
            return "MethodrefInfo:" + this.class_index + ":" + this.name_and_type_index;
        }
    }

    public static class FieldrefInfo
    extends AbstractRefInfo {
        FieldrefInfo(int class_index, int name_and_type_index) {
            super(class_index, name_and_type_index);
        }

        @Override
        public int tag() {
            return 9;
        }

        public String toString() {
            return "FieldrefInfo:" + this.class_index + ":" + this.name_and_type_index;
        }
    }

    @FunctionalInterface
    static interface IntBiFunction<R> {
        public R apply(int var1, int var2);
    }

    public static abstract class AbstractRefInfo
    implements Info {
        public final int class_index;
        public final int name_and_type_index;

        AbstractRefInfo(int class_index, int name_and_type_index) {
            this.class_index = class_index;
            this.name_and_type_index = name_and_type_index;
        }
    }

    public static class StringInfo
    implements Info {
        public final int string_index;

        StringInfo(int string_index) {
            this.string_index = string_index;
        }

        @Override
        public int tag() {
            return 8;
        }

        public String toString() {
            return "StringInfo:" + this.string_index;
        }
    }

    public static class ClassInfo
    implements Info {
        public final int class_index;

        ClassInfo(int class_index) {
            this.class_index = class_index;
        }

        @Override
        public int tag() {
            return 7;
        }

        public String toString() {
            return "ClassInfo:" + this.class_index;
        }
    }

    public static interface Info {
        public int tag();
    }
}

