/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.AnnotationInfo;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;

public class ElementValueInfo {
    public final String name;
    public final Object value;

    ElementValueInfo(String name, Object value) {
        this.name = name;
        this.value = value;
    }

    public String toString() {
        return this.name + "=" + (this.value instanceof Object[] ? Arrays.toString((Object[])this.value) : this.value);
    }

    static ElementValueInfo parseElementValueInfo(DataInput in, ConstantPool constant_pool) throws IOException {
        int element_name_index = in.readUnsignedShort();
        Object value = ElementValueInfo.parseElementValue(in, constant_pool);
        return new ElementValueInfo(constant_pool.utf8(element_name_index), value);
    }

    static Object parseElementValue(DataInput in, ConstantPool constant_pool) throws IOException {
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 115: {
                int const_value_index = in.readUnsignedShort();
                return constant_pool.entry(const_value_index);
            }
            case 90: {
                int const_value_index = in.readUnsignedShort();
                Integer const_value = (Integer)constant_pool.entry(const_value_index);
                return const_value != 0;
            }
            case 101: {
                return EnumConst.parseEnumConst(in, constant_pool);
            }
            case 99: {
                return ResultConst.parseResultConst(in, constant_pool);
            }
            case 64: {
                return AnnotationInfo.parseAnnotationInfo(in, constant_pool);
            }
            case 91: {
                int num_values = in.readUnsignedShort();
                Object[] array_value = new Object[num_values];
                for (int i = 0; i < num_values; ++i) {
                    array_value[i] = ElementValueInfo.parseElementValue(in, constant_pool);
                }
                return array_value;
            }
        }
        throw new IOException("Invalid value for Annotation ElementValue tag " + tag);
    }

    public static class ResultConst {
        public final String descriptor;

        ResultConst(String descriptor) {
            this.descriptor = descriptor;
        }

        public String toString() {
            return this.descriptor;
        }

        static ResultConst parseResultConst(DataInput in, ConstantPool constant_pool) throws IOException {
            int class_index = in.readUnsignedShort();
            return new ResultConst(constant_pool.utf8(class_index));
        }
    }

    public static class EnumConst {
        public final String type;
        public final String name;

        EnumConst(String type, String name) {
            this.type = type;
            this.name = name;
        }

        public String toString() {
            return this.type + "." + this.name;
        }

        static EnumConst parseEnumConst(DataInput in, ConstantPool constant_pool) throws IOException {
            int type_name_index = in.readUnsignedShort();
            int const_name_index = in.readUnsignedShort();
            return new EnumConst(constant_pool.utf8(type_name_index), constant_pool.utf8(const_name_index));
        }
    }
}

