/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;

public class ModulePackagesAttribute
implements Attribute {
    public static final String NAME = "ModulePackages";
    public final String[] packages;

    ModulePackagesAttribute(String[] packages) {
        this.packages = packages;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String toString() {
        return "ModulePackages " + Arrays.toString(this.packages);
    }

    static ModulePackagesAttribute parseModulePackagesAttribute(DataInput in, ConstantPool constant_pool) throws IOException {
        int package_count = in.readUnsignedShort();
        String[] packages = new String[package_count];
        for (int i = 0; i < package_count; ++i) {
            int package_index = in.readUnsignedShort();
            packages[i] = constant_pool.packageName(package_index);
        }
        return new ModulePackagesAttribute(packages);
    }
}

