/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;

public class StackMapTableAttribute
implements Attribute {
    public static final String NAME = "StackMapTable";
    public final StackMapFrame[] entries;

    StackMapTableAttribute(StackMapFrame[] entries) {
        this.entries = entries;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String toString() {
        return "StackMapTable " + Arrays.toString(this.entries);
    }

    static StackMapTableAttribute parseStackMapTableAttribute(DataInput in, ConstantPool constant_pool) throws IOException {
        int number_of_entries = in.readUnsignedShort();
        StackMapFrame[] entries = new StackMapFrame[number_of_entries];
        for (int i = 0; i < number_of_entries; ++i) {
            int n;
            VerificationTypeInfo[] locals;
            int frame_type = in.readUnsignedByte();
            if (frame_type <= 63) {
                entries[i] = new SameFrame(frame_type);
                continue;
            }
            if (frame_type <= 127) {
                VerificationTypeInfo stack = StackMapTableAttribute.parseVerificationTypeInfo(in, constant_pool);
                entries[i] = new SameLocals1StackItemFrame(frame_type, stack);
                continue;
            }
            if (frame_type <= 246) {
                throw new IOException("Unrecognized stack map frame type " + frame_type);
            }
            if (frame_type <= 247) {
                int offset_delta = in.readUnsignedShort();
                VerificationTypeInfo stack = StackMapTableAttribute.parseVerificationTypeInfo(in, constant_pool);
                entries[i] = new SameLocals1StackItemFrameExtended(frame_type, offset_delta, stack);
                continue;
            }
            if (frame_type <= 250) {
                int offset_delta = in.readUnsignedShort();
                entries[i] = new ChopFrame(frame_type, offset_delta);
                continue;
            }
            if (frame_type <= 251) {
                int offset_delta = in.readUnsignedShort();
                entries[i] = new SameFrameExtended(frame_type, offset_delta);
                continue;
            }
            if (frame_type <= 254) {
                int offset_delta = in.readUnsignedShort();
                int number_of_locals = frame_type - 251;
                locals = new VerificationTypeInfo[number_of_locals];
                for (n = 0; n < number_of_locals; ++n) {
                    locals[n] = StackMapTableAttribute.parseVerificationTypeInfo(in, constant_pool);
                }
                entries[i] = new AppendFrame(frame_type, offset_delta, locals);
                continue;
            }
            if (frame_type > 255) continue;
            int offset_delta = in.readUnsignedShort();
            int number_of_locals = in.readUnsignedShort();
            locals = new VerificationTypeInfo[number_of_locals];
            for (n = 0; n < number_of_locals; ++n) {
                locals[n] = StackMapTableAttribute.parseVerificationTypeInfo(in, constant_pool);
            }
            int number_of_stack_items = in.readUnsignedShort();
            VerificationTypeInfo[] stack = new VerificationTypeInfo[number_of_stack_items];
            for (int n2 = 0; n2 < number_of_stack_items; ++n2) {
                stack[n2] = StackMapTableAttribute.parseVerificationTypeInfo(in, constant_pool);
            }
            entries[i] = new FullFrame(frame_type, offset_delta, locals, stack);
        }
        return new StackMapTableAttribute(entries);
    }

    static VerificationTypeInfo parseVerificationTypeInfo(DataInput in, ConstantPool constant_pool) throws IOException {
        int tag = in.readUnsignedByte();
        switch (tag) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new VerificationTypeInfo(tag);
            }
            case 7: {
                int cpool_index = in.readUnsignedShort();
                return new ObjectVariableInfo(tag, constant_pool.className(cpool_index));
            }
            case 8: {
                int offset = in.readUnsignedShort();
                return new UninitializedVariableInfo(tag, offset);
            }
        }
        throw new IOException("Unrecognized verification type tag " + tag);
    }

    public static class UninitializedVariableInfo
    extends VerificationTypeInfo {
        public final int offset;

        UninitializedVariableInfo(int tag, int offset) {
            super(tag);
            this.offset = offset;
        }

        @Override
        public String toString() {
            return this.tag + ":" + this.offset;
        }
    }

    public static class ObjectVariableInfo
    extends VerificationTypeInfo {
        public final String type;

        ObjectVariableInfo(int tag, String type) {
            super(tag);
            this.type = type;
        }

        @Override
        public String toString() {
            return this.tag + ":" + this.type;
        }
    }

    public static class VerificationTypeInfo {
        public static final int ITEM_Top = 0;
        public static final int ITEM_Integer = 1;
        public static final int ITEM_Float = 2;
        public static final int ITEM_Double = 3;
        public static final int ITEM_Long = 4;
        public static final int ITEM_Null = 5;
        public static final int ITEM_UninitializedThis = 6;
        public static final int ITEM_Object = 7;
        public static final int ITEM_Uninitialized = 8;
        public final int tag;

        VerificationTypeInfo(int tag) {
            this.tag = tag;
        }

        public String toString() {
            return Integer.toString(this.tag);
        }
    }

    public static class FullFrame
    extends StackMapFrame {
        public final int delta;
        public final VerificationTypeInfo[] locals;
        public final VerificationTypeInfo[] stack;

        FullFrame(int tag, int delta, VerificationTypeInfo[] locals, VerificationTypeInfo[] stack) {
            super(tag);
            this.delta = delta;
            this.locals = locals;
            this.stack = stack;
        }

        @Override
        public int type() {
            return 255;
        }

        @Override
        public String toString() {
            return this.tag + "/" + this.delta + "/" + Arrays.toString(this.locals) + "/" + Arrays.toString(this.stack);
        }
    }

    public static class AppendFrame
    extends StackMapFrame {
        public final int delta;
        public final VerificationTypeInfo[] locals;

        AppendFrame(int tag, int delta, VerificationTypeInfo[] locals) {
            super(tag);
            this.delta = delta;
            this.locals = locals;
        }

        @Override
        public int type() {
            return 254;
        }

        @Override
        public String toString() {
            return this.tag + "/" + this.delta + "/" + Arrays.toString(this.locals);
        }
    }

    public static class SameFrameExtended
    extends StackMapFrame {
        public final int delta;

        SameFrameExtended(int tag, int delta) {
            super(tag);
            this.delta = delta;
        }

        @Override
        public int type() {
            return 251;
        }

        @Override
        public String toString() {
            return this.tag + "/" + this.delta;
        }
    }

    public static class ChopFrame
    extends StackMapFrame {
        public final int delta;

        ChopFrame(int tag, int delta) {
            super(tag);
            this.delta = delta;
        }

        @Override
        public int type() {
            return 250;
        }

        @Override
        public String toString() {
            return this.tag + "/" + this.delta;
        }
    }

    public static class SameLocals1StackItemFrameExtended
    extends StackMapFrame {
        public final int delta;
        public final VerificationTypeInfo stack;

        SameLocals1StackItemFrameExtended(int tag, int delta, VerificationTypeInfo stack) {
            super(tag);
            this.delta = delta;
            this.stack = stack;
        }

        @Override
        public int type() {
            return 247;
        }

        @Override
        public String toString() {
            return this.tag + "/" + this.delta + "/" + this.stack;
        }
    }

    public static class SameLocals1StackItemFrame
    extends StackMapFrame {
        public final VerificationTypeInfo stack;

        SameLocals1StackItemFrame(int tag, VerificationTypeInfo stack) {
            super(tag);
            this.stack = stack;
        }

        @Override
        public int type() {
            return 127;
        }

        @Override
        public String toString() {
            return this.tag + "/" + this.stack;
        }
    }

    public static class SameFrame
    extends StackMapFrame {
        SameFrame(int tag) {
            super(tag);
        }

        @Override
        public int type() {
            return 63;
        }
    }

    public static abstract class StackMapFrame {
        public static final int SAME = 63;
        public static final int SAME_LOCALS_1_STACK_ITEM = 127;
        public static final int RESERVED = 246;
        public static final int SAME_LOCALS_1_STACK_ITEM_EXTENDED = 247;
        public static final int CHOP = 250;
        public static final int SAME_FRAME_EXTENDED = 251;
        public static final int APPEND = 254;
        public static final int FULL_FRAME = 255;
        public final int tag;

        StackMapFrame(int tag) {
            this.tag = tag;
        }

        public abstract int type();

        public String toString() {
            return Integer.toString(this.tag);
        }
    }
}

