/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.exporter.executable;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.build.Project;
import aQute.bnd.build.ProjectLauncher;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.JarResource;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.export.Exporter;
import aQute.lib.converter.Converter;
import aQute.lib.strings.Strings;
import java.util.AbstractMap;
import java.util.Map;

@BndPlugin(name="exporter.executablejar")
public class ExecutableJarExporter
implements Exporter {
    public static final String EXECUTABLE_JAR = "bnd.executablejar";

    @Override
    public String[] getTypes() {
        return new String[]{EXECUTABLE_JAR};
    }

    @Override
    public Map.Entry<String, Resource> export(String type, Project project, Map<String, String> options) throws Exception {
        Configuration configuration = Converter.cnv(Configuration.class, options);
        project.prepare();
        try (ProjectLauncher launcher = project.getProjectLauncher();){
            launcher.setKeep(configuration.keep());
            Jar jar = launcher.executable();
            project.getInfo(launcher);
            String name = jar.getName();
            String[] baseext = Strings.extension(name);
            if (baseext != null && ("bnd".equals(baseext[1]) || "bndrun".equals(baseext[1]))) {
                name = baseext[0];
            }
            name = name + ".jar";
            AbstractMap.SimpleEntry<String, Resource> simpleEntry = new AbstractMap.SimpleEntry<String, Resource>(name, new JarResource(jar, true));
            return simpleEntry;
        }
    }

    static interface Configuration {
        public boolean keep();
    }
}

