/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.url;

import aQute.bnd.annotation.plugin.BndPlugin;
import aQute.bnd.url.DefaultURLConnectionHandler;
import aQute.bnd.url.LocalTrustManager;
import aQute.lib.converter.Converter;
import aQute.lib.io.IO;
import aQute.service.reporter.Reporter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BndPlugin(name="url.https.verification", parameters=Config.class)
public class HttpsVerification
extends DefaultURLConnectionHandler {
    static Logger logger = LoggerFactory.getLogger(HttpsVerification.class);
    private SSLSocketFactory factory;
    private HostnameVerifier verifier;
    private boolean verify = true;
    private String certificatesPath;
    private X509Certificate[] certificateChain;

    public HttpsVerification() {
    }

    public HttpsVerification(String certificates, boolean hostnameVerify, Reporter reporter) {
        this.certificatesPath = certificates;
        this.verify = hostnameVerify;
        this.setReporter(reporter);
    }

    public HttpsVerification(X509Certificate[] certificateChain, boolean b, Reporter hc) {
        this.certificateChain = certificateChain;
        this.verify = b;
        this.setReporter(hc);
    }

    private synchronized void init() throws NoSuchAlgorithmException, KeyManagementException, FileNotFoundException, CertificateException, IOException, InvalidAlgorithmParameterException {
        if (this.factory == null) {
            TrustManager[] trustManagers = new TrustManager[]{};
            trustManagers = new TrustManager[]{new LocalTrustManager(this.verify, this.createCertificates(this.certificatesPath))};
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, trustManagers, new SecureRandom());
            this.factory = context.getSocketFactory();
            this.verifier = new HostnameVerifier(){

                @Override
                public boolean verify(String string, SSLSession session) {
                    return HttpsVerification.this.verify;
                }
            };
        }
    }

    @Override
    public void handle(URLConnection connection) throws Exception {
        if (connection instanceof HttpsURLConnection && this.matches(connection)) {
            HttpsURLConnection https = (HttpsURLConnection)connection;
            this.init();
            https.setSSLSocketFactory(this.factory);
            https.setHostnameVerifier(this.verifier);
        }
    }

    @Override
    public void setProperties(Map<String, String> map) throws Exception {
        super.setProperties(map);
        Config config = Converter.cnv(Config.class, map);
        this.certificatesPath = config.trusted();
    }

    List<X509Certificate> createCertificates(String paths) throws FileNotFoundException, CertificateException, IOException {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        if (paths != null) {
            HttpsVerification.getCertificates(paths, certificates);
        } else if (this.certificateChain != null) {
            Collections.addAll(certificates, this.certificateChain);
        }
        return certificates;
    }

    public static void getCertificates(String paths, List<X509Certificate> certificates) throws CertificateException, IOException {
        for (String path : paths.split("\\s*,\\s*")) {
            File file = new File(path);
            if (file.isFile()) {
                try (InputStream inStream = IO.stream(file);){
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(inStream);
                    certificates.add(cert);
                    continue;
                }
            }
            logger.warn("Missing trust certificates file {}", (Object)path);
        }
    }

    public String toString() {
        return "HttpsVerification [verify=" + this.verify + ", certificatesPath=" + this.certificatesPath + "]";
    }

    static interface Config {
        public String trusted();
    }
}

