/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.stringrover;

import java.util.Objects;

public class StringRover
implements CharSequence {
    private final String string;
    private int offset;

    public StringRover(String string) {
        this.string = Objects.requireNonNull(string);
        this.offset = 0;
    }

    private StringRover(String string, int offset) {
        this.string = string;
        this.offset = offset;
    }

    @Override
    public int length() {
        return this.string.length() - this.offset;
    }

    @Override
    public boolean isEmpty() {
        return this.string.length() <= this.offset;
    }

    @Override
    public char charAt(int index) {
        return this.string.charAt(this.offset + index);
    }

    public StringRover increment() {
        ++this.offset;
        return this;
    }

    public StringRover increment(int increment) {
        this.offset += increment;
        return this;
    }

    public StringRover reset() {
        this.offset = 0;
        return this;
    }

    public StringRover duplicate() {
        return new StringRover(this.string, this.offset);
    }

    public int indexOf(int ch, int from) {
        return this.string.indexOf(ch, this.offset + from) - this.offset;
    }

    public String substring(int start, int end) {
        return this.string.substring(this.offset + start, this.offset + end);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    @Override
    public String toString() {
        return this.string.substring(this.offset);
    }
}

