/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.cryptography;

import aQute.libg.cryptography.Digest;
import aQute.libg.cryptography.Digester;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SHA512
extends Digest {
    public static final String ALGORITHM = "SHA-512";

    public static Digester<SHA512> getDigester(OutputStream ... out) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(ALGORITHM);
        return new Digester<SHA512>(md, out){

            @Override
            public SHA512 digest() throws Exception {
                return new SHA512(this.md.digest());
            }

            @Override
            public SHA512 digest(byte[] bytes) {
                return new SHA512(bytes);
            }

            @Override
            public String getAlgorithm() {
                return SHA512.ALGORITHM;
            }
        };
    }

    public SHA512(byte[] b) {
        super(b, 32);
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    public static SHA512 digest(byte[] data) throws Exception {
        return SHA512.getDigester(new OutputStream[0]).from(data);
    }

    public static SHA512 digest(File f) throws NoSuchAlgorithmException, Exception {
        return SHA512.getDigester(new OutputStream[0]).from(f);
    }

    public static SHA512 digest(InputStream f) throws NoSuchAlgorithmException, Exception {
        return SHA512.getDigester(new OutputStream[0]).from(f);
    }
}

