/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.generator.internal.processor;

import aQute.bnd.cdi.Discover;
import aQute.bnd.component.DSAnnotations;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.Parameters;
import aQute.bnd.make.component.ServiceComponent;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Builder;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.verifier.VerifierPlugin;
import aQute.bnd.version.Version;
import aQute.lib.filter.Filter;
import com.liferay.ant.bnd.jsp.JspAnalyzerPlugin;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployListener;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.deploy.hot.DependencyManagementThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.servlet.PortalClassLoaderFilter;
import com.liferay.portal.kernel.servlet.PortalClassLoaderServlet;
import com.liferay.portal.kernel.util.ConcurrentHashMapBuilder;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.LinkedHashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.JS;
import com.liferay.whip.util.ReflectionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Format;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class WabProcessor {
    private static final boolean _AUTODEPLOYED_WARS_STORE;
    private static final Version _CDI_ARCHIVE_VERSION;
    private static final String[] _KNOWN_PROPERTY_KEYS;
    private static final String _REQUIRE_CAPABILITY_CDI;
    private static final String _REQUIRE_CAPABILITY_OSGI_CONFIGURATOR = "osgi.extender;filter:=\"(&(osgi.extender=osgi.configurator)(version>=1.0)(!(version>=2.0)))\"";
    private static final String _XPATHS_HOOK;
    private static final String _XPATHS_JAVAEE;
    private static final String _XPATHS_LIFERAY;
    private static final String _XPATHS_PORTLET;
    private static final String _XPATHS_SPRING;
    private static final Log _log;
    private static final List<AutoDeployListener> _autoDeployListeners;
    private static final Attrs _optionalAttrs;
    private static final Pattern _tldPackagesPattern;
    private static final Pattern _versionMavenPattern;
    private static final Map<String, String> _xsds;
    private String _bundleVersion;
    private String _context;
    private final Parameters _exportPackageParameters = new Parameters();
    private final File _file;
    private final Set<String> _ignoredResourcePaths = SetUtil.fromArray((Object[])PropsValues.MODULE_FRAMEWORK_WEB_GENERATOR_EXCLUDED_PATHS);
    private final Parameters _importPackageParameters = new Parameters();
    private final Map<String, String[]> _parameters;
    private File _pluginDir;
    private PluginPackage _pluginPackage;
    private String _servicePackageName;

    public WabProcessor(ClassLoader classLoader, File file, Map<String, String[]> parameters) {
        this._file = file;
        this._parameters = parameters;
    }

    public File getProcessedFile() throws IOException {
        String fileExtension = MapUtil.getString(this._parameters, (String)"fileExtension");
        this._pluginDir = Objects.equals(fileExtension, "zip") ? this._convertToClientExtensionBundleDir() : this._autoDeploy();
        if (this._pluginDir == null || !this._pluginDir.exists() || !this._pluginDir.isDirectory()) {
            return null;
        }
        File outputFile = null;
        try (Jar jar = new Jar(this._pluginDir);){
            if (jar.getBsn() == null) {
                outputFile = this._transformToOSGiBundle(jar);
            }
        }
        catch (Exception exception) {
            ReflectionUtil.throwException(exception);
        }
        if (PropsValues.MODULE_FRAMEWORK_WEB_GENERATOR_GENERATED_WABS_STORE) {
            this._writeGeneratedWab(outputFile);
        }
        return outputFile;
    }

    protected void executeAutoDeployers(AutoDeploymentContext autoDeploymentContext) {
        boolean enabled = DependencyManagementThreadLocal.isEnabled();
        try {
            DependencyManagementThreadLocal.setEnabled((boolean)false);
            AutoDeployListener autoDeployListener = this._getAutoDeployListener(autoDeploymentContext, _autoDeployListeners);
            autoDeployListener.deploy(autoDeploymentContext);
        }
        catch (AutoDeployException autoDeployException) {
            throw new RuntimeException(autoDeployException);
        }
        finally {
            DependencyManagementThreadLocal.setEnabled((boolean)enabled);
        }
    }

    private void _appendProperty(Analyzer analyzer, String property, String string) {
        analyzer.setProperty(property, Analyzer.append(analyzer.getProperty(property), string));
    }

    private File _autoDeploy() {
        AutoDeploymentContext autoDeploymentContext = this._buildAutoDeploymentContext(this._getWebContextPath());
        this.executeAutoDeployers(autoDeploymentContext);
        this._pluginPackage = autoDeploymentContext.getPluginPackage();
        this._context = this._pluginPackage != null ? this._pluginPackage.getContext() : autoDeploymentContext.getContext();
        if (this._file.isDirectory()) {
            return this._file;
        }
        File deployDir = autoDeploymentContext.getDeployDir();
        if (!deployDir.exists()) {
            File parentFile = deployDir.getParentFile();
            File[] files = parentFile.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".war");
                }
            });
            if (files == null || files.length == 0) {
                _log.error((Object)("Unable to find any WARs in " + parentFile));
                return null;
            }
            File file = files[0];
            deployDir.mkdirs();
            if (file.isDirectory()) {
                FileUtil.move((File)file, (File)deployDir);
            } else {
                try (Jar jar = new Jar(file);){
                    jar.expand(deployDir);
                }
                catch (Exception exception) {
                    ReflectionUtil.throwException(exception);
                }
            }
        }
        if (_AUTODEPLOYED_WARS_STORE) {
            this._writeAutoDeployedWar(deployDir);
        }
        return deployDir;
    }

    private AutoDeploymentContext _buildAutoDeploymentContext(String context) {
        AutoDeploymentContext autoDeploymentContext = new AutoDeploymentContext();
        autoDeploymentContext.setContext(context);
        autoDeploymentContext.setFile(this._file);
        if (this._file.isDirectory()) {
            return autoDeploymentContext;
        }
        File file = new File(this._file.getParentFile(), "deploy");
        file.mkdirs();
        autoDeploymentContext.setDestDir(file.getAbsolutePath());
        return autoDeploymentContext;
    }

    private File _convertToClientExtensionBundleDir() {
        Path clientExtensionBundlePath = null;
        try (ZipFile zipFile = new ZipFile(this._file);){
            clientExtensionBundlePath = Files.createTempDirectory("clientextension", new FileAttribute[0]);
            Path metatInfResourcesPath = this._createPath(clientExtensionBundlePath, "META-INF/resources");
            Path osgiInfConfiguratorPath = this._createPath(clientExtensionBundlePath, "OSGI-INF/configurator");
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    if (!name.startsWith("static/")) continue;
                    Files.createDirectories(metatInfResourcesPath.resolve(name.replaceAll("^static/", "")), new FileAttribute[0]);
                    continue;
                }
                if (!name.contains("/") && name.endsWith(".client-extension-config.json")) {
                    Files.copy(zipFile.getInputStream(zipEntry), osgiInfConfiguratorPath.resolve(name), new CopyOption[0]);
                    continue;
                }
                if (!name.startsWith("static/")) continue;
                Files.copy(zipFile.getInputStream(zipEntry), metatInfResourcesPath.resolve(name.replaceAll("^static/", "")), new CopyOption[0]);
            }
        }
        catch (IOException ioException) {
            _log.error((Throwable)ioException);
        }
        return clientExtensionBundlePath.toFile();
    }

    private Path _createPath(Path parentPath, String pathString) throws IOException {
        Path path = parentPath.resolve(pathString);
        Files.createDirectories(path, new FileAttribute[0]);
        return path;
    }

    private Discover _findDiscoveryMode(Document document) {
        if (!document.hasContent()) {
            return Discover.all;
        }
        Element rootElement = document.getRootElement();
        XPath xPath = SAXReaderUtil.createXPath((String)"/cdi-beans:beans/@version", _xsds);
        Node versionNode = xPath.selectSingleNode((Object)rootElement);
        if (versionNode == null) {
            return Discover.all;
        }
        Version version = Version.valueOf(versionNode.getStringValue());
        if (_CDI_ARCHIVE_VERSION.compareTo(version) <= 0) {
            xPath = SAXReaderUtil.createXPath((String)"/cdi-beans:beans/@bean-discovery-mode", _xsds);
            Node beanDiscoveryModeNode = xPath.selectSingleNode((Object)rootElement);
            if (beanDiscoveryModeNode == null) {
                return Discover.annotated;
            }
            return Discover.valueOf(beanDiscoveryModeNode.getStringValue());
        }
        return Discover.all;
    }

    private void _formatDocument(File file, Document document) throws IOException {
        try {
            FileUtil.write((File)file, (String)document.formattedString("  "));
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    private AutoDeployListener _getAutoDeployListener(AutoDeploymentContext autoDeploymentContext, List<AutoDeployListener> autoDeployListeners) {
        ArrayList<AutoDeployListener> deployableAutoDeployListeners = new ArrayList<AutoDeployListener>();
        for (AutoDeployListener autoDeployListener : autoDeployListeners) {
            try {
                if (!autoDeployListener.isDeployable(autoDeploymentContext)) continue;
                deployableAutoDeployListeners.add(autoDeployListener);
            }
            catch (AutoDeployException autoDeployException) {
                throw new RuntimeException(autoDeployException);
            }
        }
        if (deployableAutoDeployListeners.size() > 1) {
            StringBundler sb = new StringBundler(3 + deployableAutoDeployListeners.size() * 2 - 1);
            sb.append("More than one auto deploy listener is available for ");
            sb.append((Object)autoDeploymentContext.getFile());
            sb.append(": ");
            for (int i = 0; i < deployableAutoDeployListeners.size(); ++i) {
                AutoDeployListener deployableAutoDeployListener = (AutoDeployListener)deployableAutoDeployListeners.get(i);
                Class<?> clazz = deployableAutoDeployListener.getClass();
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(clazz.getName());
            }
            throw new RuntimeException(new AutoDeployException(sb.toString()));
        }
        return (AutoDeployListener)deployableAutoDeployListeners.get(0);
    }

    private Properties _getPluginPackageProperties() {
        File file = new File(this._pluginDir, "WEB-INF/liferay-plugin-package.properties");
        if (!file.exists()) {
            return new Properties();
        }
        try {
            return PropertiesUtil.load((String)FileUtil.read((File)file));
        }
        catch (IOException ioException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)ioException);
            }
            return new Properties();
        }
    }

    private String _getVersionedServicePackageName(String partialPackageName) {
        return StringBundler.concat((String[])new String[]{this._servicePackageName, partialPackageName, ";version=", this._bundleVersion});
    }

    private String _getWebContextPath() {
        String webContextpath = MapUtil.getString(this._parameters, (String)"Web-ContextPath");
        if (!webContextpath.startsWith("/")) {
            webContextpath = "/".concat(webContextpath);
        }
        return webContextpath;
    }

    private void _processBeans(Builder analyzer) throws IOException {
        String beansXMLFile = "WEB-INF/beans.xml";
        File file = new File(this._pluginDir, beansXMLFile);
        if (!file.exists()) {
            beansXMLFile = "WEB-INF/classes/META-INF/beans.xml";
            file = new File(this._pluginDir, beansXMLFile);
        }
        if (!file.exists()) {
            return;
        }
        final String finalBeansXMLFile = beansXMLFile;
        Set<Object> plugins = analyzer.getPlugins();
        plugins.add(new VerifierPlugin(){

            @Override
            public void verify(Analyzer analyzer) throws Exception {
                Parameters requireCapabilities = analyzer.parseHeader(analyzer.getProperty("Require-Capability"));
                HashMap arguments = HashMapBuilder.put((Object)"osgi.extender", (Object)"osgi.cdi").put((Object)"version", (Object)new Version(1)).build();
                for (Map.Entry<String, Attrs> entry : requireCapabilities.entrySet()) {
                    String namespace = entry.getKey();
                    Attrs attrs = entry.getValue();
                    String filterString = attrs.get("filter:");
                    Filter filter = new Filter(filterString);
                    if (!Objects.equals(namespace, "osgi.extender") || !filter.matchMap(arguments)) continue;
                    attrs.putTyped("descriptor", Arrays.asList(finalBeansXMLFile));
                }
                analyzer.setProperty("Require-Capability", requireCapabilities.toString());
            }
        });
        String cdiInstruction = analyzer.getProperty("-cdiannotations");
        if (cdiInstruction != null) {
            return;
        }
        Document document = this._readDocument(file);
        Discover discover = this._findDiscoveryMode(document);
        analyzer.setProperty("-cdiannotations", "*;discover=" + (Object)((Object)discover));
        this._appendProperty(analyzer, "Require-Capability", _REQUIRE_CAPABILITY_CDI);
    }

    private void _processBundleClasspath(Analyzer analyzer) throws IOException {
        this._appendProperty(analyzer, "Bundle-ClassPath", "ext/WEB-INF/classes");
        LinkedHashMap classPath = LinkedHashMapBuilder.put((Object)"WEB-INF/classes", (Object)new File(this._pluginDir, "WEB-INF/classes")).build();
        this._appendProperty(analyzer, "Bundle-ClassPath", "WEB-INF/classes");
        this._processFiles(classPath, analyzer);
        Collection files = classPath.values();
        analyzer.setClasspath(files.toArray(new File[classPath.size()]));
    }

    private void _processBundleManifestVersion(Analyzer analyzer) {
        String bundleManifestVersion = MapUtil.getString(this._parameters, (String)"Bundle-ManifestVersion");
        if (Validator.isNull((String)bundleManifestVersion)) {
            bundleManifestVersion = "2";
        }
        analyzer.setProperty("Bundle-ManifestVersion", bundleManifestVersion);
    }

    private void _processBundleSymbolicName(Analyzer analyzer) {
        String bundleSymbolicName = MapUtil.getString(this._parameters, (String)"Bundle-SymbolicName");
        if (Validator.isNull((String)bundleSymbolicName)) {
            bundleSymbolicName = this._context.substring(1);
        }
        analyzer.setProperty("Bundle-SymbolicName", bundleSymbolicName);
    }

    private void _processBundleVersion(Analyzer analyzer) {
        this._bundleVersion = MapUtil.getString(this._parameters, (String)"Bundle-Version");
        if (Validator.isNull((String)this._bundleVersion)) {
            this._bundleVersion = this._pluginPackage != null ? this._pluginPackage.getVersion() : "1.0.0";
        }
        if (!Version.isVersion(this._bundleVersion)) {
            Matcher matcher = _versionMavenPattern.matcher(this._bundleVersion);
            this._bundleVersion = matcher.matches() ? StringBundler.concat((String[])new String[]{matcher.group(1), ".", matcher.group(3), ".", matcher.group(5), ".", matcher.group(7)}) : "0.0.0." + StringUtil.replace((String)this._bundleVersion, (char)'.', (char)'_');
        }
        analyzer.setProperty("Bundle-Version", this._bundleVersion);
    }

    private void _processClass(Analyzer analyzer, String value) {
        int index = value.lastIndexOf(46);
        if (index == -1) {
            return;
        }
        Packages packages = analyzer.getReferred();
        String packageName = value.substring(0, index);
        packages.put(analyzer.getPackageRef(packageName), new Attrs());
    }

    private void _processDeclarativeReferences(Analyzer analyzer) throws IOException {
        this._processDefaultServletPackages();
        this._processTLDDependencies(analyzer);
        this._processPortalListenerClassesDependencies(analyzer);
        Path pluginPath = this._pluginDir.toPath();
        this._processXMLDependencies(analyzer, "WEB-INF/liferay-hook.xml", _XPATHS_HOOK);
        this._processXMLDependencies(analyzer, "WEB-INF/liferay-portlet.xml", _XPATHS_LIFERAY);
        this._processXMLDependencies(analyzer, "WEB-INF/portlet.xml", _XPATHS_PORTLET);
        this._processXMLDependencies(analyzer, "WEB-INF/web.xml", _XPATHS_JAVAEE);
        Path classes = pluginPath.resolve("WEB-INF/classes/");
        this._processPropertiesDependencies(analyzer, classes, ".properties", _KNOWN_PROPERTY_KEYS);
        this._processXMLDependencies(analyzer, classes, ".xml");
        this._processXMLDependencies(analyzer, classes, ".xml");
    }

    private void _processDefaultServletPackages() {
        for (String value : PropsValues.MODULE_FRAMEWORK_WEB_GENERATOR_DEFAULT_SERVLET_PACKAGES) {
            Parameters defaultPackage = new Parameters(value);
            for (String packageName : defaultPackage.keySet()) {
                if (this._importPackageParameters.containsKey(packageName)) continue;
                this._importPackageParameters.add(packageName, _optionalAttrs);
            }
        }
    }

    private void _processExcludedJSPs(Analyzer analyzer) {
        File file = new File(this._pluginDir, "/WEB-INF/liferay-hook.xml");
        if (!file.exists()) {
            return;
        }
        Document document = this._readDocument(file);
        if (!document.hasContent()) {
            return;
        }
        Element rootElement = document.getRootElement();
        List nodes = rootElement.selectNodes("//custom-jsp-dir");
        String value = analyzer.getProperty("-jsp");
        for (Node node : nodes) {
            String text = node.getText();
            if (text.startsWith("/")) {
                text = text.substring(1);
            }
            value = StringBundler.concat((String[])new String[]{"!", text, "/*,", value});
        }
        analyzer.setProperty("-jsp", value);
    }

    private void _processExportPackageNames(Analyzer analyzer) {
        analyzer.setProperty("-exportcontents", this._exportPackageParameters.toString());
    }

    private void _processExtraHeaders(Analyzer analyzer) {
        String bundleSymbolicName = analyzer.getProperty("Bundle-SymbolicName");
        Properties properties = com.liferay.portal.kernel.util.PropsUtil.getProperties((String)"module.framework.web.generator.headers.", (boolean)true);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = properties.getProperty(key);
            String processedKey = key;
            if (processedKey.endsWith("]")) {
                String filterString = "[" + bundleSymbolicName + "]";
                if (!processedKey.endsWith(filterString)) continue;
                processedKey = processedKey.substring(0, processedKey.indexOf("["));
            }
            if (!Validator.isNotNull((String)value)) continue;
            Parameters parameters = new Parameters(value);
            if (processedKey.equals("Export-Package")) {
                this._exportPackageParameters.mergeWith(parameters, true);
            } else if (processedKey.equals("Import-Package")) {
                this._importPackageParameters.mergeWith(parameters, true);
            }
            analyzer.setProperty(processedKey, parameters.toString());
        }
    }

    private void _processExtraRequirements() {
        Attrs attrs = new Attrs(_optionalAttrs);
        attrs.put("x-liferay-compatibility:", "spring");
        this._importPackageParameters.add("org.eclipse.core.runtime", attrs);
        this._importPackageParameters.add("!junit.*", new Attrs());
    }

    private void _processFiles(Map<String, File> classPath, Analyzer analyzer) throws IOException {
        Jar jar = analyzer.getJar();
        Map<String, Resource> resources = jar.getResources();
        Set<Map.Entry<String, Resource>> entrySet = resources.entrySet();
        Iterator<Map.Entry<String, Resource>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Resource> entry = iterator.next();
            String path = entry.getKey();
            if (path.equals("WEB-INF/service.xml")) {
                this._processServicePackageName(entry.getValue());
                continue;
            }
            if (path.startsWith("WEB-INF/lib/")) {
                if (path.endsWith("-service.jar") && !path.endsWith(this._context.concat("-service.jar")) || this._ignoredResourcePaths.contains(path)) {
                    iterator.remove();
                    continue;
                }
                Resource resource = entry.getValue();
                if (!(resource instanceof FileResource)) continue;
                FileResource fileResource = (FileResource)resource;
                classPath.put(path, fileResource.getFile());
                this._appendProperty(analyzer, "Bundle-ClassPath", path);
                continue;
            }
            if (!this._ignoredResourcePaths.contains(path)) continue;
            iterator.remove();
        }
    }

    private void _processImportPackageNames(Analyzer analyzer) {
        String packageName = MapUtil.getString(this._parameters, (String)"Import-Package");
        if (Validator.isNotNull((String)packageName)) {
            analyzer.setProperty("Import-Package", packageName);
        } else {
            StringBundler sb = new StringBundler(this._importPackageParameters.size() * 4 + 1);
            for (Map.Entry<String, Attrs> entry : this._importPackageParameters.entrySet()) {
                String importPackageName = entry.getKey();
                boolean containedInClasspath = false;
                for (Jar jar : analyzer.getClasspath()) {
                    List<String> packages = jar.getPackages();
                    if (!packages.contains(importPackageName)) continue;
                    containedInClasspath = true;
                    break;
                }
                if (containedInClasspath) continue;
                sb.append(importPackageName);
                Attrs attrs = entry.getValue();
                if (!attrs.isEmpty()) {
                    sb.append(";");
                    sb.append((Object)entry.getValue());
                }
                sb.append(",");
            }
            sb.append("*;resolution:=\"optional\"");
            analyzer.setProperty("Import-Package", sb.toString());
        }
    }

    private void _processLiferayPortletXML() throws IOException {
        File file = new File(this._pluginDir, "WEB-INF/liferay-portlet.xml");
        if (!file.exists()) {
            return;
        }
        Document document = this._readDocument(file);
        Element rootElement = document.getRootElement();
        for (Element element : rootElement.elements("portlet")) {
            Element strutsPathElement = element.element("struts-path");
            if (strutsPathElement == null) continue;
            String strutsPath = strutsPathElement.getTextTrim();
            if (!strutsPath.startsWith("/")) {
                strutsPath = "/".concat(strutsPath);
            }
            strutsPathElement.setText("/o".substring(1) + this._context + strutsPath);
        }
        this._formatDocument(file, document);
    }

    private void _processOSGiConfigurator(Jar jar, Builder analyzer) {
        Stream<Resource> resources = jar.getResources(resourceName -> resourceName.startsWith("OSGI-INF/configurator/"));
        if (resources.count() != 0L) {
            this._appendProperty(analyzer, "Require-Capability", _REQUIRE_CAPABILITY_OSGI_CONFIGURATOR);
        }
    }

    private void _processPackageNames(Analyzer analyzer) {
        this._processExportPackageNames(analyzer);
        this._processImportPackageNames(analyzer);
    }

    private void _processPluginPackagePropertiesExportImportPackages(Properties pluginPackageProperties) {
        String importPackage;
        if (pluginPackageProperties == null) {
            return;
        }
        String exportPackage = pluginPackageProperties.getProperty("Export-Package");
        if (Validator.isNotNull((String)exportPackage)) {
            Parameters parameters = new Parameters(exportPackage);
            this._exportPackageParameters.mergeWith(parameters, true);
            pluginPackageProperties.remove("Export-Package");
        }
        if (Validator.isNotNull((String)(importPackage = pluginPackageProperties.getProperty("Import-Package")))) {
            Parameters parameters = new Parameters(importPackage);
            this._importPackageParameters.mergeWith(parameters, true);
            pluginPackageProperties.remove("Import-Package");
        }
    }

    private void _processPortalListenerClassesDependencies(Analyzer analyzer) {
        File file = new File(this._pluginDir, "WEB-INF/web.xml");
        if (!file.exists()) {
            return;
        }
        Document document = this._readDocument(file);
        Element rootElement = document.getRootElement();
        List contextParamElements = rootElement.elements("context-param");
        for (Element contextParamElement : contextParamElements) {
            String[] portalListenerClassNames;
            String paramName = contextParamElement.elementText("param-name");
            if (!Validator.isNotNull((String)paramName) || !paramName.equals("portalListenerClasses")) continue;
            String paramValue = contextParamElement.elementText("param-value");
            for (String portalListenerClassName : portalListenerClassNames = StringUtil.split((String)paramValue, (String)",")) {
                this._processClass(analyzer, portalListenerClassName.trim());
            }
        }
    }

    private void _processPropertiesDependencies(Analyzer analyzer, File file, String[] knownPropertyKeys) {
        block20: {
            if (!file.exists()) {
                return;
            }
            try (FileInputStream inputStream = new FileInputStream(file);){
                Properties properties = new Properties();
                properties.load(inputStream);
                if (properties.isEmpty()) {
                    return;
                }
                for (String key : knownPropertyKeys) {
                    String value = properties.getProperty(key);
                    if (value == null) continue;
                    value = value.trim();
                    this._processClass(analyzer, value);
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block20;
                _log.debug((Throwable)exception);
            }
        }
    }

    private void _processPropertiesDependencies(Analyzer analyzer, Path path, String suffix, String[] knownPropertyKeys) throws IOException {
        File file = path.toFile();
        if (!file.isDirectory()) {
            return;
        }
        Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);
        Stream<File> fileStream = pathStream.map(Path::toFile);
        fileStream.forEach(entry -> {
            String pathString = entry.getPath();
            if (pathString.endsWith(suffix)) {
                this._processPropertiesDependencies(analyzer, (File)entry, knownPropertyKeys);
            }
        });
    }

    private void _processRequiredDeploymentContexts(Analyzer analyzer) {
        if (this._pluginPackage == null) {
            return;
        }
        List requiredDeploymentContexts = this._pluginPackage.getRequiredDeploymentContexts();
        if (ListUtil.isEmpty((List)requiredDeploymentContexts)) {
            return;
        }
        StringBundler sb = new StringBundler(6 * requiredDeploymentContexts.size() - 1);
        for (int i = 0; i < requiredDeploymentContexts.size(); ++i) {
            String requiredDeploymentContext = (String)requiredDeploymentContexts.get(i);
            sb.append(requiredDeploymentContext);
            sb.append(";");
            sb.append("bundle-version");
            sb.append("=");
            sb.append(this._bundleVersion);
            if (i + 1 >= requiredDeploymentContexts.size()) continue;
            sb.append(",");
        }
        analyzer.setProperty("Require-Bundle", sb.toString());
    }

    private void _processResourceActionXML() throws IOException {
        File dir = new File(this._pluginDir, "WEB-INF/classes");
        URI uri = dir.toURI();
        URLClassLoader classLoader = new URLClassLoader(new URL[]{uri.toURL()});
        if (classLoader.getResource("portlet.properties") == null) {
            return;
        }
        Configuration configuration = ConfigurationFactoryUtil.getConfiguration((ClassLoader)classLoader, (String)"portlet");
        Properties properties = configuration.getProperties();
        for (String xmlFile : StringUtil.split((String)properties.getProperty("resource.actions.configs"))) {
            this._processResourceActionXML(dir, xmlFile);
        }
    }

    private void _processResourceActionXML(File dir, String xmlFile) throws IOException {
        File file = new File(dir, xmlFile);
        if (!file.exists()) {
            return;
        }
        Document document = this._readDocument(file);
        Element rootElement = document.getRootElement();
        String servletContextName = this._context.substring(1);
        for (Element portletResourceElement : rootElement.elements("portlet-resource")) {
            Element portletNameElement = portletResourceElement.element("portlet-name");
            portletNameElement.setText(JS.getSafeName(StringBundler.concat((String[])new String[]{portletNameElement.getTextTrim(), "_WAR_", servletContextName})));
        }
        for (Element modelResourceElement : rootElement.elements("model-resource")) {
            Element portletRefElement = modelResourceElement.element("portlet-ref");
            for (Element portletNameElement : portletRefElement.elements("portlet-name")) {
                portletNameElement.setText(JS.getSafeName(StringBundler.concat((String[])new String[]{portletNameElement.getTextTrim(), "_WAR_", servletContextName})));
            }
        }
        this._formatDocument(file, document);
        if (!xmlFile.endsWith("-ext.xml")) {
            this._processResourceActionXML(dir, StringUtil.replace((String)xmlFile, (String)".xml", (String)"-ext.xml"));
        }
        for (Element resourceFileElement : rootElement.elements("resource")) {
            this._processResourceActionXML(dir, StringUtil.trim((String)resourceFileElement.attributeValue("file")));
        }
    }

    private void _processServicePackageName(Resource resource) {
        try (InputStream inputStream = resource.openInputStream();){
            String[] partialPackageNames;
            Document document = UnsecureSAXReaderUtil.read((InputStream)inputStream);
            Element rootElement = document.getRootElement();
            this._servicePackageName = rootElement.attributeValue("package-path");
            for (String partialPackageName : partialPackageNames = new String[]{"", ".exception", ".model", ".model.impl", ".service", ".service.base", ".service.http", ".service.impl", ".service.persistence", ".service.persistence.impl"}) {
                Parameters parameters = new Parameters(this._getVersionedServicePackageName(partialPackageName));
                this._exportPackageParameters.mergeWith(parameters, false);
                this._importPackageParameters.mergeWith(parameters, false);
            }
            this._importPackageParameters.add("com.liferay.portal.osgi.web.wab.generator", _optionalAttrs);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
    }

    private void _processTLDDependencies(Analyzer analyzer) throws IOException {
        File[] files;
        File dir = new File(this._pluginDir, "WEB-INF/tld");
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file2 : files = dir.listFiles(file -> {
            if (!file.isFile()) {
                return false;
            }
            String fileName = file.getName();
            return fileName.endsWith(".tld");
        })) {
            String content = FileUtil.read((File)file2);
            Matcher matcher = _tldPackagesPattern.matcher(content);
            while (matcher.find()) {
                String value = matcher.group(1);
                value = value.trim();
                this._processClass(analyzer, value);
            }
        }
    }

    private void _processWebXML(Element element, List<Element> initParamElements, Class<?> clazz) {
        if (element == null) {
            return;
        }
        String elementText = element.getTextTrim();
        if (!elementText.equals(clazz.getName())) {
            return;
        }
        for (Element initParamElement : initParamElements) {
            Element paramNameElement = initParamElement.element("param-name");
            String paramNameValue = paramNameElement.getTextTrim();
            if (!paramNameValue.equals(element.getName())) continue;
            Element paramValueElement = initParamElement.element("param-value");
            element.setText(paramValueElement.getTextTrim());
            initParamElement.detach();
            return;
        }
    }

    private void _processWebXML(String path) throws IOException {
        File file = new File(this._pluginDir, path);
        if (!file.exists()) {
            return;
        }
        Document document = this._readDocument(file);
        Element rootElement = document.getRootElement();
        for (Element element : rootElement.elements("filter")) {
            Element filterClassElement = element.element("filter-class");
            this._processWebXML(filterClassElement, element.elements("init-param"), PortalClassLoaderFilter.class);
        }
        for (Element element : rootElement.elements("servlet")) {
            Element servletClassElement = element.element("servlet-class");
            this._processWebXML(servletClassElement, element.elements("init-param"), PortalClassLoaderServlet.class);
        }
        this._formatDocument(file, document);
    }

    private void _processXMLDependencies(Analyzer analyzer, File file, String xPathExpression) {
        if (!file.exists()) {
            return;
        }
        Document document = this._readDocument(file);
        if (!document.hasContent()) {
            return;
        }
        Element rootElement = document.getRootElement();
        XPath xPath = SAXReaderUtil.createXPath((String)xPathExpression, _xsds);
        List nodes = xPath.selectNodes((Object)rootElement);
        for (Node node : nodes) {
            String text = node.getText();
            text = text.trim();
            this._processClass(analyzer, text);
        }
    }

    private void _processXMLDependencies(Analyzer analyzer, Path path, String suffix) throws IOException {
        File file = path.toFile();
        if (!file.isDirectory()) {
            return;
        }
        Stream<Path> pathStream = Files.walk(path, new FileVisitOption[0]);
        Stream<File> fileStream = pathStream.map(Path::toFile);
        fileStream.forEach(entry -> {
            String pathString = entry.getPath();
            if (pathString.endsWith(suffix)) {
                this._processXMLDependencies(analyzer, (File)entry, _XPATHS_SPRING);
            }
        });
    }

    private void _processXMLDependencies(Analyzer analyzer, String fileName, String xPathExpression) {
        File file = new File(this._pluginDir, fileName);
        this._processXMLDependencies(analyzer, file, xPathExpression);
    }

    private Document _readDocument(File file) {
        try {
            String content = FileUtil.read((File)file);
            return UnsecureSAXReaderUtil.read((String)content);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return SAXReaderUtil.createDocument();
        }
    }

    private File _transformToOSGiBundle(Jar jar) throws IOException {
        Throwable throwable = null;
        try (Builder analyzer = new Builder();){
            analyzer.setBase(this._pluginDir);
            analyzer.setJar(jar);
            analyzer.setProperty("-jsp", "*.jsp,*.jspf,*.jspx");
            analyzer.setProperty("Web-ContextPath", this._getWebContextPath());
            ArrayList<Object> disabledPlugins = new ArrayList<Object>();
            Properties properties = com.liferay.portal.kernel.util.PropsUtil.getProperties((String)"module.framework.web.generator.bnd.plugin.enabled[", (boolean)true);
            Set<Object> plugins = analyzer.getPlugins();
            for (Object plugin : plugins) {
                if (plugin instanceof DSAnnotations || plugin instanceof ServiceComponent) {
                    disabledPlugins.add(plugin);
                    continue;
                }
                Class<?> clazz = plugin.getClass();
                String name = clazz.getName() + "]";
                if (GetterUtil.getBoolean((String)properties.getProperty(name), (boolean)true)) continue;
                disabledPlugins.add(plugin);
            }
            plugins.removeAll(disabledPlugins);
            plugins.add(new JspAnalyzerPlugin());
            Properties pluginPackageProperties = this._getPluginPackageProperties();
            if (pluginPackageProperties.containsKey("portal-dependency-jars") && _log.isWarnEnabled()) {
                _log.warn((Object)"The property \"portal-dependency-jars\" is deprecated. Specified JARs may not be included in the class path.");
            }
            this._processBundleVersion(analyzer);
            this._processBundleClasspath(analyzer);
            this._processBundleSymbolicName(analyzer);
            this._processExtraHeaders(analyzer);
            this._processPluginPackagePropertiesExportImportPackages(pluginPackageProperties);
            this._processBundleManifestVersion(analyzer);
            this._processLiferayPortletXML();
            this._processWebXML("WEB-INF/web.xml");
            this._processWebXML("WEB-INF/liferay-web.xml");
            this._processResourceActionXML();
            this._processDeclarativeReferences(analyzer);
            this._processExtraRequirements();
            this._processPackageNames(analyzer);
            this._processRequiredDeploymentContexts(analyzer);
            this._processExcludedJSPs(analyzer);
            analyzer.setProperties(pluginPackageProperties);
            this._processBeans(analyzer);
            this._processOSGiConfigurator(jar, analyzer);
            try {
                jar = analyzer.build();
                File outputFile = analyzer.getOutputFile(null);
                jar.write(outputFile);
                File file = outputFile;
                return file;
            }
            catch (Exception exception) {
                try {
                    throw new IOException("Unable to calculate the manifest", exception);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private void _writeAutoDeployedWar(File pluginDir) {
        File dir = new File(PropsValues.MODULE_FRAMEWORK_WEB_GENERATOR_GENERATED_WABS_STORE_DIR);
        dir.mkdirs();
        StringBundler sb = new StringBundler(5);
        String name = this._file.getName();
        sb.append(name.substring(0, name.lastIndexOf(".")));
        sb.append("-");
        Format format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)PropsValues.INDEX_DATE_FORMAT_PATTERN);
        sb.append(format.format(new Date()));
        sb.append(".autodeployed.");
        sb.append(FileUtil.getExtension((String)name));
        try (Jar jar = new Jar(pluginDir);){
            jar.write(new File(dir, sb.toString()));
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to write JAR file for " + pluginDir), (Throwable)exception);
        }
    }

    private void _writeGeneratedWab(File file) throws IOException {
        File dir = new File(PropsValues.MODULE_FRAMEWORK_WEB_GENERATOR_GENERATED_WABS_STORE_DIR);
        dir.mkdirs();
        StringBundler sb = new StringBundler(5);
        String name = this._file.getName();
        sb.append(name.substring(0, name.lastIndexOf(".")));
        sb.append("-");
        Format format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)PropsValues.INDEX_DATE_FORMAT_PATTERN);
        sb.append(format.format(new Date()));
        sb.append(".wab.");
        sb.append(FileUtil.getExtension((String)name));
        FileUtil.copyFile((File)file, (File)new File(dir, sb.toString()));
    }

    static {
        String[] autoDeployListenerClassNames;
        _AUTODEPLOYED_WARS_STORE = GetterUtil.getBoolean((String)com.liferay.portal.kernel.util.PropsUtil.get((String)"module.framework.web.generator.autodeployed.wars.store"));
        _CDI_ARCHIVE_VERSION = new Version(1, 1, 0);
        _KNOWN_PROPERTY_KEYS = new String[]{"jdbc.driverClassName"};
        _REQUIRE_CAPABILITY_CDI = StringBundler.concat((String[])new String[]{"osgi.cdi.extension;filter:='(osgi.cdi.extension=aries.cdi.http)',", "osgi.cdi.extension;filter:='(osgi.cdi.extension=aries.cdi.el.jsp)',", "osgi.cdi.extension;filter:='(osgi.cdi.extension=", "com.liferay.bean.portlet.cdi.extension)'"});
        _XPATHS_HOOK = StringUtil.merge((Object[])new String[]{"//indexer-post-processor-impl", "//service-impl", "//servlet-filter-impl", "//struts-action-impl"}, (String)"|");
        _XPATHS_JAVAEE = StringUtil.merge((Object[])new String[]{"//j2ee:filter-class", "//j2ee:listener-class", "//j2ee:servlet-class", "//javaee:filter-class", "//javaee:listener-class", "//javaee:servlet-class"}, (String)"|");
        _XPATHS_LIFERAY = StringUtil.merge((Object[])new String[]{"//asset-renderer-factory", "//atom-collection-adapter", "//configuration-action-class", "//control-panel-entry-class", "//custom-attributes-display", "//friendly-url-mapper-class", "//indexer-class", "//open-search-class", "//permission-propagator", "//poller-processor-class", "//pop-message-listener-class", "//portlet-data-handler-class", "//portlet-layout-listener-class", "//portlet-url-class", "//social-activity-interpreter-class", "//social-request-interpreter-class", "//url-encoder-class", "//webdav-storage-class", "//workflow-handler", "//xml-rpc-method-class"}, (String)"|");
        _XPATHS_PORTLET = StringUtil.merge((Object[])new String[]{"//portlet2:filter-class", "//portlet2:listener-class", "//portlet2:portlet-class", "//portlet2:resource-bundle"}, (String)"|");
        _XPATHS_SPRING = StringUtil.merge((Object[])new String[]{"//beans:bean/@class", "//beans:*/@value-type", "//aop:*/@implement-interface", "//aop:*/@default-impl", "//context:load-time-weaver/@weaver-class", "//jee:jndi-lookup/@expected-type", "//jee:jndi-lookup/@proxy-interface", "//jee:remote-slsb/@ejbType", "//jee:*/@business-interface", "//lang:*/@script-interfaces", "//osgi:*/@interface", "//gemini-blueprint:*/@interface", "//blueprint:*/@interface", "//blueprint:*/@class", "//util:list/@list-class", "//util:set/@set-class", "//util:map/@map-class", "//webflow-config:*/@class"}, (String)"|");
        _log = LogFactoryUtil.getLog(WabProcessor.class);
        _optionalAttrs = new Attrs(){
            {
                this.put("resolution:", "optional");
            }
        };
        _tldPackagesPattern = Pattern.compile("<[^>]+?-class>\\p{Space}*?(.*?)\\p{Space}*?</[^>]+?-class>");
        _versionMavenPattern = Pattern.compile("(\\d{1,9})(\\.(\\d{1,9})(\\.(\\d{1,9})(-([-_\\da-zA-Z]+))?)?)?");
        _xsds = ConcurrentHashMapBuilder.put((Object)"aop", (Object)"http://www.springframework.org/schema/aop").put((Object)"beans", (Object)"http://www.springframework.org/schema/beans").put((Object)"blueprint", (Object)"http://www.osgi.org/xmlns/blueprint/v1.0.0").put((Object)"cdi-beans", (Object)"http://xmlns.jcp.org/xml/ns/javaee").put((Object)"context", (Object)"http://www.springframework.org/schema/context").put((Object)"gemini-blueprint", (Object)"http://www.eclipse.org/gemini/blueprint/schema/blueprint").put((Object)"j2ee", (Object)"http://java.sun.com/xml/ns/j2ee").put((Object)"javaee", (Object)"http://java.sun.com/xml/ns/javaee").put((Object)"jee", (Object)"http://www.springframework.org/schema/jee").put((Object)"jms", (Object)"http://www.springframework.org/schema/jms").put((Object)"lang", (Object)"http://www.springframework.org/schema/lang").put((Object)"osgi", (Object)"http://www.springframework.org/schema/osgi").put((Object)"osgi-compendium", (Object)"http://www.springframework.org/schema/osgi-compendium").put((Object)"portlet2", (Object)"http://java.sun.com/xml/ns/portlet/portlet-app_2_0.xsd").put((Object)"tool", (Object)"http://www.springframework.org/schema/tool").put((Object)"tx", (Object)"http://www.springframework.org/schema/tx").put((Object)"util", (Object)"http://www.springframework.org/schema/util").put((Object)"webflow-config", (Object)"http://www.springframework.org/schema/webflow-config").put((Object)"xsl", (Object)"http://www.w3.org/1999/XSL/Transform").build();
        ArrayList<AutoDeployListener> autoDeployListeners = new ArrayList<AutoDeployListener>();
        for (String autoDeployListenerClassName : autoDeployListenerClassNames = PropsUtil.getArray((String)"auto.deploy.listeners")) {
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Instantiating " + autoDeployListenerClassName));
                }
                AutoDeployListener autoDeployListener = (AutoDeployListener)InstanceFactory.newInstance((String)autoDeployListenerClassName);
                autoDeployListeners.add(autoDeployListener);
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to initialiaze auto deploy listener", (Throwable)exception);
            }
        }
        _autoDeployListeners = autoDeployListeners;
    }
}

