/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;

public class MethodParametersAttribute
implements Attribute {
    public static final String NAME = "MethodParameters";
    public final MethodParameter[] parameters;

    MethodParametersAttribute(MethodParameter[] parameters) {
        this.parameters = parameters;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String toString() {
        return "MethodParameters " + Arrays.toString(this.parameters);
    }

    static MethodParametersAttribute parseMethodParametersAttribute(DataInput in, ConstantPool constant_pool) throws IOException {
        int parameters_count = in.readUnsignedByte();
        MethodParameter[] parameters = new MethodParameter[parameters_count];
        for (int i = 0; i < parameters_count; ++i) {
            parameters[i] = MethodParameter.parseMethodParameter(in, constant_pool);
        }
        return new MethodParametersAttribute(parameters);
    }

    public static class MethodParameter {
        public final String name;
        public final int access_flags;

        MethodParameter(String name, int access_flags) {
            this.name = name;
            this.access_flags = access_flags;
        }

        public String toString() {
            return this.name + ":" + this.access_flags;
        }

        static MethodParameter parseMethodParameter(DataInput in, ConstantPool constant_pool) throws IOException {
            int name_index = in.readUnsignedShort();
            int access_flags = in.readUnsignedShort();
            return new MethodParameter(constant_pool.utf8(name_index), access_flags);
        }
    }
}

