/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.osgi.Processor;
import aQute.libg.glob.Glob;
import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Instruction {
    private static final String ESCAPING = "(?<!(?<!(?<!(?<!\\\\)\\\\)\\\\)\\\\)";
    private static final Pattern WILDCARD = Pattern.compile("(?<!(?<!(?<!(?<!\\\\)\\\\)\\\\)\\\\)[*?|({\\[]");
    private static final Pattern BACKSLASH = Pattern.compile("(?<!(?<!(?<!(?<!\\\\)\\\\)\\\\)\\\\)\\\\");
    private static final Pattern ANY = Pattern.compile(".*");
    private final String input;
    private final String match;
    private final boolean negated;
    private final boolean duplicate;
    private final boolean literal;
    private final boolean any;
    private final int matchFlags;
    private Pattern pattern;
    private boolean optional;

    public Instruction(String input) {
        if (input == null || input.isEmpty()) {
            input = "!*";
        }
        this.input = input;
        if (input.equals("*")) {
            this.any = true;
            this.literal = false;
            this.match = null;
            this.negated = false;
            this.matchFlags = 0;
            this.duplicate = false;
            return;
        }
        this.any = false;
        String s = Processor.removeDuplicateMarker(input);
        this.duplicate = !s.equals(input);
        int start = 0;
        int end = s.length();
        if (s.charAt(start) == '!') {
            this.negated = true;
            ++start;
        } else {
            this.negated = false;
        }
        int flags = 0;
        if (s.endsWith(":i")) {
            flags = 2;
            end -= 2;
        }
        if (s.charAt(start) == '=') {
            this.match = s.substring(start + 1, end);
            this.literal = true;
            this.matchFlags = flags | 0x10;
            return;
        }
        if (s.regionMatches(end - 2, ".*", 0, 2)) {
            s = s.substring(start, end - 2) + "(?:.*)?";
            this.literal = false;
        } else {
            boolean bl = this.literal = !WILDCARD.matcher(s = s.substring(start, end)).find();
        }
        if (this.literal) {
            this.match = s.indexOf(92) < 0 ? s : BACKSLASH.matcher(s).replaceAll("");
            this.matchFlags = flags | 0x10;
        } else {
            this.match = s;
            this.matchFlags = flags;
            this.pattern = Glob.toPattern(this.match, this.matchFlags);
        }
    }

    public static Instruction legacy(String input) {
        if (input.equals("*")) {
            return new Instruction(input, null, null, false, 0, true, false, false);
        }
        String s = Processor.removeDuplicateMarker(input);
        boolean duplicate = !s.equals(input);
        int start = 0;
        int end = s.length();
        boolean negated = false;
        if (s.charAt(start) == '!') {
            negated = true;
            ++start;
        }
        int matchFlags = 0;
        if (s.endsWith(":i")) {
            matchFlags = 2;
            end -= 2;
        }
        if (s.charAt(start) == '=') {
            return new Instruction(input, s.substring(start + 1, end), null, negated, matchFlags, false, true, duplicate);
        }
        boolean wildcards = false;
        StringBuilder sb = new StringBuilder();
        block7: for (int c = start; c < end; ++c) {
            switch (s.charAt(c)) {
                case '.': {
                    if (c == end - 2 && '*' == s.charAt(c + 1)) {
                        sb.append("(\\..*)?");
                        wildcards = true;
                        break block7;
                    }
                    sb.append("\\.");
                    continue block7;
                }
                case '*': {
                    sb.append(".*");
                    wildcards = true;
                    continue block7;
                }
                case '$': {
                    sb.append("\\$");
                    continue block7;
                }
                case '?': {
                    sb.append(".?");
                    wildcards = true;
                    continue block7;
                }
                case '|': {
                    sb.append('|');
                    wildcards = true;
                    continue block7;
                }
                default: {
                    sb.append(s.charAt(c));
                }
            }
        }
        if (wildcards) {
            return new Instruction(input, sb.toString(), null, negated, matchFlags, false, false, duplicate);
        }
        return new Instruction(input, s.substring(start, end), null, negated, matchFlags, false, true, duplicate);
    }

    public Instruction(Pattern pattern) {
        this(pattern, false);
    }

    public Instruction(Pattern pattern, boolean negated) {
        this(pattern.pattern(), pattern.pattern(), pattern, negated, pattern.flags(), false, false, false);
    }

    private Instruction(String input, String match, Pattern pattern, boolean negated, int matchFlags, boolean any, boolean literal, boolean duplicate) {
        this.input = input;
        this.match = match;
        this.pattern = pattern;
        this.negated = negated;
        this.matchFlags = matchFlags;
        this.any = any;
        this.literal = literal;
        this.duplicate = duplicate;
    }

    public boolean matches(String value) {
        if (this.any) {
            return true;
        }
        if (this.literal) {
            if ((this.matchFlags & 2) != 0) {
                return this.match.equalsIgnoreCase(value);
            }
            return this.match.equals(value);
        }
        return this.getMatcher(value).matches();
    }

    public boolean isNegated() {
        return this.negated;
    }

    public String getPattern() {
        return this.pattern == null ? null : this.pattern.pattern();
    }

    public String getInput() {
        return this.input;
    }

    public String toString() {
        return this.input;
    }

    private Pattern pattern() {
        if (this.pattern == null) {
            this.pattern = this.match == null ? ANY : Pattern.compile(this.match, this.matchFlags);
        }
        return this.pattern;
    }

    public Matcher getMatcher(String value) {
        return this.pattern().matcher(value);
    }

    public void setOptional() {
        this.optional = true;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public boolean isLiteral() {
        return this.literal;
    }

    public String getLiteral() {
        assert (this.literal);
        return this.match;
    }

    public boolean isDuplicate() {
        return this.duplicate;
    }

    public boolean isAny() {
        return this.any;
    }

    public boolean finds(String value) {
        return this.getMatcher(value).find();
    }

    public static class Filter
    implements FileFilter {
        private Instruction instruction;
        private boolean recursive;
        private Pattern doNotCopy;

        public Filter(Instruction instruction, boolean recursive, Pattern doNotCopy) {
            this.instruction = instruction;
            this.recursive = recursive;
            this.doNotCopy = doNotCopy;
        }

        public Filter(Instruction instruction, boolean recursive) {
            this(instruction, recursive, Pattern.compile("CVS|\\.svn|\\.git|\\.DS_Store|\\.gitignore"));
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        @Override
        public boolean accept(File pathname) {
            if (this.doNotCopy != null && this.doNotCopy.matcher(pathname.getName()).matches()) {
                return false;
            }
            if (pathname.isDirectory() && this.isRecursive()) {
                return true;
            }
            if (this.instruction == null) {
                return true;
            }
            return this.instruction.matches(pathname.getName()) ^ this.instruction.isNegated();
        }
    }
}

