/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.generator.internal;

import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.kernel.dependency.manager.DependencyManagerSyncUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.osgi.web.wab.generator.internal.artifact.ArtifactURLUtil;
import com.liferay.portal.osgi.web.wab.generator.internal.artifact.WarArtifactUrlTransformer;
import com.liferay.portal.osgi.web.wab.generator.internal.handler.WabURLStreamHandlerService;
import com.liferay.portal.osgi.web.wab.generator.internal.processor.WabProcessor;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.url.URLStreamHandlerService;
import org.osgi.util.tracker.BundleTracker;

@Component(service={com.liferay.portal.osgi.web.wab.generator.WabGenerator.class})
public class WabGenerator
implements com.liferay.portal.osgi.web.wab.generator.WabGenerator {
    private static final Log _log = LogFactoryUtil.getLog(WabGenerator.class);
    private ServiceRegistration<FileInstaller> _serviceRegistration;
    @Reference(target="(&(original.bean=true)(bean.id=javax.servlet.ServletContext))")
    private ServletContext _servletContext;

    public File generate(ClassLoader classLoader, File file, Map<String, String[]> parameters) throws IOException {
        WabProcessor wabProcessor = new WabProcessor(classLoader, file, parameters);
        return wabProcessor.getProcessedFile();
    }

    @Activate
    protected void activate(BundleContext bundleContext) throws Exception {
        this._registerURLStreamHandlerService(bundleContext);
        this._registerArtifactUrlTransformer(bundleContext);
        DependencyManagerSyncUtil.registerSyncCallable(() -> {
            final Set<String> requiredForStartupContextPaths = this._getRequiredForStartupContextPaths(Paths.get(PropsValues.LIFERAY_HOME, "osgi/war"));
            if (requiredForStartupContextPaths.isEmpty()) {
                return null;
            }
            final CountDownLatch countDownLatch = new CountDownLatch(1);
            BundleTracker<Void> bundleTracker = new BundleTracker<Void>(bundleContext, 32, null){

                public Void addingBundle(Bundle bundle, BundleEvent bundleEvent) {
                    String location = bundle.getLocation();
                    if (_log.isDebugEnabled()) {
                        _log.debug((Object)("Activated bundle " + location));
                    }
                    if (requiredForStartupContextPaths.remove(HttpComponentsUtil.getParameter((String)location, (String)"Web-ContextPath", (boolean)false))) {
                        if (_log.isDebugEnabled()) {
                            _log.debug((Object)("Bundle " + location + " is required for startup"));
                        }
                        if (requiredForStartupContextPaths.isEmpty()) {
                            countDownLatch.countDown();
                        }
                    }
                    return null;
                }
            };
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Bundles required for startup: " + requiredForStartupContextPaths));
            }
            bundleTracker.open();
            while (!countDownLatch.await(1L, TimeUnit.MINUTES)) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Waiting on startup required bundles to activate: " + requiredForStartupContextPaths));
            }
            bundleTracker.close();
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"All startup required bundles are active");
            }
            return null;
        });
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) throws Exception {
        this._serviceRegistration.unregister();
        this._serviceRegistration = null;
    }

    private Set<String> _getRequiredForStartupContextPaths(Path path) throws Exception {
        HashSet<String> contextPaths = new HashSet<String>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(path.toRealPath(new LinkOption[0]), "*.war");){
            for (Path warPath : directoryStream) {
                URI uri = warPath.toUri();
                ZipFile zipFile = new ZipFile(new File(uri));
                Throwable throwable = null;
                try {
                    InputStream inputStream = zipFile.getInputStream(new ZipEntry("WEB-INF/liferay-plugin-package.properties"));
                    Throwable throwable2 = null;
                    try {
                        if (inputStream == null) continue;
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        if (!Boolean.valueOf(properties.getProperty("required-for-startup")).booleanValue()) continue;
                        String contextName = properties.getProperty("servlet-context-name");
                        if (contextName == null) {
                            contextName = ArtifactURLUtil.getSymbolicName(uri.getPath());
                        }
                        contextPaths.add("/".concat(contextName));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (zipFile == null) continue;
                    if (throwable != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    zipFile.close();
                }
            }
        }
        return contextPaths;
    }

    private void _registerArtifactUrlTransformer(BundleContext bundleContext) {
        this._serviceRegistration = bundleContext.registerService(FileInstaller.class, (Object)new WarArtifactUrlTransformer(), null);
    }

    private void _registerURLStreamHandlerService(BundleContext bundleContext) {
        Bundle bundle = bundleContext.getBundle(0L);
        Class<?> clazz = bundle.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        bundleContext.registerService(URLStreamHandlerService.class.getName(), (Object)new WabURLStreamHandlerService(classLoader, this), (Dictionary)HashMapDictionaryBuilder.put((Object)"url.handler.protocol", (Object)new String[]{"webbundle"}).build());
    }
}

