/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.generator.internal.artifact;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ArtifactURLUtil {
    private static final Log _log = LogFactoryUtil.getLog(ArtifactURLUtil.class);
    private static final Pattern _pattern = Pattern.compile("(.*?)(-[0-9\\.]+)");

    public static String getClientExtensionSymbolicName(String path) {
        int x = path.lastIndexOf(47);
        int y = path.lastIndexOf(46);
        return path.substring(x + 1, y);
    }

    public static String getSymbolicName(String path) {
        int y;
        int x = path.lastIndexOf(47);
        String symbolicName = path.substring(x + 1, y = path.lastIndexOf(46));
        Matcher matcher = _pattern.matcher(symbolicName);
        if (matcher.matches()) {
            symbolicName = matcher.group(1);
        }
        return symbolicName;
    }

    public static URL transform(URL artifact) throws Exception {
        String contextName = null;
        String path = artifact.getPath();
        String fileExtension = path.substring(path.lastIndexOf(46) + 1);
        if (fileExtension.equals("war")) {
            try (ZipFile zipFile = new ZipFile(new File(artifact.toURI()));){
                contextName = ArtifactURLUtil._readServletContextName(zipFile);
            }
        }
        String symbolicName = ArtifactURLUtil.getSymbolicName(path);
        if (fileExtension.equals("zip") && ArtifactURLUtil._isClientExtensionZip(path)) {
            symbolicName = ArtifactURLUtil.getClientExtensionSymbolicName(path);
        }
        if (contextName == null) {
            contextName = symbolicName;
        }
        return new URL("webbundle", null, StringBundler.concat((String[])new String[]{artifact.getPath(), "?", "Bundle-SymbolicName", "=", symbolicName, "&Web-ContextPath=/", contextName, "&fileExtension=", fileExtension, "&protocol=file"}));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean _isClientExtensionZip(String path) {
        try (ZipFile zipFile = new ZipFile(path);){
            ZipEntry zipEntry;
            String name;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            do {
                if (!enumeration.hasMoreElements()) return false;
            } while (!(name = (zipEntry = enumeration.nextElement()).getName()).endsWith(".client-extension-config.json") || name.indexOf("/") != -1);
            boolean bl = true;
            return bl;
        }
        catch (IOException ioException) {
            _log.error((Object)("Path " + path + " is not a valid ZIP"), (Throwable)ioException);
        }
        return false;
    }

    private static String _readServletContextName(ZipFile zipFile) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry("WEB-INF/liferay-plugin-package.properties");
        if (zipEntry == null) {
            return null;
        }
        Properties properties = new Properties();
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
            properties.load(inputStream);
        }
        return properties.getProperty("servlet-context-name");
    }
}

