/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.generator.internal.artifact;

import com.liferay.portal.file.install.FileInstaller;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.osgi.web.wab.generator.internal.artifact.ArtifactURLUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Enumeration;
import java.util.Objects;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class WarArtifactUrlTransformer
implements FileInstaller {
    private static final Log _log = LogFactoryUtil.getLog(WarArtifactUrlTransformer.class);

    public boolean canTransformURL(File artifact) {
        String name = artifact.getName();
        return name.endsWith(".war") || name.endsWith(".zip") && this._isClientExtensionZip(artifact);
    }

    public URL transformURL(File artifact) throws Exception {
        URI uri = artifact.toURI();
        return ArtifactURLUtil.transform(uri.toURL());
    }

    public void uninstall(File file) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean _isClientExtensionZip(File artifact) {
        try (ZipFile zipFile = new ZipFile(artifact);){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!Objects.equals(name, "WEB-INF/liferay-plugin-package.properties") && (!name.endsWith(".client-extension-config.json") || name.indexOf("/") != -1)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException ioException) {
            _log.error((Object)("Unable to check if " + artifact + " is a client extension"), (Throwable)ioException);
            return false;
        }
    }
}

