/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;

public class LineNumberTableAttribute
implements Attribute {
    public static final String NAME = "LineNumberTable";
    public final LineNumber[] line_number_table;

    LineNumberTableAttribute(LineNumber[] line_number_table) {
        this.line_number_table = line_number_table;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String toString() {
        return "LineNumberTable " + Arrays.toString(this.line_number_table);
    }

    static LineNumberTableAttribute parseLineNumberTableAttribute(DataInput in, ConstantPool constant_pool) throws IOException {
        int line_number_table_length = in.readUnsignedShort();
        LineNumber[] line_number_table = new LineNumber[line_number_table_length];
        for (int i = 0; i < line_number_table_length; ++i) {
            line_number_table[i] = LineNumber.parseLineNumber(in, constant_pool);
        }
        return new LineNumberTableAttribute(line_number_table);
    }

    public static class LineNumber {
        public final int start_pc;
        public final int line_number;

        LineNumber(int start_pc, int line_number) {
            this.start_pc = start_pc;
            this.line_number = line_number;
        }

        public String toString() {
            return this.start_pc + ":" + this.line_number;
        }

        static LineNumber parseLineNumber(DataInput in, ConstantPool constant_pool) throws IOException {
            int start_pc = in.readUnsignedShort();
            int line_number = in.readUnsignedShort();
            return new LineNumber(start_pc, line_number);
        }
    }
}

