/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.classfile;

import aQute.bnd.classfile.Attribute;
import aQute.bnd.classfile.ConstantPool;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;

public class LocalVariableTableAttribute
implements Attribute {
    public static final String NAME = "LocalVariableTable";
    public final LocalVariable[] local_variable_table;

    LocalVariableTableAttribute(LocalVariable[] local_variable_table) {
        this.local_variable_table = local_variable_table;
    }

    @Override
    public String name() {
        return NAME;
    }

    public String toString() {
        return "LocalVariableTable " + Arrays.toString(this.local_variable_table);
    }

    static LocalVariableTableAttribute parseLocalVariableTableAttribute(DataInput in, ConstantPool constant_pool) throws IOException {
        int local_variable_table_length = in.readUnsignedShort();
        LocalVariable[] local_variable_table = new LocalVariable[local_variable_table_length];
        for (int i = 0; i < local_variable_table_length; ++i) {
            local_variable_table[i] = LocalVariable.parseLocalVariable(in, constant_pool);
        }
        return new LocalVariableTableAttribute(local_variable_table);
    }

    public static class LocalVariable {
        public final int start_pc;
        public final int length;
        public final String name;
        public final String descriptor;
        public final int index;

        LocalVariable(int start_pc, int length, String name, String descriptor, int index) {
            this.start_pc = start_pc;
            this.length = length;
            this.name = name;
            this.descriptor = descriptor;
            this.index = index;
        }

        public String toString() {
            return this.start_pc + ":" + this.length + ":" + this.name + ":" + this.descriptor + ":" + this.index;
        }

        static LocalVariable parseLocalVariable(DataInput in, ConstantPool constant_pool) throws IOException {
            int start_pc = in.readUnsignedShort();
            int length = in.readUnsignedShort();
            int name_index = in.readUnsignedShort();
            int descriptor_index = in.readUnsignedShort();
            int index = in.readUnsignedShort();
            return new LocalVariable(start_pc, length, constant_pool.utf8(name_index), constant_pool.utf8(descriptor_index), index);
        }
    }
}

