/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.help;

import aQute.bnd.help.SpecialConverter;
import aQute.bnd.help.Syntax;
import aQute.bnd.osgi.Processor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

class ProcessorHandler
implements InvocationHandler {
    final Processor processor;
    static final SpecialConverter converter = new SpecialConverter();

    public ProcessorHandler(Processor processor) {
        this.processor = processor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, new Object[0]);
        }
        String name = Syntax.toInstruction(method);
        String value = this.processor.mergeProperties(name);
        if (value == null) {
            if (args != null && args.length == 1) {
                return args[0];
            }
            if (method.getDefaultValue() != null) {
                return method.getDefaultValue();
            }
        }
        return converter.convertNeverNull(method.getGenericReturnType(), value);
    }

    public static <T> T getInstructions(Processor processor, Class<T> type) {
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new ProcessorHandler(processor));
    }

    public String toString() {
        return this.processor.toString() + "'";
    }
}

