/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.signatures;

import aQute.bnd.signatures.ReferenceTypeSignature;
import aQute.bnd.signatures.Signatures;
import aQute.lib.stringrover.StringRover;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;

public class TypeParameter {
    static final TypeParameter[] EMPTY = new TypeParameter[0];
    public final String identifier;
    public final ReferenceTypeSignature classBound;
    public final ReferenceTypeSignature[] interfaceBounds;

    TypeParameter(String identifier, ReferenceTypeSignature classBound, ReferenceTypeSignature[] interfaceBounds) {
        this.identifier = identifier;
        this.classBound = classBound;
        this.interfaceBounds = interfaceBounds;
    }

    public int hashCode() {
        int result = 31 + this.identifier.hashCode();
        result = result * 31 + (this.classBound == null ? 0 : this.classBound.hashCode());
        result = result * 31 + Arrays.hashCode(this.interfaceBounds);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TypeParameter)) {
            return false;
        }
        TypeParameter other = (TypeParameter)obj;
        return Objects.equals(this.identifier, other.identifier) && Objects.equals(this.classBound, other.classBound) && Arrays.equals(this.interfaceBounds, other.interfaceBounds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.identifier).append(':');
        if (this.classBound != null) {
            sb.append(this.classBound);
        }
        for (ReferenceTypeSignature t : this.interfaceBounds) {
            sb.append(':').append(t);
        }
        return sb.toString();
    }

    static TypeParameter parseTypeParameter(StringRover signature) {
        ReferenceTypeSignature classBound;
        char c;
        int end = signature.indexOf(58, 0);
        String identifier = Signatures.intern(signature.substring(0, end));
        signature.increment(end + 1);
        char c2 = c = signature.isEmpty() ? (char)'\u0000' : signature.charAt(0);
        if (c == 'L' || c == 'T' || c == '[') {
            classBound = Signatures.parseReferenceTypeSignature(signature);
            c = signature.isEmpty() ? (char)'\u0000' : signature.charAt(0);
        } else {
            classBound = null;
        }
        if (c != ':') {
            return new TypeParameter(identifier, classBound, Signatures.EMPTY_ReferenceTypeSignature);
        }
        ArrayList<ReferenceTypeSignature> list = new ArrayList<ReferenceTypeSignature>();
        do {
            ReferenceTypeSignature item = Signatures.parseReferenceTypeSignature(signature.increment());
            list.add(item);
        } while ((c = signature.isEmpty() ? (char)'\u0000' : signature.charAt(0)) == ':');
        return new TypeParameter(identifier, classBound, list.toArray(Signatures.EMPTY_ReferenceTypeSignature));
    }

    static TypeParameter[] parseTypeParameters(StringRover signature) {
        if (signature.charAt(0) != '<') {
            return EMPTY;
        }
        signature.increment();
        ArrayList<TypeParameter> list = new ArrayList<TypeParameter>();
        do {
            TypeParameter item = TypeParameter.parseTypeParameter(signature);
            list.add(item);
        } while (signature.charAt(0) != '>');
        signature.increment();
        return list.toArray(EMPTY);
    }

    static void erasedBinaryReferences(TypeParameter[] typeParameters, Set<String> references) {
        for (TypeParameter typeParameter : typeParameters) {
            Signatures.erasedBinaryReferences(typeParameter.classBound, references);
            for (ReferenceTypeSignature interfaceBound : typeParameter.interfaceBounds) {
                Signatures.erasedBinaryReferences(interfaceBound, references);
            }
        }
    }
}

