/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ant.bnd.jsp;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.Domain;
import aQute.bnd.osgi.Instruction;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Processor;
import aQute.bnd.osgi.Resource;
import aQute.bnd.service.AnalyzerPlugin;
import aQute.lib.io.IO;
import aQute.lib.strings.Strings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class JspAnalyzerPlugin
implements AnalyzerPlugin {
    private static final String[] _JSTL_CORE_URIS = new String[]{"http://java.sun.com/jsp/jstl/core", "http://java.sun.com/jsp/jstl/fmt", "http://java.sun.com/jsp/jstl/functions", "http://java.sun.com/jsp/jstl/sql", "http://java.sun.com/jsp/jstl/xml"};
    private static final String _LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String[] _REQUIRED_PACKAGE_NAMES = new String[]{"javax.servlet", "javax.servlet.http"};
    private static final Pattern _commentPattern = Pattern.compile("<%--[\\s\\S]*?--%>");
    private static final Pattern _packagePattern = Pattern.compile("[_A-Za-z$][_A-Za-z0-9$]*(\\.[_A-Za-z$][_A-Za-z0-9$]*)*");
    private static final Pattern _staticImportPattern = Pattern.compile("\\s*static\\s+((?<package>(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)+)(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*\\.)(\\*|(\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)))\\s*");
    private static final Pattern _tldPattern = Pattern.compile(".*\\.tld");
    private final SAXParserFactory _saxParserFactory = SAXParserFactory.newInstance();

    @Override
    public boolean analyzeJar(Analyzer analyzer) throws Exception {
        this.addManifestPackageImports(analyzer);
        Parameters parameters = OSGiHeader.parseHeader(analyzer.getProperty("-jsp"));
        if (parameters.isEmpty()) {
            return false;
        }
        Instructions instructions = new Instructions(parameters);
        boolean matches = false;
        Jar jar = analyzer.getJar();
        Map<String, Resource> resources = jar.getResources();
        HashSet<String> keys = new HashSet<String>(resources.keySet());
        HashSet<String> taglibURIs = new HashSet<String>();
        block0: for (String key : keys) {
            for (Instruction instruction : instructions.keySet()) {
                if (!instruction.matches(key)) continue;
                if (instruction.isNegated()) continue block0;
                Resource resource = jar.getResource(key);
                String jsp = IO.collect(resource.openInputStream(), "UTF-8");
                this.addApiUses(analyzer, jsp);
                this.addTaglibRequirements(analyzer, jsp, taglibURIs);
                matches = true;
            }
        }
        if (matches) {
            this.addRequiredPackageImports(analyzer, _REQUIRED_PACKAGE_NAMES);
        }
        return false;
    }

    protected void addApiUses(Analyzer analyzer, String originalContent) {
        String content = this._removeComments(originalContent);
        int contentX = -1;
        int contentY = content.length();
        while ((contentX = content.lastIndexOf("<%@", contentY)) != -1) {
            contentY = contentX;
            int importX = content.indexOf("import=\"", contentY);
            int importY = -1;
            if (importX != -1) {
                importY = content.indexOf("\"", importX += "import=\"".length());
            }
            if (importX != -1 && importY != -1) {
                String[] packageFragments;
                String contentFragment = content.substring(importX, importY);
                for (String packageFragment : packageFragments = contentFragment.split("\\s*,\\s*")) {
                    int index = packageFragment.lastIndexOf(46);
                    Matcher matcher = _staticImportPattern.matcher(packageFragment);
                    if (matcher.matches()) {
                        packageFragment = matcher.group("package");
                        packageFragment = packageFragment.substring(0, packageFragment.length() - 1);
                        index = packageFragment.length();
                    }
                    if (index == -1) continue;
                    Packages packages = analyzer.getReferred();
                    String packageName = packageFragment.substring(0, index);
                    Descriptors.PackageRef packageRef = analyzer.getPackageRef(packageName);
                    packages.put(packageRef, new Attrs());
                    this.addApiUses(analyzer, packageFragment, packageRef);
                }
            }
            contentY -= 3;
        }
    }

    protected void addApiUses(Analyzer analyzer, String content, Descriptors.PackageRef packageRef) {
        for (Jar jar : analyzer.getClasspath()) {
            this.addJarApiUses(analyzer, content, packageRef, jar);
        }
    }

    protected void addJarApiUses(Analyzer analyzer, String content, Descriptors.PackageRef packageRef, Jar jar) {
        Map<String, Map<String, Resource>> resourceMaps = jar.getDirectories();
        Map<String, Resource> resourceMap = resourceMaps.get(packageRef.getPath());
        if (resourceMap == null || resourceMap.isEmpty()) {
            return;
        }
        if (content.endsWith("*")) {
            for (Map.Entry<String, Resource> entry : resourceMap.entrySet()) {
                String key = entry.getKey();
                if (!key.endsWith(".class")) continue;
                this.addResourceApiUses(analyzer, key, entry.getValue());
            }
        } else {
            String fqnToPath = Descriptors.fqnToPath(content);
            if (resourceMap.containsKey(fqnToPath)) {
                Resource resource = resourceMap.get(fqnToPath);
                this.addResourceApiUses(analyzer, content, resource);
            }
        }
    }

    protected void addManifestPackageImports(Analyzer analyzer) {
        Packages packages = analyzer.getClasspathExports();
        for (Jar jar : analyzer.getClasspath()) {
            try {
                Manifest manifest = jar.getManifest();
                if (manifest == null) continue;
                Domain domain = Domain.domain(manifest);
                Parameters parameters = domain.getExportPackage();
                for (Map.Entry<String, Attrs> entry : parameters.entrySet()) {
                    Descriptors.PackageRef packageRef = analyzer.getPackageRef(entry.getKey());
                    Attrs attrs = packages.get(packageRef);
                    if (!attrs.isEmpty()) continue;
                    packages.put(packageRef, entry.getValue());
                }
            }
            catch (Exception exception) {
            }
        }
    }

    protected void addRequiredPackageImports(Analyzer analyzer, String[] packageNames) {
        Packages packages = analyzer.getReferred();
        for (String packageName : packageNames) {
            Descriptors.PackageRef packageRef = analyzer.getPackageRef(packageName);
            Matcher matcher = _packagePattern.matcher(packageRef.getFQN());
            if (!matcher.matches() || packages.containsKey(packageRef)) continue;
            packages.put(packageRef, new Attrs());
        }
    }

    protected void addResourceApiUses(Analyzer analyzer, String fqnToPath, Resource resource) {
        Clazz clazz = null;
        try {
            InputStream inputStream = resource.openInputStream();
            Object object = null;
            try {
                clazz = new Clazz(analyzer, fqnToPath, resource);
                clazz.parseClassFile();
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            return;
        }
        Set<Descriptors.PackageRef> packageRefs = clazz.getAPIUses();
        for (Descriptors.PackageRef packageRef : packageRefs) {
            Packages packages = analyzer.getReferred();
            packages.put(packageRef, new Attrs());
        }
    }

    protected void addTaglibRequirement(Set<String> taglibRequirements, String uri) {
        Parameters parameters = new Parameters();
        Attrs attrs = new Attrs();
        attrs.put("filter:", "\"(&(osgi.extender=jsp.taglib)(uri=" + uri + "))\"");
        parameters.put("osgi.extender", attrs);
        taglibRequirements.add(parameters.toString());
    }

    protected void addTaglibRequirements(Analyzer analyzer, String content, Set<String> taglibURIs) {
        TreeSet<String> taglibRequirements = new TreeSet<String>();
        for (String uri : this.getTaglibURIs(content)) {
            if (taglibURIs.contains(uri)) continue;
            taglibURIs.add(uri);
            if (this.containsTLD(analyzer, analyzer.getJar(), "META-INF", uri) || this.containsTLD(analyzer, analyzer.getJar(), "META-INF/resources", uri) || this.containsTLD(analyzer, analyzer.getJar(), "WEB-INF/tld", uri) || this.containsTLDInBundleClassPath(analyzer, "META-INF", uri) || this.containsTLDInBundleClassPath(analyzer, "META-INF/resources", uri) || Arrays.binarySearch(_JSTL_CORE_URIS, uri) >= 0) continue;
            this.addTaglibRequirement(taglibRequirements, uri);
        }
        if (taglibRequirements.isEmpty()) {
            return;
        }
        String value = analyzer.getProperty("Require-Capability");
        if (value != null) {
            Parameters parameters = OSGiHeader.parseHeader(value);
            for (Map.Entry<String, Attrs> entry : parameters.entrySet()) {
                String key = Processor.removeDuplicateMarker(entry.getKey());
                StringBuilder sb = new StringBuilder(key);
                Attrs attrs = entry.getValue();
                if (attrs != null) {
                    sb.append(";");
                    attrs.append(sb);
                }
                taglibRequirements.add(sb.toString());
            }
        }
        analyzer.setProperty("Require-Capability", Strings.join(taglibRequirements));
    }

    protected boolean containsTLD(Analyzer analyzer, Jar jar, String root, String uri) {
        Map<String, Map<String, Resource>> resourceMaps = jar.getDirectories();
        Map<String, Resource> resourceMap = resourceMaps.get(root);
        if (resourceMap == null || resourceMap.isEmpty()) {
            Resource resource = jar.getResource(root);
            return resource != null && this.matchesURI(analyzer, root, resource, uri);
        }
        for (Map.Entry<String, Resource> entry : resourceMap.entrySet()) {
            String path = entry.getKey();
            Resource resource = entry.getValue();
            Matcher matcher = _tldPattern.matcher(path);
            if (!matcher.matches() || !this.matchesURI(analyzer, path, resource, uri)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean containsTLDInBundleClassPath(Analyzer analyzer, String root, String uri) {
        Parameters parameters = new Parameters(analyzer.getProperty("Bundle-ClassPath"));
        if (parameters.isEmpty()) {
            return false;
        }
        Jar jar = analyzer.getJar();
        Iterator<String> iterator = parameters.keySet().iterator();
        while (iterator.hasNext()) {
            Resource resource;
            String entry = iterator.next();
            String entryLowerCase = entry.toLowerCase();
            if (!entryLowerCase.endsWith(".jar") && !entryLowerCase.endsWith(".zip") || (resource = jar.getResource(entry)) == null) continue;
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Throwable throwable = null;
                try {
                    resource.write(byteArrayOutputStream);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    Throwable throwable2 = null;
                    try {
                        Jar classPathJar = new Jar(entry, inputStream);
                        if (!this.containsTLD(analyzer, classPathJar, root, uri)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable2 != null) {
                            try {
                                ((InputStream)inputStream).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        ((InputStream)inputStream).close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (byteArrayOutputStream == null) continue;
                    if (throwable != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    byteArrayOutputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    protected Set<String> getTaglibURIs(String originalContent) {
        String s;
        int importY;
        int importX;
        String noCommentsContent;
        String content = noCommentsContent = this._removeComments(originalContent);
        int contentX = -1;
        int contentY = content.length();
        HashSet<String> taglibURis = new HashSet<String>();
        while ((contentX = content.lastIndexOf("<%@", contentY)) != -1) {
            contentY = contentX;
            importX = content.indexOf("uri=\"", contentY);
            importY = -1;
            if (importX != -1) {
                importY = content.indexOf("\"", importX += "uri=\"".length());
            }
            if (importX != -1 && importY != -1) {
                s = content.substring(importX, importY);
                taglibURis.add(s);
            }
            contentY -= 3;
        }
        if (noCommentsContent.contains("jsp:root")) {
            content = noCommentsContent;
            contentX = -1;
            contentY = content.length();
            while ((contentX = content.lastIndexOf("xmlns:", contentY)) != -1) {
                contentY = contentX;
                importX = content.indexOf("xmlns:", contentY);
                importY = -1;
                if (importX != -1) {
                    importX = content.indexOf("\"", importX) + 1;
                    importY = content.indexOf("\"", importX);
                }
                if (importX != -1 && importY != -1) {
                    s = content.substring(importX, importY);
                    taglibURis.add(s);
                }
                --contentY;
            }
        }
        return taglibURis;
    }

    protected boolean matchesURI(Analyzer analyzer, String path, Resource resource, String uri) {
        try {
            URIFinder uriFinder = new URIFinder(uri);
            SAXParser saxParser = this._saxParserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setContentHandler(uriFinder);
            xmlReader.setFeature(_LOAD_EXTERNAL_DTD, false);
            xmlReader.setEntityResolver(new NullEntityResolver());
            xmlReader.parse(new InputSource(resource.openInputStream()));
            return uriFinder.hasURI();
        }
        catch (Exception exception) {
            analyzer.error("Unexpected exception in processing TLD " + path + ": " + exception, new Object[0]);
            return false;
        }
    }

    private String _removeComments(String content) {
        Matcher matcher = _commentPattern.matcher(content);
        return matcher.replaceAll("");
    }

    private class URIFinder
    extends DefaultHandler {
        private boolean _hasURI;
        private boolean _inURI;
        private final String _uri;

        public URIFinder(String uri) {
            this._uri = uri;
        }

        @Override
        public void characters(char[] chars, int start, int length) throws SAXException {
            if (!this._inURI) {
                return;
            }
            this._hasURI = this._uri.equals(this._trim(chars, start, length));
            this._inURI = false;
        }

        public boolean hasURI() {
            return this._hasURI;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("uri")) {
                this._inURI = true;
            }
        }

        private String _trim(char[] chars, int start, int length) {
            int i;
            int end = start + length;
            for (i = start; i < end && Character.isWhitespace(chars[i]); ++i) {
                ++start;
            }
            for (i = end - 1; i >= start && Character.isWhitespace(chars[i]); --i) {
                --end;
            }
            return new String(chars, start, end - start);
        }
    }

    private class NullEntityResolver
    implements EntityResolver {
        private NullEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            return new InputSource();
        }
    }
}

