/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.osgi.web.wab.generator.internal.connection;

import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.osgi.web.wab.generator.WabGenerator;
import com.liferay.portal.util.FastDateFormatFactoryImpl;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.HttpImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;

public class WabURLConnection
extends URLConnection {
    private final ClassLoader _classLoader;
    private final WabGenerator _wabGenerator;

    public WabURLConnection(ClassLoader classLoader, WabGenerator wabGenerator, URL url) {
        super(url);
        this._classLoader = classLoader;
        this._wabGenerator = wabGenerator;
        this.wireSpringUtils();
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        Object[] portalProfileNames;
        URL url = this.getURL();
        Map parameters = HttpUtil.getParameterMap((String)url.getQuery());
        if (!parameters.containsKey("Web-ContextPath")) {
            throw new IllegalArgumentException("The parameter map does not contain the required parameter Web-ContextPath");
        }
        String path = url.getPath();
        Object[] protocols = (String[])parameters.get("protocol");
        if (ArrayUtil.isEmpty((Object[])protocols)) {
            if (path.startsWith("file:")) {
                path = path.substring(5);
                protocols = new String[]{"file"};
            } else {
                throw new IllegalArgumentException("The parameter map does not contain the required parameter protocol");
            }
        }
        if (ArrayUtil.isNotEmpty((Object[])(portalProfileNames = (String[])parameters.get("liferay-portal-profile-names")))) {
            path = path.concat("?liferay-portal-profile-names=");
            path = path.concat(StringUtil.merge((Object[])portalProfileNames));
        }
        final File file = this.transferToTempFile(new URL((String)protocols[0], null, path));
        File processedFile = this._wabGenerator.generate(this._classLoader, file, parameters);
        return new FileInputStream(processedFile){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    FileUtil.deltree((File)file.getParentFile());
                }
            }
        };
    }

    protected File transferToTempFile(URL url) throws IOException {
        String path = url.getPath();
        String fileName = path.substring(path.lastIndexOf("/") + 1);
        File file = new File(FileUtil.createTempFolder(), fileName);
        StreamUtil.transfer((InputStream)url.openStream(), (OutputStream)new FileOutputStream(file));
        return file;
    }

    protected void wireSpringUtils() {
        FastDateFormatFactoryUtil instance;
        if (FastDateFormatFactoryUtil.getFastDateFormatFactory() == null) {
            instance = new FastDateFormatFactoryUtil();
            instance.setFastDateFormatFactory((FastDateFormatFactory)new FastDateFormatFactoryImpl());
        }
        if (FileUtil.getFile() == null) {
            instance = new FileUtil();
            instance.setFile((com.liferay.portal.kernel.util.File)new FileImpl());
        }
        if (HttpUtil.getHttp() == null) {
            instance = new HttpUtil();
            instance.setHttp((Http)new HttpImpl());
        }
    }
}

