/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.output.stream.container.internal;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.output.stream.container.OutputStreamContainer;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactory;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactoryTracker;
import com.liferay.portal.output.stream.container.internal.ConsoleOutputStreamContainerFactory;
import com.liferay.portal.output.stream.container.internal.DummyOutputStreamContainerFactory;
import com.liferay.portal.output.stream.container.internal.TempFileOutputStreamContainerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={OutputStreamContainerFactoryTracker.class})
public class OutputStreamContainerFactoryTrackerImpl
implements OutputStreamContainerFactoryTracker {
    private static final Log _log = LogFactoryUtil.getLog(OutputStreamContainerFactoryTrackerImpl.class);
    private ServiceTrackerMap<String, OutputStreamContainerFactory> _outputStreamContainerFactories;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile OutputStreamContainerFactory _outputStreamContainerFactory;
    private final List<ServiceRegistration<?>> _serviceRegistrations = new ArrayList();
    private WriterAppender _writerAppender;
    private final ThreadLocal<Writer> _writerThreadLocal = new ThreadLocal();

    @Deprecated
    public OutputStreamContainerFactory getOutputStreamContainerFactory() {
        return this._outputStreamContainerFactory;
    }

    public OutputStreamContainerFactory getOutputStreamContainerFactory(String outputStreamContainerFactoryName) {
        if (outputStreamContainerFactoryName == null) {
            return this._outputStreamContainerFactory;
        }
        OutputStreamContainerFactory outputStreamContainerFactory = (OutputStreamContainerFactory)this._outputStreamContainerFactories.getService((Object)outputStreamContainerFactoryName);
        if (outputStreamContainerFactory == null) {
            throw new IllegalArgumentException("No output stream container factory registered with name " + outputStreamContainerFactoryName);
        }
        return outputStreamContainerFactory;
    }

    public Set<String> getOutputStreamContainerFactoryNames() {
        return this._outputStreamContainerFactories.keySet();
    }

    @Deprecated
    public void runWithSwappedLog(Runnable runnable, String outputStreamHint) {
        OutputStreamContainerFactory outputStreamContainerFactory = this.getOutputStreamContainerFactory(null);
        OutputStreamContainer outputStreamContainer = outputStreamContainerFactory.create(outputStreamHint);
        this.runWithSwappedLog(runnable, outputStreamContainer.getDescription(), outputStreamContainer.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithSwappedLog(Runnable runnable, String outputStreamName, OutputStream outputStream) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Using " + outputStreamName + " as output"));
        }
        Writer writer = this._writerThreadLocal.get();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, Charset.forName("UTF-8"));
        this._writerThreadLocal.set(outputStreamWriter);
        try {
            runnable.run();
        }
        finally {
            this._writerThreadLocal.set(writer);
            try {
                outputStreamWriter.flush();
            }
            catch (IOException ioException) {
                _log.error((Object)ioException.getLocalizedMessage());
            }
        }
    }

    @Deprecated
    public void runWithSwappedLog(Runnable runnable, String outputStreamHint, String outputStreamContainerName) {
        OutputStreamContainerFactory outputStreamContainerFactory = this.getOutputStreamContainerFactory(outputStreamContainerName);
        OutputStreamContainer outputStreamContainer = outputStreamContainerFactory.create(outputStreamHint);
        this.runWithSwappedLog(runnable, outputStreamContainer.getDescription(), outputStreamContainer.getOutputStream());
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        Logger rootLogger = Logger.getRootLogger();
        this._writerAppender = new WriterAppender((Layout)new SimpleLayout(), (Writer)new ThreadLocalWriter());
        this._writerAppender.setThreshold((Priority)Level.ALL);
        this._writerAppender.activateOptions();
        rootLogger.addAppender((Appender)this._writerAppender);
        HashMapDictionary dictionary = new HashMapDictionary();
        dictionary.put("name", "console");
        dictionary.put("service.ranking:Integer", "100");
        this._serviceRegistrations.add(bundleContext.registerService(OutputStreamContainerFactory.class, (Object)new ConsoleOutputStreamContainerFactory(), (Dictionary)dictionary));
        dictionary.put("name", "dummy");
        dictionary.put("service.ranking:Integer", "-100");
        this._serviceRegistrations.add(bundleContext.registerService(OutputStreamContainerFactory.class, (Object)new DummyOutputStreamContainerFactory(), (Dictionary)dictionary));
        dictionary.put("name", "temp_file");
        dictionary.remove("service.ranking:Integer");
        this._serviceRegistrations.add(bundleContext.registerService(OutputStreamContainerFactory.class, (Object)new TempFileOutputStreamContainerFactory(), (Dictionary)dictionary));
        this._outputStreamContainerFactories = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, OutputStreamContainerFactory.class, (String)"name");
    }

    @Deactivate
    protected void deactivate() {
        if (this._outputStreamContainerFactories != null) {
            this._outputStreamContainerFactories.close();
        }
        for (ServiceRegistration<?> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
        this._serviceRegistrations.clear();
        Logger rootLogger = Logger.getRootLogger();
        if (rootLogger != null) {
            rootLogger.removeAppender((Appender)this._writerAppender);
        }
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    private class ThreadLocalWriter
    extends Writer {
        private ThreadLocalWriter() {
        }

        @Override
        public void close() throws IOException {
            Writer writer = (Writer)OutputStreamContainerFactoryTrackerImpl.this._writerThreadLocal.get();
            if (writer != null) {
                writer.close();
            }
        }

        @Override
        public void flush() throws IOException {
            Writer writer = (Writer)OutputStreamContainerFactoryTrackerImpl.this._writerThreadLocal.get();
            if (writer != null) {
                writer.flush();
            }
        }

        @Override
        public void write(char[] chars, int offset, int length) throws IOException {
            Writer writer = (Writer)OutputStreamContainerFactoryTrackerImpl.this._writerThreadLocal.get();
            if (writer != null) {
                writer.write(chars, offset, length);
            }
        }
    }
}

