/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.output.stream.container.internal;

import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.output.stream.container.OutputStreamContainer;
import com.liferay.portal.output.stream.container.OutputStreamContainerFactory;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class TempFileOutputStreamContainerFactory
implements OutputStreamContainerFactory {
    public OutputStreamContainer create(String hint) {
        try {
            Path tempDirectoryPath = Files.createTempDirectory("com_liferay_portal_output_stream_container_internal_TempFileOutputStreamContainerFactory", new FileAttribute[0]);
            final Path tempFilePath = Files.createTempFile(tempDirectoryPath, hint, ".log", new FileAttribute[0]);
            return new OutputStreamContainer(){

                public String getDescription() {
                    Path absolutePath = tempFilePath.toAbsolutePath();
                    return absolutePath.toString();
                }

                public OutputStream getOutputStream() {
                    try {
                        return StreamUtil.uncloseable((OutputStream)new FileOutputStream(tempFilePath.toFile()));
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new RuntimeException(fileNotFoundException);
                    }
                }
            };
        }
        catch (IOException ioException) {
            throw new RuntimeException(ioException);
        }
    }
}

