/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.remote.cxf.common.internal;

import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.access.control.AccessControlThreadLocal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.remote.cxf.common.configuration.CXFEndpointPublisherConfiguration;
import com.liferay.portal.servlet.filters.authverifier.AuthVerifierFilter;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.transport.servlet.CXFNonSpringServlet;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ServiceDependency;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.http.context.ServletContextHelper;

@Component(configurationPid={"com.liferay.portal.remote.cxf.common.configuration.CXFEndpointPublisherConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class CXFEndpointPublisher {
    private DependencyManager _dependencyManager;

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._dependencyManager = new DependencyManager(bundleContext);
        org.apache.felix.dm.Component component = this._dependencyManager.createComponent();
        CXFEndpointPublisherConfiguration cxfEndpointPublisherConfiguration = (CXFEndpointPublisherConfiguration)ConfigurableUtil.createConfigurable(CXFEndpointPublisherConfiguration.class, properties);
        ServicesRegistrator servicesRegistrator = new ServicesRegistrator(bundleContext, properties);
        component.setImplementation((Object)servicesRegistrator);
        String[] extensions = cxfEndpointPublisherConfiguration.extensions();
        if (extensions != null) {
            for (String extension : extensions) {
                ServiceDependency serviceDependency = this._dependencyManager.createServiceDependency();
                serviceDependency.setCallbacks((Object)servicesRegistrator, "addExtension", null);
                serviceDependency.setRequired(true);
                serviceDependency.setService(Object.class, extension);
                component.add(new Dependency[]{serviceDependency});
            }
        }
        this._dependencyManager.add(component);
    }

    @Deactivate
    protected void deactivate() {
        this._dependencyManager.clear();
    }

    @Modified
    protected void modified(BundleContext bundleContext, Map<String, Object> properties) {
        this.deactivate();
        this.activate(bundleContext, properties);
    }

    private static class ServicesRegistrator {
        private static final Log _log = LogFactoryUtil.getLog(CXFEndpointPublisher.class);
        private ServiceRegistration<Filter> _authVerifierFilterServiceRegistration;
        private final BundleContext _bundleContext;
        private ServiceRegistration<Bus> _busServiceRegistration;
        private final Map<Class<?>, Object> _extensions = new HashMap();
        private final Map<String, Object> _properties;
        private ServiceRegistration<Filter> _remoteAccessFilterServiceRegistration;
        private ServiceRegistration<ServletContextHelper> _servletContextHelperServiceRegistration;
        private ServiceRegistration<Servlet> _servletServiceRegistration;

        public ServicesRegistrator(BundleContext bundleContext, Map<String, Object> properties) {
            this._bundleContext = bundleContext;
            this._properties = properties;
        }

        protected void addExtension(Map<String, Object> properties, Object extension) {
            Class<?> extensionClass = (Class<?>)properties.get("cxf.extension.class");
            if (extensionClass == null) {
                extensionClass = extension.getClass();
            }
            this._extensions.put(extensionClass, extension);
        }

        protected void start() {
            Hashtable<String, String> properties = new Hashtable<String, String>();
            String contextPath = String.valueOf(this._properties.get("contextPath"));
            String contextName = contextPath.substring(1);
            contextName = StringUtil.replace((String)contextName, (char)'/', (char)'.');
            ((Dictionary)properties).put("osgi.http.whiteboard.context.name", contextName);
            ((Dictionary)properties).put("osgi.http.whiteboard.context.path", contextPath);
            this._servletContextHelperServiceRegistration = this._bundleContext.registerService(ServletContextHelper.class, (Object)new ServletContextHelper(this._bundleContext.getBundle()){}, properties);
            CXFNonSpringServlet cxfNonSpringServlet = new CXFNonSpringServlet();
            CXFBusFactory cxfBusFactory = (CXFBusFactory)CXFBusFactory.newInstance((String)CXFBusFactory.class.getName());
            Bus bus = cxfBusFactory.createBus(this._extensions);
            ServiceReference serviceReference = this._servletContextHelperServiceRegistration.getReference();
            properties = new Hashtable();
            String httpWhiteboardContextSelect = "(service.id=" + serviceReference.getProperty("service.id") + ")";
            ((Dictionary)properties).put("osgi.http.whiteboard.context.select", httpWhiteboardContextSelect);
            ((Dictionary)properties).put("osgi.http.whiteboard.servlet.name", CXFNonSpringServlet.class.getName());
            ((Dictionary)properties).put("osgi.http.whiteboard.servlet.pattern", "/*");
            Object property = ((Dictionary)properties).get("servlet.init.hide-service-list-page");
            if (property == null) {
                ((Dictionary)properties).put("servlet.init.hide-service-list-page", "true");
            }
            cxfNonSpringServlet.setBus(bus);
            this._servletServiceRegistration = this._bundleContext.registerService(Servlet.class, (Object)cxfNonSpringServlet, properties);
            Object authVerifierPropertiesObject = this._properties.get("authVerifierProperties");
            if (authVerifierPropertiesObject != null) {
                String[] authVerifierPropertiesArray = null;
                authVerifierPropertiesArray = authVerifierPropertiesObject instanceof String ? new String[]{(String)authVerifierPropertiesObject} : (String[])authVerifierPropertiesObject;
                properties = new Hashtable();
                ((Dictionary)properties).put("osgi.http.whiteboard.context.select", httpWhiteboardContextSelect);
                ((Dictionary)properties).put("osgi.http.whiteboard.filter.name", AuthVerifierFilter.class.getName());
                ((Dictionary)properties).put("osgi.http.whiteboard.filter.servlet", CXFNonSpringServlet.class.getName());
                for (String authVerifierProperty : authVerifierPropertiesArray) {
                    String[] authVerifierPropertyParts = authVerifierProperty.split("=");
                    ((Dictionary)properties).put("filter.init." + authVerifierPropertyParts[0], authVerifierPropertyParts[1]);
                }
                this._authVerifierFilterServiceRegistration = this._bundleContext.registerService(Filter.class, (Object)new AuthVerifierFilter(), properties);
                properties = new Hashtable();
                ((Dictionary)properties).put("osgi.http.whiteboard.context.select", httpWhiteboardContextSelect);
                ((Dictionary)properties).put("osgi.http.whiteboard.filter.name", RemoteAccessFilter.class.getName());
                ((Dictionary)properties).put("osgi.http.whiteboard.filter.servlet", CXFNonSpringServlet.class.getName());
                this._remoteAccessFilterServiceRegistration = this._bundleContext.registerService(Filter.class, (Object)new RemoteAccessFilter(), properties);
            }
            properties = new Hashtable();
            ((Dictionary)properties).put("osgi.http.whiteboard.context.path", contextPath);
            this._busServiceRegistration = this._bundleContext.registerService(Bus.class, (Object)bus, properties);
        }

        protected void stop() {
            block16: {
                block15: {
                    block14: {
                        block13: {
                            block12: {
                                try {
                                    this._busServiceRegistration.unregister();
                                }
                                catch (Exception exception) {
                                    if (!_log.isWarnEnabled()) break block12;
                                    _log.warn((Object)("Unable to unregister CXF bus service registration " + this._busServiceRegistration), (Throwable)exception);
                                }
                            }
                            if (this._remoteAccessFilterServiceRegistration != null) {
                                try {
                                    this._remoteAccessFilterServiceRegistration.unregister();
                                }
                                catch (Exception exception) {
                                    if (!_log.isWarnEnabled()) break block13;
                                    _log.warn((Object)("Unable to unregister RemoteAccessFilter registration " + this._remoteAccessFilterServiceRegistration), (Throwable)exception);
                                }
                            }
                        }
                        if (this._authVerifierFilterServiceRegistration != null) {
                            try {
                                this._authVerifierFilterServiceRegistration.unregister();
                            }
                            catch (Exception exception) {
                                if (!_log.isWarnEnabled()) break block14;
                                _log.warn((Object)("Unable to unregister AuthVerifierFilter registration " + this._authVerifierFilterServiceRegistration), (Throwable)exception);
                            }
                        }
                    }
                    try {
                        this._servletServiceRegistration.unregister();
                    }
                    catch (Exception exception) {
                        if (!_log.isWarnEnabled()) break block15;
                        _log.warn((Object)("Unable to unregister servlet service registration " + this._servletServiceRegistration), (Throwable)exception);
                    }
                }
                try {
                    this._servletContextHelperServiceRegistration.unregister();
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) break block16;
                    _log.warn((Object)("Unable to unregister servlet context helper service registration " + this._servletContextHelperServiceRegistration), (Throwable)exception);
                }
            }
        }

        private static class RemoteAccessFilter
        implements Filter {
            private RemoteAccessFilter() {
            }

            public void destroy() {
            }

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
                boolean remoteAccess = AccessControlThreadLocal.isRemoteAccess();
                try {
                    AccessControlThreadLocal.setRemoteAccess((boolean)true);
                    chain.doFilter(servletRequest, servletResponse);
                }
                catch (Exception exception) {
                    throw new ServletException((Throwable)exception);
                }
                finally {
                    AccessControlThreadLocal.setRemoteAccess((boolean)remoteAccess);
                }
            }

            public void init(FilterConfig filterConfig) throws ServletException {
            }
        }
    }
}

